/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.annotation;

import java.lang.reflect.Method;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;

public class ProviderSqlSource
implements SqlSource {
    private SqlSourceBuilder sqlSourceParser;
    private Class providerType;
    private Method providerMethod;
    private boolean providerTakesParameterObject;

    public ProviderSqlSource(Configuration config, Object provider) {
        try {
            this.sqlSourceParser = new SqlSourceBuilder(config);
            this.providerType = (Class)provider.getClass().getMethod("type", new Class[0]).invoke(provider, new Object[0]);
            String providerMethod = (String)provider.getClass().getMethod("method", new Class[0]).invoke(provider, new Object[0]);
            for (Method m : this.providerType.getMethods()) {
                if (!providerMethod.equals(m.getName()) || m.getParameterTypes().length >= 2 || m.getReturnType() != String.class) continue;
                this.providerMethod = m;
                this.providerTakesParameterObject = m.getParameterTypes().length == 1;
            }
        }
        catch (Exception e) {
            throw new BuilderException("Error creating SqlSource for SqlProvider.  Cause: " + e, e);
        }
    }

    public BoundSql getBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        return sqlSource.getBoundSql(parameterObject);
    }

    private SqlSource createSqlSource(Object parameterObject) {
        try {
            String sql = this.providerTakesParameterObject ? (String)this.providerMethod.invoke(this.providerType.newInstance(), parameterObject) : (String)this.providerMethod.invoke(this.providerType.newInstance(), new Object[0]);
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            return this.sqlSourceParser.parse(sql, parameterType);
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + ").  Cause: " + e, e);
        }
    }
}

