/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.client.ClientPartitionAwarenessMapper;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClientCacheAffinityMapping {
    private static final CacheAffinityInfo NOT_APPLICABLE_CACHE_AFFINITY_INFO = new CacheAffinityInfo(null, null, null);
    private final AffinityTopologyVersion topVer;
    private final Map<Integer, CacheAffinityInfo> cacheAffinity = new HashMap<Integer, CacheAffinityInfo>();
    private final Collection<Integer> cacheIds = Collections.unmodifiableCollection(this.cacheAffinity.keySet());

    private ClientCacheAffinityMapping(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Collection<Integer> cacheIds() {
        return this.cacheIds;
    }

    public UUID affinityNode(IgniteBinary binary, int cacheId, Object key) {
        CacheAffinityInfo affinityInfo = this.cacheAffinity.get(cacheId);
        if (affinityInfo == null || affinityInfo == NOT_APPLICABLE_CACHE_AFFINITY_INFO) {
            return null;
        }
        Object binaryKey = binary.toBinary(key);
        if (!affinityInfo.keyCfg.isEmpty()) {
            int typeId = binary.typeId(key.getClass().getName());
            Integer fieldId = (Integer)affinityInfo.keyCfg.get(typeId);
            if (fieldId != null) {
                if (binaryKey instanceof BinaryObjectExImpl) {
                    binaryKey = ((BinaryObjectExImpl)binaryKey).field(fieldId);
                } else {
                    return null;
                }
            }
        }
        return affinityInfo.nodeForKey(binaryKey);
    }

    public UUID affinityNode(int cacheId, int part) {
        CacheAffinityInfo affInfo = this.cacheAffinity.get(cacheId);
        if (affInfo == null || affInfo == NOT_APPLICABLE_CACHE_AFFINITY_INFO) {
            return null;
        }
        return affInfo.nodeForPartition(part);
    }

    public static ClientCacheAffinityMapping merge(ClientCacheAffinityMapping ... mappings) {
        assert (!F.isEmpty(mappings));
        ClientCacheAffinityMapping res = new ClientCacheAffinityMapping(mappings[0].topVer);
        for (ClientCacheAffinityMapping mapping : mappings) {
            assert (res.topVer.equals(mapping.topVer)) : "Mappings must have identical topology versions [res.topVer=" + res.topVer + ", mapping.topVer=" + mapping.topVer + ']';
            res.cacheAffinity.putAll(mapping.cacheAffinity);
        }
        return res;
    }

    public static void writeRequest(PayloadOutputChannel ch, Collection<Integer> cacheIds, boolean customMappingsRequired) {
        ProtocolContext ctx = ch.clientChannel().protocolCtx();
        if (customMappingsRequired && !ctx.isFeatureSupported(ProtocolBitmaskFeature.ALL_AFFINITY_MAPPINGS)) {
            throw new ClientFeatureNotSupportedByServerException(ProtocolBitmaskFeature.ALL_AFFINITY_MAPPINGS);
        }
        BinaryOutputStream out = ch.out();
        if (ctx.isFeatureSupported(ProtocolBitmaskFeature.ALL_AFFINITY_MAPPINGS)) {
            out.writeBoolean(customMappingsRequired);
        }
        out.writeInt(cacheIds.size());
        for (int cacheId : cacheIds) {
            out.writeInt(cacheId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientCacheAffinityMapping readResponse(PayloadInputChannel ch, Function<Integer, Function<Integer, ClientPartitionAwarenessMapper>> mappers) {
        try (BinaryReaderExImpl in = ClientUtils.createBinaryReader(null, ch.in());){
            long topVer = in.readLong();
            int minorTopVer = in.readInt();
            ClientCacheAffinityMapping aff = new ClientCacheAffinityMapping(new AffinityTopologyVersion(topVer, minorTopVer));
            int mappingsCnt = in.readInt();
            int i = 0;
            while (true) {
                block22: {
                    Iterator iterator;
                    boolean dfltMapping;
                    UUID[] partToNode;
                    block21: {
                        block19: {
                            int cachesCnt;
                            block20: {
                                if (i >= mappingsCnt) break block19;
                                boolean applicable = in.readBoolean();
                                cachesCnt = in.readInt();
                                if (!applicable) break block20;
                                HashMap<Integer, Map<Integer, Integer>> cacheKeyCfg = U.newHashMap(cachesCnt);
                                for (int j = 0; j < cachesCnt; ++j) {
                                    cacheKeyCfg.put(in.readInt(), ClientCacheAffinityMapping.readCacheKeyConfiguration(in));
                                }
                                partToNode = ClientCacheAffinityMapping.readNodePartitions(in);
                                dfltMapping = true;
                                if (ch.clientChannel().protocolCtx().isFeatureSupported(ProtocolBitmaskFeature.ALL_AFFINITY_MAPPINGS)) {
                                    dfltMapping = in.readBoolean();
                                }
                                iterator = cacheKeyCfg.entrySet().iterator();
                                break block21;
                            }
                            for (int j = 0; j < cachesCnt; ++j) {
                                aff.cacheAffinity.put(in.readInt(), NOT_APPLICABLE_CACHE_AFFINITY_INFO);
                            }
                            break block22;
                        }
                        ClientCacheAffinityMapping clientCacheAffinityMapping = aff;
                        return clientCacheAffinityMapping;
                    }
                    while (iterator.hasNext()) {
                        Function<Integer, ClientPartitionAwarenessMapper> factory;
                        Map.Entry keyCfg = iterator.next();
                        Function<Integer, ClientPartitionAwarenessMapper> function = factory = dfltMapping ? x$0 -> new RendezvousAffinityKeyMapper((int)x$0) : mappers.apply((Integer)keyCfg.getKey());
                        if (factory == null) continue;
                        aff.cacheAffinity.put((Integer)keyCfg.getKey(), new CacheAffinityInfo((Map)keyCfg.getValue(), partToNode, factory.apply(partToNode.length)));
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new ClientError(e);
        }
    }

    private static Map<Integer, Integer> readCacheKeyConfiguration(BinaryReaderExImpl in) {
        int keyCfgCnt = in.readInt();
        HashMap<Integer, Integer> keyCfg = U.newHashMap(keyCfgCnt);
        for (int i = 0; i < keyCfgCnt; ++i) {
            keyCfg.put(in.readInt(), in.readInt());
        }
        return keyCfg;
    }

    private static UUID[] readNodePartitions(BinaryReaderExImpl in) {
        int nodesCnt = in.readInt();
        int maxPart = -1;
        UUID[] partToNode = new UUID[1024];
        for (int i = 0; i < nodesCnt; ++i) {
            UUID nodeId = in.readUuid();
            int partCnt = in.readInt();
            for (int j = 0; j < partCnt; ++j) {
                int part = in.readInt();
                if (part > maxPart) {
                    maxPart = part;
                    if (part >= partToNode.length) {
                        partToNode = Arrays.copyOf(partToNode, U.ceilPow2(part + 1));
                    }
                }
                partToNode[part] = nodeId;
            }
        }
        return Arrays.copyOf(partToNode, maxPart + 1);
    }

    private static class RendezvousAffinityKeyMapper
    implements ClientPartitionAwarenessMapper {
        private final int parts;
        private final int affinityMask;

        private RendezvousAffinityKeyMapper(int parts) {
            this.parts = parts;
            this.affinityMask = RendezvousAffinityFunction.calculateMask(parts);
        }

        @Override
        public int partition(Object key) {
            return RendezvousAffinityFunction.calculatePartition(key, this.affinityMask, this.parts);
        }
    }

    private static class CacheAffinityInfo {
        private final Map<Integer, Integer> keyCfg;
        private final UUID[] partMapping;
        private final ClientPartitionAwarenessMapper keyMapper;

        private CacheAffinityInfo(Map<Integer, Integer> keyCfg, UUID[] partMapping, ClientPartitionAwarenessMapper keyMapper) {
            this.keyCfg = keyCfg;
            this.partMapping = partMapping;
            this.keyMapper = keyMapper;
        }

        private UUID nodeForKey(Object key) {
            if (this.keyMapper == null) {
                return null;
            }
            return this.nodeForPartition(this.keyMapper.partition(key));
        }

        private UUID nodeForPartition(int part) {
            if (part < 0 || this.partMapping == null || part >= this.partMapping.length) {
                return null;
            }
            return this.partMapping[part];
        }
    }
}

