/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.cache.CacheIndexesForceRebuildCommandArg;
import org.apache.ignite.internal.management.cache.IndexForceRebuildTaskRes;
import org.apache.ignite.internal.management.cache.IndexRebuildStatusInfoContainer;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;

@GridInternal
public class IndexForceRebuildTask
extends VisorMultiNodeTask<CacheIndexesForceRebuildCommandArg, Map<UUID, IndexForceRebuildTaskRes>, IndexForceRebuildTaskRes> {
    private static final long serialVersionUID = 0L;

    protected IndexForceRebuildJob job(CacheIndexesForceRebuildCommandArg arg) {
        return new IndexForceRebuildJob(arg, this.debug);
    }

    @Override
    protected Map<UUID, IndexForceRebuildTaskRes> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap<UUID, IndexForceRebuildTaskRes> res = new HashMap<UUID, IndexForceRebuildTaskRes>();
        for (ComputeJobResult jobRes : results) {
            if (jobRes.getException() != null) {
                throw jobRes.getException();
            }
            res.put(jobRes.getNode().id(), (IndexForceRebuildTaskRes)jobRes.getData());
        }
        return res;
    }

    private static class IndexForceRebuildJob
    extends VisorJob<CacheIndexesForceRebuildCommandArg, IndexForceRebuildTaskRes> {
        private static final long serialVersionUID = 0L;

        protected IndexForceRebuildJob(CacheIndexesForceRebuildCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected IndexForceRebuildTaskRes run(CacheIndexesForceRebuildCommandArg arg) throws IgniteException {
            assert (arg.cacheNames() == null ^ arg.groupNames() == null) : "Either cacheNames or cacheGroups must be specified.";
            HashSet<GridCacheContext> cachesToRebuild = new HashSet<GridCacheContext>();
            HashSet<String> notFound = new HashSet<String>();
            GridCacheProcessor cacheProcessor = this.ignite.context().cache();
            if (arg.cacheNames() != null) {
                for (String cacheName : arg.cacheNames()) {
                    IgniteInternalCache cache = cacheProcessor.cache(cacheName);
                    if (cache != null) {
                        cachesToRebuild.add(cache.context());
                        continue;
                    }
                    notFound.add(cacheName);
                }
            } else {
                for (String cacheGrpName : arg.groupNames()) {
                    CacheGroupContext grpCtx = cacheProcessor.cacheGroup(CU.cacheId(cacheGrpName));
                    if (grpCtx != null) {
                        cachesToRebuild.addAll(grpCtx.caches());
                        continue;
                    }
                    notFound.add(cacheGrpName);
                }
            }
            Collection<GridCacheContext> cachesCtxWithRebuildingInProgress = this.ignite.context().cache().context().database().forceRebuildIndexes(cachesToRebuild);
            Set<IndexRebuildStatusInfoContainer> cachesWithRebuildingInProgress = cachesCtxWithRebuildingInProgress.stream().map(IndexRebuildStatusInfoContainer::new).collect(Collectors.toSet());
            Set<IndexRebuildStatusInfoContainer> cachesWithStartedRebuild = cachesToRebuild.stream().map(IndexRebuildStatusInfoContainer::new).filter(c -> !cachesWithRebuildingInProgress.contains(c)).collect(Collectors.toSet());
            return new IndexForceRebuildTaskRes(cachesWithStartedRebuild, cachesWithRebuildingInProgress, notFound);
        }
    }
}

