/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.meta.MetaDetailsCommandArg;
import org.apache.ignite.internal.management.meta.MetaListCommand;
import org.apache.ignite.internal.management.meta.MetadataInfoTask;
import org.apache.ignite.internal.management.meta.MetadataListResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class MetaDetailsCommand
implements ComputeCommand<IgniteDataTransferObject, MetadataListResult> {
    @Override
    public String description() {
        return "Print detailed info about specified binary type (the type must be specified by type name or by type identifier)";
    }

    @Override
    public Class<MetaDetailsCommandArg> argClass() {
        return MetaDetailsCommandArg.class;
    }

    @Override
    public Class<MetadataInfoTask> taskClass() {
        return MetadataInfoTask.class;
    }

    @Override
    public void printResult(IgniteDataTransferObject arg, MetadataListResult res, Consumer<String> printer) {
        if (res.metadata() == null) {
            printer.accept("Type not found");
            return;
        }
        assert (res.metadata().size() == 1) : "Unexpected  metadata results: " + res.metadata();
        BinaryMetadata m = F.first(res.metadata());
        printer.accept("typeId=" + MetaListCommand.printInt(m.typeId()));
        printer.accept("typeName=" + m.typeName());
        printer.accept("Fields:");
        HashMap fldMap = new HashMap();
        m.fieldsMap().forEach((name, fldMeta) -> {
            printer.accept("  name=" + name + ", type=" + BinaryUtils.fieldTypeName(fldMeta.typeId()) + ", fieldId=" + MetaListCommand.printInt(fldMeta.fieldId()));
            fldMap.put(fldMeta.fieldId(), name);
        });
        printer.accept("Schemas:");
        m.schemas().forEach(s -> printer.accept("  schemaId=" + MetaListCommand.printInt(s.schemaId()) + ", fields=" + Arrays.stream(s.fieldIds()).mapToObj(fldMap::get).collect(Collectors.toList())));
    }
}

