/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentCommunication;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentResponse;
import org.apache.ignite.internal.managers.deployment.P2PClassNotFoundException;
import org.apache.ignite.internal.util.GridBoundedLinkedHashSet;
import org.apache.ignite.internal.util.GridByteArrayList;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

class GridDeploymentClassLoader
extends ClassLoader
implements GridDeploymentInfo {
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private final IgniteUuid id;
    private final boolean singleNode;
    @GridToStringExclude
    private final GridKernalContext ctx;
    @GridToStringExclude
    private final IgniteLogger log;
    @GridToStringExclude
    private final LinkedList<UUID> nodeList;
    @GridToStringInclude
    private final Map<UUID, IgniteUuid> nodeLdrMap;
    @GridToStringExclude
    private final GridDeploymentCommunication comm;
    private final String[] p2pExclude;
    private final long p2pTimeout;
    @GridToStringExclude
    private final GridBoundedLinkedHashSet<String> missedRsrcs;
    @GridToStringExclude
    private final ConcurrentMap<String, byte[]> byteMap;
    private final String usrVer;
    private final DeploymentMode depMode;
    private boolean quiet;
    private final Object mux = new Object();
    private final String clsLdrHierarchy = this.classLoadersHierarchy();

    GridDeploymentClassLoader(IgniteUuid id, String usrVer, DeploymentMode depMode, boolean singleNode, GridKernalContext ctx, ClassLoader parent, IgniteUuid clsLdrId, UUID nodeId, GridDeploymentCommunication comm, long p2pTimeout, IgniteLogger log, String[] p2pExclude, int missedResourcesCacheSize, boolean clsBytesCacheEnabled, boolean quiet) throws SecurityException {
        super(parent);
        assert (id != null);
        assert (depMode != null);
        assert (ctx != null);
        assert (comm != null);
        assert (p2pTimeout > 0L);
        assert (log != null);
        assert (clsLdrId != null);
        assert (nodeId.equals(clsLdrId.globalId()));
        this.id = id;
        this.usrVer = usrVer;
        this.depMode = depMode;
        this.singleNode = singleNode;
        this.ctx = ctx;
        this.comm = comm;
        this.p2pTimeout = p2pTimeout;
        this.log = log;
        this.p2pExclude = p2pExclude;
        this.nodeList = new LinkedList();
        this.nodeList.add(nodeId);
        HashMap<UUID, IgniteUuid> map = U.newHashMap(1);
        map.put(nodeId, clsLdrId);
        this.nodeLdrMap = singleNode ? Collections.unmodifiableMap(map) : map;
        this.missedRsrcs = missedResourcesCacheSize > 0 ? new GridBoundedLinkedHashSet(missedResourcesCacheSize) : null;
        this.byteMap = clsBytesCacheEnabled ? new ConcurrentHashMap() : null;
        this.quiet = quiet;
    }

    GridDeploymentClassLoader(IgniteUuid id, String usrVer, DeploymentMode depMode, boolean singleNode, GridKernalContext ctx, ClassLoader parent, Map<UUID, IgniteUuid> participants, GridDeploymentCommunication comm, long p2pTimeout, IgniteLogger log, String[] p2pExclude, int missedResourcesCacheSize, boolean clsBytesCacheEnabled, boolean quiet) throws SecurityException {
        super(parent);
        assert (id != null);
        assert (depMode != null);
        assert (ctx != null);
        assert (comm != null);
        assert (p2pTimeout > 0L);
        assert (log != null);
        assert (participants != null);
        this.id = id;
        this.usrVer = usrVer;
        this.depMode = depMode;
        this.singleNode = singleNode;
        this.ctx = ctx;
        this.comm = comm;
        this.p2pTimeout = p2pTimeout;
        this.log = log;
        this.p2pExclude = p2pExclude;
        this.nodeList = new LinkedList<UUID>(participants.keySet());
        this.nodeLdrMap = new HashMap<UUID, IgniteUuid>(participants);
        this.missedRsrcs = missedResourcesCacheSize > 0 ? new GridBoundedLinkedHashSet(missedResourcesCacheSize) : null;
        this.byteMap = clsBytesCacheEnabled ? new ConcurrentHashMap() : null;
        this.quiet = quiet;
    }

    @Override
    public IgniteUuid classLoaderId() {
        return this.id;
    }

    @Override
    public DeploymentMode deployMode() {
        return this.depMode;
    }

    @Override
    public String userVersion() {
        return this.usrVer;
    }

    @Override
    public boolean localDeploymentOwner() {
        return false;
    }

    @Override
    public long sequenceNumber() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, IgniteUuid> participants() {
        Object object = this.mux;
        synchronized (object) {
            return new HashMap<UUID, IgniteUuid>(this.nodeLdrMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(UUID nodeId, IgniteUuid ldrId) {
        assert (nodeId != null);
        assert (ldrId != null);
        assert (nodeId.equals(ldrId.globalId()));
        assert (!this.singleNode);
        Object object = this.mux;
        synchronized (object) {
            if (this.missedRsrcs != null) {
                this.missedRsrcs.clear();
            }
            this.nodeList.remove(nodeId);
            this.nodeList.addFirst(nodeId);
            this.nodeLdrMap.put(nodeId, ldrId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IgniteUuid unregister(UUID nodeId) {
        assert (nodeId != null);
        Object object = this.mux;
        synchronized (object) {
            this.nodeList.remove(nodeId);
            return this.nodeLdrMap.remove(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<UUID> registeredNodeIds() {
        Object object = this.mux;
        synchronized (object) {
            return new ArrayList<UUID>(this.nodeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<IgniteUuid> registeredClassLoaderIds() {
        LinkedList<IgniteUuid> ldrIds = new LinkedList<IgniteUuid>();
        Object object = this.mux;
        synchronized (object) {
            for (IgniteUuid ldrId : this.nodeLdrMap.values()) {
                ldrIds.add(ldrId);
            }
        }
        return ldrIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IgniteUuid registeredClassLoaderId(UUID nodeId) {
        Object object = this.mux;
        synchronized (object) {
            return this.nodeLdrMap.get(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRegisteredNode(UUID nodeId, IgniteUuid ldrId) {
        IgniteUuid ldrId0;
        assert (nodeId != null);
        assert (ldrId != null);
        Object object = this.mux;
        synchronized (object) {
            ldrId0 = this.nodeLdrMap.get(nodeId);
        }
        return ldrId0 != null && ldrId0.equals(ldrId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRegisteredNodes() {
        Object object = this.mux;
        synchronized (object) {
            return !this.nodeList.isEmpty();
        }
    }

    private boolean isLocallyExcluded(String name) {
        if (this.p2pExclude != null) {
            for (String path : this.p2pExclude) {
                if (path.endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!name.startsWith(path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        assert (!Thread.holdsLock(this.mux));
        Class<?> cls = null;
        try {
            if (!"org.apache.ignite.compute.ComputeJob".equals(name) && this.isLocallyExcluded(name)) {
                cls = this.p2pLoadClass(name, true);
            }
            if (cls == null) {
                cls = this.loadClass(name, true);
            }
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            if (X.hasCause((Throwable)e, TimeoutException.class)) {
                throw e;
            }
            throw new P2PClassNotFoundException("Failed to load class due to unexpected error: " + name, e);
        }
        return cls;
    }

    @Nullable
    private Class<?> p2pLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        assert (!Thread.holdsLock(this.mux));
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            cls = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        GridDeployment dep;
        assert (!Thread.holdsLock(this.mux));
        if (!this.isLocallyExcluded(name) && (dep = this.ctx.deploy().getLocalDeployment(name)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found class in local deployment [cls=" + name + ", dep=" + dep + ']');
            }
            return dep.deployedClass(name, new String[0]).get1();
        }
        String path = U.classNameToResourceName(name);
        GridByteArrayList byteSrc = this.sendClassRequest(name, path);
        GridDeploymentClassLoader gridDeploymentClassLoader = this;
        synchronized (gridDeploymentClassLoader) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                String pkgName;
                int i;
                Class<?> clazz = cls = this.ctx.security().sandbox().enabled() ? this.defineClass(name, byteSrc.internalArray(), 0, byteSrc.size(), PROTECTION_DOMAIN) : this.defineClass(name, byteSrc.internalArray(), 0, byteSrc.size());
                if (this.byteMap != null) {
                    this.byteMap.put(path, byteSrc.array());
                }
                if ((i = name.lastIndexOf(46)) != -1 && this.getPackage(pkgName = name.substring(0, i)) == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loaded class [cls=" + name + ", ldr=" + this + ']');
            }
            return cls;
        }
    }

    private long computeEndTime(long timeout) {
        long endTime = U.currentTimeMillis() + timeout;
        if (endTime < 0L) {
            endTime = Long.MAX_VALUE;
        }
        return endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridByteArrayList sendClassRequest(String name, String path) throws ClassNotFoundException {
        HashMap<UUID, IgniteUuid> nodeLdrMapCp;
        LinkedList<UUID> nodeListCp;
        assert (!Thread.holdsLock(this.mux));
        long endTime = this.computeEndTime(this.p2pTimeout);
        Object object = this.mux;
        synchronized (object) {
            if (this.missedRsrcs != null && this.missedRsrcs.contains(path)) {
                throw new P2PClassNotFoundException("Failed to peer load class, previous request for the same class has failed [class=" + name + ", nodeClsLdrIds=" + this.nodeLdrMap + ", clsLoadersHierarchy=" + this.clsLdrHierarchy + ']');
            }
            nodeListCp = this.singleNode ? this.nodeList : new LinkedList<UUID>(this.nodeList);
            nodeLdrMapCp = this.singleNode ? this.nodeLdrMap : new HashMap<UUID, IgniteUuid>(this.nodeLdrMap);
        }
        ArrayList<IgniteException> classRequestExceptions = new ArrayList<IgniteException>();
        for (UUID nodeId : nodeListCp) {
            String msg;
            if (nodeId.equals(this.ctx.discovery().localNode().id())) continue;
            IgniteUuid igniteUuid = (IgniteUuid)nodeLdrMapCp.get(nodeId);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Found inactive node in class loader (will skip): " + nodeId);
                continue;
            }
            try {
                GridDeploymentResponse res = this.comm.sendResourceRequest(path, igniteUuid, node, endTime);
                if (res.success()) {
                    return res.byteSource();
                }
                msg = "Failed to find class on remote node [class=" + name + ", nodeId=" + node.id() + ", clsLdrId=" + igniteUuid + ", classLoadersHierarchy=" + this.clsLdrHierarchy + ", reason=" + res.errorMessage() + ']';
                LT.warn(this.log, msg);
                classRequestExceptions.add(new IgniteException(msg));
                Object object2 = this.mux;
                synchronized (object2) {
                    if (this.missedRsrcs != null) {
                        this.missedRsrcs.add(path);
                    }
                    break;
                }
            }
            catch (IgniteCheckedException e) {
                if (Thread.currentThread().isInterrupted()) {
                    msg = "Failed to find class probably due to task/job cancellation [name=" + name + ", clsLdrId=" + igniteUuid + ", nodeId=" + nodeId + ", clsLoadersHierarchy=" + this.clsLdrHierarchy + ']';
                    if (!this.quiet) {
                        U.error(this.log, msg, e);
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(msg);
                    continue;
                }
                msg = "Failed to send class-loading request to node (is node alive?) [node=" + node.id() + ", clsName=" + name + ", clsPath=" + path + ", clsLdrId=" + igniteUuid + ", clsLoadersHierarchy=" + this.clsLdrHierarchy + ", err=" + e + ']';
                if (!this.quiet) {
                    U.warn(this.log, msg, e);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug(msg);
                }
                classRequestExceptions.add(new IgniteException(msg, e));
            }
            catch (TimeoutException e) {
                classRequestExceptions.add(new IgniteException("Failed to send class-loading request to node (is node alive?) [node=" + node.id() + ", clsName=" + name + ", clsPath=" + path + ", clsLdrId=" + igniteUuid + ", clsLoadersHierarchy=" + this.clsLdrHierarchy + ']', e));
            }
        }
        if (!classRequestExceptions.isEmpty()) {
            IgniteException exception = (IgniteException)classRequestExceptions.remove(0);
            for (Exception exception2 : classRequestExceptions) {
                exception.addSuppressed(exception2);
            }
            LT.warn(this.log, exception.getMessage(), exception);
            throw exception;
        }
        P2PClassNotFoundException cnfe = new P2PClassNotFoundException("Failed to peer load class [class=" + name + ", nodeClsLdrs=" + nodeLdrMapCp + ", clsLoadersHierarchy=" + this.clsLdrHierarchy + ']');
        LT.warn(this.log, cnfe.getMessage(), cnfe);
        throw cnfe;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        try {
            return this.getResourceAsStreamEx(name);
        }
        catch (TimeoutException ignore) {
            return null;
        }
    }

    @Nullable
    public InputStream getResourceAsStreamEx(String name) throws TimeoutException {
        byte[] bytes;
        assert (!Thread.holdsLock(this.mux));
        if (this.byteMap != null && name.endsWith(".class") && (bytes = (byte[])this.byteMap.get(name)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got class definition from byte code cache: " + name);
            }
            return new ByteArrayInputStream(bytes);
        }
        InputStream in = ClassLoader.getSystemResourceAsStream(name);
        if (in == null) {
            in = super.getResourceAsStream(name);
        }
        if ("META-INF/services/org.apache.commons.logging.LogFactory".equalsIgnoreCase(name)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Denied sending remote request for META-INF/services/org.apache.commons.logging.LogFactory.");
            }
            return null;
        }
        if (in == null) {
            in = this.sendResourceRequest(name);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private InputStream sendResourceRequest(String name) throws TimeoutException {
        HashMap<UUID, IgniteUuid> nodeLdrMapCp;
        LinkedList<UUID> nodeListCp;
        assert (!Thread.holdsLock(this.mux));
        long endTime = this.computeEndTime(this.p2pTimeout);
        Iterator iterator = this.mux;
        synchronized (iterator) {
            if (this.missedRsrcs != null && this.missedRsrcs.contains(name)) {
                return null;
            }
            nodeListCp = this.singleNode ? this.nodeList : new LinkedList<UUID>(this.nodeList);
            nodeLdrMapCp = this.singleNode ? this.nodeLdrMap : new HashMap<UUID, IgniteUuid>(this.nodeLdrMap);
        }
        for (UUID nodeId : nodeListCp) {
            String msg;
            if (nodeId.equals(this.ctx.discovery().localNode().id())) continue;
            IgniteUuid ldrId = (IgniteUuid)nodeLdrMapCp.get(nodeId);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Found inactive node in class loader (will skip): " + nodeId);
                continue;
            }
            try {
                GridDeploymentResponse res = this.comm.sendResourceRequest(name, ldrId, node, endTime);
                if (res.success()) {
                    return new ByteArrayInputStream(res.byteSource().internalArray(), 0, res.byteSource().size());
                }
                Object object = this.mux;
                synchronized (object) {
                    if (this.missedRsrcs != null) {
                        this.missedRsrcs.add(name);
                    }
                }
                msg = "Failed to get resource from node [nodeId=" + node.id() + ", clsLdrId=" + ldrId + ", resName=" + name + ", classLoadersHierarchy=" + this.classLoadersHierarchy() + ", msg=" + res.errorMessage() + ']';
                LT.info(this.log, msg);
                return null;
            }
            catch (TimeoutException | IgniteCheckedException e) {
                if (Thread.currentThread().isInterrupted()) {
                    msg = "Failed to get resource probably due to task/job cancellation [name=" + name + ", clsLdrId=" + ldrId + ", nodeId=" + nodeId + ", clsLoadersHierarchy=" + this.classLoadersHierarchy() + ']';
                    LT.error(this.log, e, msg);
                } else {
                    msg = "Failed to get resource from node (is node alive?) [node=" + node.id() + ", resName=" + name + ", clsLdrId=" + ldrId + ", clsLoadersHierarchy=" + this.classLoadersHierarchy() + ", err=" + e + ']';
                    LT.warn(this.log, msg, e);
                }
                if (!(e instanceof TimeoutException)) continue;
                throw (TimeoutException)e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mux;
        synchronized (object) {
            return S.toString(GridDeploymentClassLoader.class, this);
        }
    }

    private String classLoadersHierarchy() {
        SB sb = new SB();
        sb.a(this.getClass().getName());
        ClassLoader ldr = this;
        for (int iterations = 100; ldr.getParent() != null && iterations > 0; --iterations) {
            sb.a("->").a(ldr.getParent().getClass().getName());
            ldr = ldr.getParent();
        }
        return sb.toString();
    }

    static {
        Permissions perms = new Permissions();
        perms.add(new RuntimePermission("accessClassInPackage.org.apache.ignite.internal"));
        perms.add(new RuntimePermission("accessClassInPackage.org.apache.ignite.internal.*"));
        perms.setReadOnly();
        PROTECTION_DOMAIN = new ProtectionDomain(null, perms);
    }
}

