/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class GridDhtTxEnlistFuture
extends GridDhtTxAbstractEnlistFuture<GridCacheReturn>
implements UpdateSourceIterator<Object> {
    private final EnlistOperation op;
    private final Iterator<Object> it;
    private final GridCacheReturn res;
    private final boolean needRes;

    public GridDhtTxEnlistFuture(UUID nearNodeId, GridCacheVersion nearLockVer, MvccSnapshot mvccSnapshot, IgniteUuid nearFutId, int nearMiniId, GridDhtTxLocalAdapter tx, long timeout, GridCacheContext<?, ?> cctx, Collection<Object> rows, EnlistOperation op, @Nullable CacheEntryPredicate filter, boolean needRes, boolean keepBinary) {
        super(nearNodeId, nearLockVer, mvccSnapshot, nearFutId, nearMiniId, tx, timeout, cctx, filter, keepBinary);
        this.op = op;
        this.needRes = needRes;
        this.it = rows.iterator();
        this.res = new GridCacheReturn(cctx.localNodeId().equals(nearNodeId), false);
        this.skipNearNodeUpdates = true;
    }

    @Override
    protected UpdateSourceIterator<?> createIterator() {
        return this;
    }

    @Override
    @Nullable
    protected GridCacheReturn result0() {
        return this.res;
    }

    @Override
    protected void onEntryProcessed(KeyCacheObject key, GridCacheUpdateTxResult txRes) {
        assert (txRes.invokeResult() == null || this.needRes);
        this.res.success(txRes.success());
        if (txRes.invokeResult() != null) {
            this.res.invokeResult(true);
            CacheInvokeResult invokeRes = txRes.invokeResult();
            if (invokeRes.result() != null || invokeRes.error() != null) {
                this.res.addEntryProcessResult(this.cctx, key, null, invokeRes.result(), invokeRes.error(), this.keepBinary);
            }
        } else if (this.needRes) {
            this.res.set(this.cctx, txRes.prevValue(), txRes.success(), this.keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
        }
    }

    @Override
    public boolean needResult() {
        return this.needRes;
    }

    @Override
    public EnlistOperation operation() {
        return this.op;
    }

    @Override
    public boolean hasNextX() {
        return this.it.hasNext();
    }

    @Override
    public Object nextX() {
        return this.it.next();
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxEnlistFuture.class, this);
    }
}

