/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheClearAllRunnable;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheLocalConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheClearAllRunnable;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearCacheAdapter<K, V>
extends GridDistributedCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private static final CachePeekMode[] NEAR_PEEK_MODE = new CachePeekMode[]{CachePeekMode.NEAR};

    protected GridNearCacheAdapter() {
    }

    protected GridNearCacheAdapter(GridCacheContext<K, V> ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.map == null) {
            this.map = new GridCacheLocalConcurrentMap(this.ctx, this.entryFactory(), this.ctx.config().getNearConfiguration().getNearStartSize());
        }
    }

    private GridCacheMapEntryFactory entryFactory() {
        return new GridCacheMapEntryFactory(){

            @Override
            public GridCacheMapEntry create(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key) {
                return new GridNearCacheEntry(ctx, key);
            }
        };
    }

    public abstract GridDhtCacheAdapter<K, V> dht();

    @Override
    public void onReconnected() {
        this.map = new GridCacheLocalConcurrentMap(this.ctx, this.entryFactory(), this.ctx.config().getNearConfiguration().getNearStartSize());
    }

    @Override
    public boolean isNear() {
        return true;
    }

    @Override
    public GridCachePreloader preloader() {
        return this.dht().preloader();
    }

    @Override
    public GridCacheMapEntry entryEx(KeyCacheObject key, AffinityTopologyVersion topVer) {
        GridNearCacheEntry entry = null;
        while (true) {
            try {
                entry = (GridNearCacheEntry)super.entryEx(key, topVer);
                entry.initializeFromDht(topVer);
                return entry;
            }
            catch (GridCacheEntryRemovedException ignore) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Got removed near entry while initializing from DHT entry (will retry): " + entry);
                continue;
            }
            break;
        }
    }

    public GridNearCacheEntry entryExx(KeyCacheObject key, AffinityTopologyVersion topVer) {
        return (GridNearCacheEntry)this.entryEx(key, topVer);
    }

    @Nullable
    public GridNearCacheEntry peekExx(KeyCacheObject key) {
        return (GridNearCacheEntry)this.peekEx(key);
    }

    @Override
    public boolean isLocked(K key) {
        return super.isLocked(key) || this.dht().isLocked(key);
    }

    public boolean isLockedNearOnly(K key) {
        return super.isLocked(key);
    }

    public boolean isAllLockedNearOnly(Iterable<? extends K> keys) {
        A.notNull(keys, "keys");
        for (K key : keys) {
            if (this.isLockedNearOnly(key)) continue;
            return false;
        }
        return true;
    }

    public IgniteInternalFuture<Map<K, V>> loadAsync(@Nullable IgniteInternalTx tx, @Nullable Collection<KeyCacheObject> keys, boolean forcePrimary, String taskName, boolean deserializeBinary, boolean recovery, @Nullable ExpiryPolicy expiryPlc, boolean skipVal, boolean skipStore, boolean needVer) {
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        IgniteTxLocalEx txx = tx != null && tx.local() ? (IgniteTxLocalEx)tx : null;
        IgniteCacheExpiryPolicy expiry = this.expiryPolicy(expiryPlc);
        GridNearGetFuture fut = new GridNearGetFuture(this.ctx, keys, !skipStore, forcePrimary, txx, taskName, deserializeBinary, expiry, skipVal, needVer, false, recovery);
        fut.init(null);
        return fut;
    }

    @Override
    public void localLoadCache(IgniteBiPredicate<K, V> p, Object[] args) throws IgniteCheckedException {
        this.dht().localLoadCache(p, args);
    }

    @Override
    public void localLoad(Collection<? extends K> keys, ExpiryPolicy plc, boolean keepBinary) throws IgniteCheckedException {
        this.dht().localLoad(keys, plc, keepBinary);
    }

    @Override
    public IgniteInternalFuture<?> localLoadCacheAsync(IgniteBiPredicate<K, V> p, Object[] args) {
        return this.dht().localLoadCacheAsync(p, args);
    }

    protected void processGetResponse(UUID nodeId, GridNearGetResponse res) {
        CacheGetFuture fut = (CacheGetFuture)((Object)this.ctx.mvcc().future(res.futureId()));
        if (fut == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to find future for get response [sender=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        fut.onResult(nodeId, res);
    }

    @Override
    public int size() {
        return this.dht().size();
    }

    @Override
    public long sizeLong() {
        return this.nearEntries().size() + this.dht().size();
    }

    @Override
    public int primarySize() {
        return this.dht().primarySize();
    }

    @Override
    public long primarySizeLong() {
        return this.dht().primarySizeLong();
    }

    @Override
    public int nearSize() {
        return this.nearEntries().size();
    }

    public Set<Cache.Entry<K, V>> nearEntries() {
        final AffinityTopologyVersion topVer = this.ctx.shared().exchange().readyAffinityVersion();
        return super.entrySet(new CacheEntryPredicateAdapter(){

            @Override
            public boolean apply(GridCacheEntryEx entry) {
                GridNearCacheEntry nearEntry = (GridNearCacheEntry)entry;
                return !nearEntry.deleted() && nearEntry.visitable(CU.empty0()) && nearEntry.valid(topVer);
            }
        });
    }

    @Override
    public Set<Cache.Entry<K, V>> entrySet(final CacheEntryPredicate ... filter) {
        CacheEntryPredicateAdapter p = new CacheEntryPredicateAdapter(){

            @Override
            public boolean apply(GridCacheEntryEx ex) {
                if (ex instanceof GridCacheMapEntry) {
                    return ((GridCacheMapEntry)ex).visitable(filter);
                }
                return !ex.deleted() && F.isAll(ex, filter);
            }
        };
        return new EntrySet(super.entrySet(p), this.dht().entrySet(p));
    }

    @Override
    public boolean evict(K key) {
        return super.evict(key) & this.dht().evict(key);
    }

    @Override
    public void evictAll(Collection<? extends K> keys) {
        super.evictAll(keys);
        this.dht().evictAll(keys);
    }

    @Override
    public boolean clearLocally(K key) {
        return super.clearLocally(key) | this.dht().clearLocally(key);
    }

    @Override
    public void clearLocallyAll(Set<? extends K> keys, boolean srv, boolean near, boolean readers) {
        super.clearLocallyAll(keys, srv, near, readers);
        this.dht().clearLocallyAll(keys, srv, near, readers);
    }

    @Override
    public long offHeapEntriesCount() {
        return this.dht().offHeapEntriesCount();
    }

    @Override
    public long offHeapAllocatedSize() {
        return this.dht().offHeapAllocatedSize();
    }

    @Override
    public List<GridCacheClearAllRunnable<K, V>> splitClearLocally(boolean srv, boolean near, boolean readers) {
        assert (this.configuration().getNearConfiguration() != null);
        if (this.ctx.affinityNode()) {
            GridCacheVersion obsoleteVer = this.nextVersion();
            List<GridCacheClearAllRunnable<K, V>> dhtJobs = this.dht().splitClearLocally(srv, near, readers);
            ArrayList<GridCacheClearAllRunnable<K, V>> res = new ArrayList<GridCacheClearAllRunnable<K, V>>(dhtJobs.size());
            for (GridCacheClearAllRunnable<K, V> dhtJob : dhtJobs) {
                res.add(new GridNearCacheClearAllRunnable<K, V>(this, obsoleteVer, dhtJob));
            }
            return res;
        }
        return super.splitClearLocally(srv, near, readers);
    }

    @Override
    public String toString() {
        return S.toString(GridNearCacheAdapter.class, this);
    }

    private class EntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        private Iterator<Cache.Entry<K, V>> dhtIter;
        private Iterator<Cache.Entry<K, V>> nearIter;
        private Iterator<Cache.Entry<K, V>> currIter;
        private Cache.Entry<K, V> currEntry;

        private EntryIterator(Iterator<Cache.Entry<K, V>> nearIter, Iterator<Cache.Entry<K, V>> dhtIter) {
            assert (nearIter != null);
            assert (dhtIter != null);
            this.nearIter = nearIter;
            this.dhtIter = dhtIter;
            this.currIter = nearIter;
        }

        @Override
        public boolean hasNext() {
            return this.nearIter.hasNext() || this.dhtIter.hasNext();
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.currIter.hasNext()) {
                this.currIter = this.dhtIter;
            }
            this.currEntry = this.currIter.next();
            return this.currEntry;
        }

        @Override
        public void remove() {
            if (this.currEntry == null) {
                throw new IllegalStateException();
            }
            assert (this.currIter != null);
            this.currIter.remove();
            try {
                GridNearCacheAdapter.this.getAndRemove(this.currEntry.getKey());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Cache.Entry<K, V>> {
        private Set<Cache.Entry<K, V>> nearSet;
        private Set<Cache.Entry<K, V>> dhtSet;

        private EntrySet(Set<Cache.Entry<K, V>> nearSet, Set<Cache.Entry<K, V>> dhtSet) {
            assert (nearSet != null);
            assert (dhtSet != null);
            this.nearSet = nearSet;
            this.dhtSet = dhtSet;
        }

        @Override
        @NotNull
        public Iterator<Cache.Entry<K, V>> iterator() {
            return new EntryIterator(this.nearSet.iterator(), F.iterator0(this.dhtSet, false, new P1<Cache.Entry<K, V>>(){

                @Override
                public boolean apply(Cache.Entry<K, V> e) {
                    try {
                        return GridNearCacheAdapter.super.localPeek(e.getKey(), NEAR_PEEK_MODE) == null;
                    }
                    catch (IgniteCheckedException ex) {
                        throw new IgniteException(ex);
                    }
                }
            }));
        }

        @Override
        public int size() {
            return F.size(this.iterator(), new IgnitePredicate[0]);
        }
    }
}

