/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsProvider;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetricsImpl;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderWithDelegateMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.metric.impl.PeriodicHistogramMetricImpl;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.systemview.view.PagesTimestampHistogramView;
import org.jetbrains.annotations.Nullable;

public class DataRegionMetricsImpl
implements DataRegionMetrics {
    public static final String DATAREGION_METRICS_PREFIX = MetricUtils.metricName("io", "dataregion");
    private final DataRegionMetricsProvider dataRegionMetricsProvider;
    private volatile IntMap<PageMetrics> cacheGrpMetrics = new IntHashMap<PageMetrics>();
    private final Object cacheGrpMetricsLock = new Object();
    private final PageMetrics dataRegionPageMetrics;
    private final LongAdderMetric largeEntriesPages;
    private final LongAdderMetric dirtyPages;
    private final LongAdderMetric readPages;
    private final LongAdderMetric readPagesTime;
    private final LongAdderMetric writtenPages;
    private final LongAdderMetric replacedPages;
    private final LongAdderMetric pageReplaceTime;
    private final AtomicLongMetric offHeapSize;
    private final AtomicLongMetric checkpointBufSize;
    private volatile boolean metricsEnabled;
    private boolean persistenceEnabled;
    private final int subInts;
    private final HitRateMetric allocRate;
    private final HitRateMetric evictRate;
    private final HitRateMetric pageReplaceRate;
    private final HitRateMetric pageReplaceAge;
    private final LongAdderMetric totalThrottlingTime;
    private final DataRegionConfiguration dataRegionCfg;
    @Nullable
    private PageMemory pageMem;
    private final GridKernalContext kernalCtx;
    private volatile long rateTimeInterval;
    @Nullable
    private final PeriodicHistogramMetricImpl pageTsHistogram;

    private static LongAdderMetricDelegate delegate(LongAdderMetric delegate) {
        return new LongAdderMetricDelegate(delegate);
    }

    public DataRegionMetricsImpl(DataRegionConfiguration dataRegionCfg, GridKernalContext kernalCtx) {
        this(dataRegionCfg, kernalCtx, new DataRegionMetricsProvider(){

            @Override
            public long partiallyFilledPagesFreeSpace() {
                return 0L;
            }

            @Override
            public long emptyDataPages() {
                return 0L;
            }
        });
    }

    public DataRegionMetricsImpl(DataRegionConfiguration dataRegionCfg, GridKernalContext kernalCtx, DataRegionMetricsProvider dataRegionMetricsProvider) {
        this.dataRegionCfg = dataRegionCfg;
        this.dataRegionMetricsProvider = dataRegionMetricsProvider;
        this.kernalCtx = kernalCtx;
        this.metricsEnabled = dataRegionCfg.isMetricsEnabled();
        this.persistenceEnabled = dataRegionCfg.isPersistenceEnabled();
        this.rateTimeInterval = dataRegionCfg.getMetricsRateTimeInterval();
        this.subInts = dataRegionCfg.getMetricsSubIntervalCount();
        MetricRegistry mreg = this.metricRegistry();
        this.allocRate = mreg.hitRateMetric("AllocationRate", "Allocation rate (pages per second) averaged across rateTimeInterval.", 60000L, 5);
        this.evictRate = mreg.hitRateMetric("EvictionRate", "Eviction rate (pages per second).", 60000L, 5);
        this.pageReplaceRate = mreg.hitRateMetric("PagesReplaceRate", "Rate at which pages in memory are replaced with pages from persistent storage (pages per second).", 60000L, 5);
        this.pageReplaceAge = mreg.hitRateMetric("PagesReplaceAge", "Average age at which pages in memory are replaced with pages from persistent storage (milliseconds).", 60000L, 5);
        this.largeEntriesPages = mreg.longAdderMetric("LargeEntriesPagesCount", "Count of pages that fully ocupied by large entries that go beyond page size");
        this.dirtyPages = mreg.longAdderMetric("DirtyPages", "Number of pages in memory not yet synchronized with persistent storage.");
        this.readPages = mreg.longAdderMetric("PagesRead", "Number of pages read from last restart.");
        this.readPagesTime = mreg.longAdderMetric("PagesReadTime", "Total pages read time in nanoseconds since last restart.");
        this.writtenPages = mreg.longAdderMetric("PagesWritten", "Number of pages written from last restart.");
        this.replacedPages = mreg.longAdderMetric("PagesReplaced", "Number of pages replaced from last restart.");
        this.pageReplaceTime = mreg.longAdderMetric("PagesReplaceTime", "Total pages replace time in nanoseconds since last restart.");
        this.offHeapSize = mreg.longMetric("OffHeapSize", "Offheap size in bytes.");
        this.checkpointBufSize = mreg.longMetric("CheckpointBufferSize", "Checkpoint buffer size in bytes.");
        mreg.register("EmptyDataPages", dataRegionMetricsProvider::emptyDataPages, "Calculates empty data pages count for region. It counts only totally free pages that can be reused (e. g. pages that are contained in reuse bucket of free list).");
        this.totalThrottlingTime = mreg.longAdderMetric("TotalThrottlingTime", "Total throttling threads time in milliseconds. The Ignite throttles threads that generate dirty pages during the ongoing checkpoint.");
        mreg.longMetric("InitialSize", "Initial memory region size in bytes defined by its data region.").value(dataRegionCfg.getInitialSize());
        mreg.longMetric("MaxSize", "Maximum memory region size in bytes defined by its data region.").value(dataRegionCfg.getMaxSize());
        if (this.persistenceEnabled) {
            long startTs = U.currentTimeMillis() - 1000L;
            String name = MetricUtils.metricName(mreg.name(), "PageTimestampHistogram");
            String desc = "Histogram of pages last access time";
            this.pageTsHistogram = new PeriodicHistogramMetricImpl(startTs, name, desc);
            mreg.register(this.pageTsHistogram);
        } else {
            this.pageTsHistogram = null;
        }
        this.dataRegionPageMetrics = PageMetricsImpl.builder(mreg).totalPagesCallback(new LongAdderWithDelegateMetric.Delegate(){

            @Override
            public void increment() {
                this.add(1L);
            }

            @Override
            public void add(long x) {
                if (DataRegionMetricsImpl.this.metricsEnabled && x > 0L) {
                    DataRegionMetricsImpl.this.allocRate.add(x);
                }
            }

            @Override
            public void decrement() {
            }
        }).build();
    }

    private MetricRegistry metricRegistry() {
        String registryName = MetricUtils.metricName(DATAREGION_METRICS_PREFIX, this.dataRegionCfg.getName());
        return this.kernalCtx.metric().registry(registryName);
    }

    @Override
    public String getName() {
        return U.maskName(this.dataRegionCfg.getName());
    }

    @Override
    public long getTotalAllocatedPages() {
        return this.dataRegionPageMetrics.totalPages().value();
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.getTotalAllocatedPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public long getTotalUsedPages() {
        return this.getTotalAllocatedPages() - this.dataRegionMetricsProvider.emptyDataPages();
    }

    @Override
    public long getTotalUsedSize() {
        return this.getTotalUsedPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public float getAllocationRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.allocRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getEvictionRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.evictRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getLargeEntriesPagesPercentage() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        long totalAllocatedPages = this.getTotalAllocatedPages();
        return totalAllocatedPages != 0L ? (float)this.largeEntriesPages.value() / (float)totalAllocatedPages : 0.0f;
    }

    @Override
    public float getPagesFillFactor() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        long totalUsedSize = this.getTotalUsedSize();
        if (totalUsedSize == 0L) {
            return 0.0f;
        }
        long freeSpaceInPages = this.dataRegionMetricsProvider.partiallyFilledPagesFreeSpace();
        return (float)(totalUsedSize - freeSpaceInPages) / (float)totalUsedSize;
    }

    private long getSizeUsedByData() {
        long totalSpace = this.getTotalAllocatedSize();
        long partiallyFreeSpace = this.dataRegionMetricsProvider.partiallyFilledPagesFreeSpace();
        long emptySpace = this.dataRegionMetricsProvider.emptyDataPages() * (long)this.pageMem.systemPageSize();
        return totalSpace - partiallyFreeSpace - emptySpace;
    }

    @Override
    public long getDirtyPages() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.dirtyPages.value();
    }

    @Override
    public float getPagesReplaceRate() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0.0f;
        }
        return (float)this.pageReplaceRate.value() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getPagesReplaceAge() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0.0f;
        }
        long rep = this.pageReplaceRate.value();
        return rep == 0L ? 0.0f : (float)this.pageReplaceAge.value() / (float)rep;
    }

    @Override
    public long getPhysicalMemoryPages() {
        if (!this.persistenceEnabled) {
            return this.getTotalAllocatedPages();
        }
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.pageMem.loadedPages();
    }

    @Override
    public long getPhysicalMemorySize() {
        return this.getPhysicalMemoryPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.pageMem.checkpointBufferPagesCount();
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        return this.getUsedCheckpointBufferPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public long getCheckpointBufferSize() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.checkpointBufSize.value();
    }

    @Override
    public int getPageSize() {
        if (!this.metricsEnabled) {
            return 0;
        }
        return this.pageMem.pageSize();
    }

    @Override
    public long getPagesRead() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.readPages.value();
    }

    @Override
    public long getPagesWritten() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.writtenPages.value();
    }

    @Override
    public long getPagesReplaced() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.replacedPages.value();
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize.value();
    }

    @Override
    public long getOffheapUsedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.pageMem.loadedPages() * (long)this.pageMem.systemPageSize();
    }

    public void updateOffHeapSize(long size) {
        this.offHeapSize.add(size);
    }

    public void updateCheckpointBufferSize(long size) {
        this.checkpointBufSize.add(size);
    }

    public PageMetrics pageMetrics() {
        return this.dataRegionPageMetrics;
    }

    public void onPageReplaced(long pageAge, long nanos) {
        if (this.metricsEnabled) {
            this.pageReplaceRate.increment();
            this.pageReplaceAge.add(pageAge);
            this.replacedPages.increment();
            this.pageReplaceTime.add(nanos);
        }
    }

    public void onPageRead(long nanos) {
        if (this.metricsEnabled) {
            this.readPages.increment();
            this.readPagesTime.add(nanos);
        }
    }

    public void onPageWritten() {
        if (this.metricsEnabled) {
            this.writtenPages.increment();
        }
    }

    public void incrementDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.increment();
        }
    }

    public void decrementDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.decrement();
        }
    }

    public void resetDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageMetrics cacheGrpPageMetrics(int cacheGrpId) {
        PageMetrics pageMetrics = this.cacheGrpMetrics.get(cacheGrpId);
        if (pageMetrics != null) {
            return pageMetrics;
        }
        Object object = this.cacheGrpMetricsLock;
        synchronized (object) {
            IntMap<PageMetrics> locCacheGrpMetrics = this.cacheGrpMetrics;
            PageMetrics doubleCheckPageMetrics = locCacheGrpMetrics.get(cacheGrpId);
            if (doubleCheckPageMetrics != null) {
                return doubleCheckPageMetrics;
            }
            IntHashMap<PageMetrics> copy = new IntHashMap<PageMetrics>(locCacheGrpMetrics);
            PageMetrics newMetrics = Optional.of(this.kernalCtx).map(GridKernalContext::cache).map(cache -> cache.cacheGroupDescriptors().get(cacheGrpId)).map(decs -> this.createCacheGrpPageMetrics(decs.cacheOrGroupName())).orElse(this.dataRegionPageMetrics);
            copy.put(cacheGrpId, newMetrics);
            this.cacheGrpMetrics = copy;
            return newMetrics;
        }
    }

    private PageMetrics createCacheGrpPageMetrics(String cacheGrpName) {
        String registryName = MetricUtils.cacheGroupMetricsRegistryName(cacheGrpName);
        MetricRegistry registry = this.kernalCtx.metric().registry(registryName);
        return PageMetricsImpl.builder(registry).totalPagesCallback(DataRegionMetricsImpl.delegate(this.dataRegionPageMetrics.totalPages())).indexPagesCallback(DataRegionMetricsImpl.delegate(this.dataRegionPageMetrics.indexPages())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheGrpPageMetrics(Integer grpId) {
        PageMetrics rmvMetrics;
        Object object = this.cacheGrpMetricsLock;
        synchronized (object) {
            IntHashMap<PageMetrics> copy = new IntHashMap<PageMetrics>(this.cacheGrpMetrics);
            rmvMetrics = (PageMetrics)copy.remove(grpId);
            this.cacheGrpMetrics = copy;
        }
        if (rmvMetrics != null) {
            this.dataRegionPageMetrics.indexPages().add(-rmvMetrics.indexPages().value());
        }
    }

    public void updateEvictionRate() {
        if (this.metricsEnabled) {
            this.evictRate.increment();
        }
    }

    public void incrementLargeEntriesPages() {
        if (this.metricsEnabled) {
            this.largeEntriesPages.increment();
        }
    }

    public void decrementLargeEntriesPages() {
        if (this.metricsEnabled) {
            this.largeEntriesPages.decrement();
        }
    }

    public void enableMetrics() {
        this.metricsEnabled = true;
        if (this.pageTsHistogram != null) {
            this.pageTsHistogram.reset(this.getPhysicalMemoryPages());
        }
    }

    public void disableMetrics() {
        this.metricsEnabled = false;
        if (this.pageTsHistogram != null) {
            this.pageTsHistogram.reset(0L);
        }
    }

    public void persistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    public void pageMemory(PageMemory pageMem) {
        this.pageMem = pageMem;
        MetricRegistry mreg = this.metricRegistry();
        mreg.register("PagesFillFactor", this::getPagesFillFactor, "Returns the ratio of space occupied by user and system data to the size of all pages that contain this data");
        mreg.register("SizeUsedByData", this::getSizeUsedByData, "Returns the number of bytes, occupied by data. Similar to TotalUsedSize, but it also takes into account the empty space in non-empty pages");
        mreg.register("PhysicalMemoryPages", this::getPhysicalMemoryPages, "Number of pages residing in physical RAM");
        mreg.register("OffheapUsedSize", this::getOffheapUsedSize, "Offheap used size in bytes");
        mreg.register("TotalAllocatedSize", this::getTotalAllocatedSize, "Gets a total size of memory allocated in the data region, in bytes");
        mreg.register("TotalUsedPages", this::getTotalUsedPages, "Gets an amount of non-empty pages allocated in the data region");
        mreg.register("TotalUsedSize", this::getTotalUsedSize, "Gets an amount of bytes, occupied by non-empty pages allocated in the data region");
        mreg.register("PhysicalMemorySize", this::getPhysicalMemorySize, "Gets total size of pages loaded to the RAM, in bytes");
        mreg.register("UsedCheckpointBufferSize", this::getUsedCheckpointBufferSize, "Gets used checkpoint buffer size in bytes");
    }

    @Deprecated
    public void rateTimeInterval(long rateTimeInterval) {
        this.rateTimeInterval = rateTimeInterval;
        this.allocRate.reset(rateTimeInterval, this.subInts);
        this.evictRate.reset(rateTimeInterval, this.subInts);
        this.pageReplaceRate.reset(rateTimeInterval, this.subInts);
        this.pageReplaceAge.reset(rateTimeInterval, this.subInts);
    }

    @Deprecated
    public void subIntervals(int subInts) {
        assert (subInts > 0);
        if (this.subInts == subInts) {
            return;
        }
        if (this.rateTimeInterval / (long)subInts < 10L) {
            subInts = (int)this.rateTimeInterval / 10;
        }
        this.allocRate.reset(this.rateTimeInterval, subInts);
        this.evictRate.reset(this.rateTimeInterval, subInts);
        this.pageReplaceRate.reset(this.rateTimeInterval, subInts);
        this.pageReplaceAge.reset(this.rateTimeInterval, subInts);
    }

    public void clear() {
        this.largeEntriesPages.reset();
        this.dirtyPages.reset();
        this.readPages.reset();
        this.readPagesTime.reset();
        this.writtenPages.reset();
        this.replacedPages.reset();
        this.pageReplaceTime.reset();
        this.offHeapSize.reset();
        this.checkpointBufSize.reset();
        this.allocRate.reset();
        this.evictRate.reset();
        this.pageReplaceRate.reset();
        this.pageReplaceAge.reset();
        this.dataRegionPageMetrics.reset();
        for (PageMetrics metrics : this.cacheGrpMetrics.values()) {
            metrics.reset();
        }
    }

    public void remove() {
        this.kernalCtx.metric().remove(this.metricRegistry().name(), false);
    }

    public void addThrottlingTime(long time) {
        if (this.kernalCtx.performanceStatistics().enabled()) {
            this.kernalCtx.performanceStatistics().pagesWriteThrottle(U.currentTimeMillis(), time);
        }
        if (this.metricsEnabled) {
            this.totalThrottlingTime.add(time);
        }
    }

    public void incrementPagesWithTimestamp(long ts) {
        if (this.metricsEnabled && this.pageTsHistogram != null) {
            this.pageTsHistogram.increment(ts);
        }
    }

    public void decrementPagesWithTimestamp(long ts) {
        if (this.metricsEnabled && this.pageTsHistogram != null) {
            this.pageTsHistogram.decrement(ts);
        }
    }

    public Collection<PagesTimestampHistogramView> pagesTimestampHistogramView() {
        if (!this.metricsEnabled || this.pageTsHistogram == null) {
            return Collections.emptyList();
        }
        IgniteBiTuple<long[], long[]> hist = this.pageTsHistogram.histogram();
        long[] bounds = hist.get1();
        long[] vals = hist.get2();
        ArrayList<PagesTimestampHistogramView> list = new ArrayList<PagesTimestampHistogramView>(vals.length);
        for (int i = 0; i < vals.length - 1; ++i) {
            list.add(new PagesTimestampHistogramView(this.getName(), bounds[i], bounds[i + 1], vals[i]));
        }
        list.add(new PagesTimestampHistogramView(this.getName(), bounds[vals.length - 1], U.currentTimeMillis(), vals[vals.length - 1]));
        return list;
    }

    private static final class LongAdderMetricDelegate
    implements LongAdderWithDelegateMetric.Delegate {
        private final LongAdderMetric delegate;

        LongAdderMetricDelegate(LongAdderMetric delegate) {
            this.delegate = delegate;
        }

        @Override
        public void increment() {
            this.delegate.increment();
        }

        @Override
        public void decrement() {
            this.delegate.decrement();
        }

        @Override
        public void add(long x) {
            this.delegate.add(x);
        }
    }
}

