/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

abstract class AbstractSnapshotFutureTask<T>
extends GridFutureAdapter<T> {
    protected final GridCacheSharedContext<?, ?> cctx;
    protected final IgniteLogger log;
    protected final UUID srcNodeId;
    protected final UUID reqId;
    protected final String snpName;
    @GridToStringExclude
    protected final SnapshotSender snpSndr;
    protected final Map<Integer, Set<Integer>> parts;
    protected final AtomicReference<Throwable> err = new AtomicReference();

    protected AbstractSnapshotFutureTask(GridCacheSharedContext<?, ?> cctx, UUID srcNodeId, UUID reqId, String snpName, SnapshotSender snpSndr, Map<Integer, Set<Integer>> parts) {
        assert (snpName != null) : "Snapshot name cannot be empty or null.";
        assert (snpSndr != null) : "Snapshot sender which handles execution tasks must be not null.";
        assert (snpSndr.executor() != null) : "Executor service must be not null.";
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
        this.srcNodeId = srcNodeId;
        this.reqId = reqId;
        this.snpName = snpName;
        this.snpSndr = snpSndr;
        this.parts = parts;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public UUID sourceNodeId() {
        return this.srcNodeId;
    }

    public UUID requestId() {
        return this.reqId;
    }

    public Set<Integer> affectedCacheGroups() {
        return this.parts.keySet();
    }

    public abstract boolean start();

    public abstract void acceptException(Throwable var1);

    @Override
    public boolean cancel() {
        this.acceptException(new IgniteFutureCancelledCheckedException("Snapshot operation has been cancelled by external process [snpName=" + this.snpName + ']'));
        return true;
    }

    @Override
    public String toString() {
        return S.toString(AbstractSnapshotFutureTask.class, this);
    }
}

