/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.performancestatistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.IndexQueryDesc;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.processors.performancestatistics.FilePerformanceStatisticsWriter;
import org.apache.ignite.internal.processors.performancestatistics.OperationType;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class PerformanceStatisticsProcessor
extends GridProcessorAdapter {
    private static final String PERF_STAT_KEY = "ignite.internal.performanceStatistics.enabled";
    @Nullable
    private volatile FilePerformanceStatisticsWriter writer;
    @Nullable
    private volatile DistributedMetaStorage metastorage;
    private final Object mux = new Object();
    private final ArrayList<PerformanceStatisticsStateListener> lsnrs = new ArrayList();
    private DistributedProcess<Serializable, Serializable> rotateProc;

    public PerformanceStatisticsProcessor(GridKernalContext ctx) {
        super(ctx);
        this.registerStateListener(() -> {
            if (U.isLocalNodeCoordinator(ctx.discovery())) {
                ctx.cache().cacheDescriptors().values().forEach(desc -> this.cacheStart(desc.cacheId(), desc.cacheName()));
            }
        });
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.ctx.internalSubscriptionProcessor().registerDistributedMetastorageListener(new DistributedMetastorageLifecycleListener(){

            @Override
            public void onReadyForRead(ReadableDistributedMetaStorage metastorage) {
                metastorage.listen(PerformanceStatisticsProcessor.PERF_STAT_KEY::equals, (key, oldVal, newVal) -> {
                    if (!PerformanceStatisticsProcessor.this.ctx.discovery().localJoinFuture().isDone()) {
                        return;
                    }
                    PerformanceStatisticsProcessor.this.onMetastorageUpdate((Boolean)newVal);
                });
            }

            @Override
            public void onReadyForWrite(DistributedMetaStorage metastorage) {
                PerformanceStatisticsProcessor.this.metastorage = metastorage;
                try {
                    Boolean performanceStatsEnabled = (Boolean)metastorage.read(PerformanceStatisticsProcessor.PERF_STAT_KEY);
                    if (performanceStatsEnabled == null) {
                        return;
                    }
                    PerformanceStatisticsProcessor.this.onMetastorageUpdate(performanceStatsEnabled);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        });
        this.rotateProc = new DistributedProcess(this.ctx, DistributedProcess.DistributedProcessType.PERFORMANCE_STATISTICS_ROTATE, req -> this.ctx.closure().callLocalSafe(() -> {
            this.rotateWriter();
            return null;
        }), (id, res, err) -> {});
    }

    public void registerStateListener(PerformanceStatisticsStateListener lsnr) {
        this.lsnrs.add(lsnr);
    }

    public void cacheStart(int cacheId, String name) {
        this.write(writer -> writer.cacheStart(cacheId, name));
    }

    public void cacheOperation(OperationType type, int cacheId, long startTime, long duration) {
        this.write(writer -> writer.cacheOperation(type, cacheId, startTime, duration));
    }

    public void transaction(GridIntList cacheIds, long startTime, long duration, boolean commited) {
        this.write(writer -> writer.transaction(cacheIds, startTime, duration, commited));
    }

    public void query(GridCacheQueryType type, String text, long id, long startTime, long duration, boolean success) {
        this.write(writer -> writer.query(type, text, id, startTime, duration, success));
    }

    public void queryReads(GridCacheQueryType type, UUID queryNodeId, long id, long logicalReads, long physicalReads) {
        this.write(writer -> writer.queryReads(type, queryNodeId, id, logicalReads, physicalReads));
    }

    public void queryRowsProcessed(GridCacheQueryType type, UUID qryNodeId, long id, String action, long rows) {
        this.write(writer -> writer.queryRows(type, qryNodeId, id, action, rows));
    }

    public void queryProperty(GridCacheQueryType type, UUID qryNodeId, long id, String name, String val) {
        this.write(writer -> writer.queryProperty(type, qryNodeId, id, name, val));
    }

    public void task(IgniteUuid sesId, String taskName, long startTime, long duration, int affPartId) {
        this.write(writer -> writer.task(sesId, taskName, startTime, duration, affPartId));
    }

    public void job(IgniteUuid sesId, long queuedTime, long startTime, long duration, boolean timedOut) {
        this.write(writer -> writer.job(sesId, queuedTime, startTime, duration, timedOut));
    }

    public void checkpoint(long beforeLockDuration, long lockWaitDuration, long listenersExecDuration, long markDuration, long lockHoldDuration, long pagesWriteDuration, long fsyncDuration, long walCpRecordFsyncDuration, long writeCpEntryDuration, long splitAndSortCpPagesDuration, long totalDuration, long cpStartTime, int pagesSize, int dataPagesWritten, int cowPagesWritten) {
        this.write(writer -> writer.checkpoint(beforeLockDuration, lockWaitDuration, listenersExecDuration, markDuration, lockHoldDuration, pagesWriteDuration, fsyncDuration, walCpRecordFsyncDuration, writeCpEntryDuration, splitAndSortCpPagesDuration, totalDuration, cpStartTime, pagesSize, dataPagesWritten, cowPagesWritten));
    }

    public void pagesWriteThrottle(long endTime, long duration) {
        this.write(writer -> writer.pagesWriteThrottle(endTime, duration));
    }

    public void startCollectStatistics() throws IgniteCheckedException {
        A.notNull(this.metastorage, "Metastorage not ready. Node not started?");
        if (!IgniteFeatures.allNodesSupports(this.ctx.discovery().allNodes(), IgniteFeatures.PERFORMANCE_STATISTICS)) {
            throw new IllegalStateException("Not all nodes in the cluster support collecting performance statistics.");
        }
        if (this.ctx.isStopping()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
        }
        this.metastorage.write(PERF_STAT_KEY, Boolean.valueOf(true));
    }

    public void stopCollectStatistics() throws IgniteCheckedException {
        A.notNull(this.metastorage, "Metastorage not ready. Node not started?");
        if (this.ctx.isStopping()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
        }
        this.metastorage.write(PERF_STAT_KEY, Boolean.valueOf(false));
    }

    public void rotateCollectStatistics() throws IgniteCheckedException {
        if (this.ctx.isStopping()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
        }
        if (!this.enabled()) {
            throw new IgniteCheckedException("Performance statistics collection not started.");
        }
        this.rotateProc.start(UUID.randomUUID(), null);
    }

    public boolean enabled() {
        return this.writer != null;
    }

    @Override
    public void onKernalStop(boolean cancel) {
        if (this.enabled()) {
            this.stopWriter();
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        if (this.enabled()) {
            this.stopWriter();
        }
    }

    private void onMetastorageUpdate(boolean start) {
        this.ctx.closure().runLocalSafe(() -> {
            if (start) {
                this.startWriter();
            } else {
                this.stopWriter();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriter() {
        try {
            Object object = this.mux;
            synchronized (object) {
                if (this.writer != null) {
                    return;
                }
                this.writer = new FilePerformanceStatisticsWriter(this.ctx);
                this.writer.start();
            }
            this.lsnrs.forEach(PerformanceStatisticsStateListener::onStarted);
            this.log.info("Performance statistics writer started.");
        }
        catch (Exception e) {
            this.log.error("Failed to start performance statistics writer.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWriter() {
        Object object = this.mux;
        synchronized (object) {
            if (this.writer == null) {
                return;
            }
            FilePerformanceStatisticsWriter writer = this.writer;
            this.writer = null;
            writer.stop();
        }
        this.log.info("Performance statistics writer stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateWriter() throws Exception {
        FilePerformanceStatisticsWriter oldWriter = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.writer == null) {
                return;
            }
            FilePerformanceStatisticsWriter newWriter = new FilePerformanceStatisticsWriter(this.ctx);
            newWriter.start();
            oldWriter = this.writer;
            this.writer = newWriter;
            oldWriter.stop();
        }
        if (this.log.isInfoEnabled() && oldWriter != null) {
            this.log.info("Performance statistics writer rotated[writtenFile=" + oldWriter.file() + "].");
        }
    }

    private void write(Consumer<FilePerformanceStatisticsWriter> c) {
        FilePerformanceStatisticsWriter writer = this.writer;
        if (writer != null) {
            c.accept(writer);
        }
    }

    public static String indexQueryText(String cacheName, IndexQueryDesc desc) {
        StringBuilder s = new StringBuilder();
        s.append(cacheName);
        s.append(':');
        s.append(desc.idxName());
        s.append(':');
        s.append(desc.valType());
        s.append(':');
        s.append(String.join((CharSequence)",", F.viewReadOnly(desc.criteria(), IndexQueryCriterion::field, new IgnitePredicate[0])));
        return s.toString();
    }

    public static interface PerformanceStatisticsStateListener
    extends EventListener {
        public void onStarted();
    }
}

