/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridSetWrapper<E>
extends GridSerializableSet<E> {
    private static final long serialVersionUID = 0L;
    protected static final Object VAL = Boolean.TRUE;
    @GridToStringExclude
    protected Map<E, Object> map;

    public GridSetWrapper(Map<E, ?> map) {
        A.notNull(map, "map");
        this.map = map;
    }

    public GridSetWrapper(Map<E, ?> map, Collection<? extends E> initVals) {
        this(map);
        this.addAll(initVals);
    }

    protected final Object defaultValue() {
        return VAL;
    }

    protected final <T extends Map<E, Object>> T map() {
        return (T)this.map;
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, VAL) == null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String toString() {
        return S.toString(GridSetWrapper.class, this, "elements", this.map.keySet());
    }
}

