/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitRepositoryFactory;
import org.apache.jackrabbit.api.management.RepositoryManager;
import org.apache.jackrabbit.core.RepositoryManagerImpl;
import org.apache.jackrabbit.core.TransientRepository;

public class RepositoryFactoryImpl
implements JackrabbitRepositoryFactory {
    public static final String REPOSITORY_HOME = "org.apache.jackrabbit.repository.home";
    public static final String REPOSITORY_CONF = "org.apache.jackrabbit.repository.conf";
    private static final Map<String, JackrabbitRepository> REPOSITORY_INSTANCES = new HashMap<String, JackrabbitRepository>();
    private final Set<TransientRepository> ownRepositories = new HashSet<TransientRepository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(Map parameters) throws RepositoryException {
        Map<String, JackrabbitRepository> map = REPOSITORY_INSTANCES;
        synchronized (map) {
            if (parameters == null) {
                return this.getOrCreateRepository(null, null);
            }
            if (parameters.containsKey(REPOSITORY_CONF) && parameters.containsKey(REPOSITORY_HOME)) {
                String conf = parameters.get(REPOSITORY_CONF).toString();
                String home = parameters.get(REPOSITORY_HOME).toString();
                return this.getOrCreateRepository(conf, home);
            }
            if (parameters.containsKey("org.apache.jackrabbit.repository.uri")) {
                Object parameter = parameters.get("org.apache.jackrabbit.repository.uri");
                try {
                    URI uri = new URI(parameter.toString().trim());
                    if ("file".equalsIgnoreCase(uri.getScheme())) {
                        String conf;
                        String home;
                        File file = new File(uri);
                        if (file.isFile()) {
                            home = file.getParentFile().getPath();
                            conf = file.getPath();
                        } else {
                            home = file.getPath();
                            conf = new File(file, "repository.xml").getPath();
                        }
                        return this.getOrCreateRepository(conf, home);
                    }
                    return null;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            return null;
        }
    }

    private JackrabbitRepository getOrCreateRepository(String conf, String home) throws RepositoryException {
        JackrabbitRepository repo = REPOSITORY_INSTANCES.get(home);
        if (repo == null) {
            TransientRepository tr;
            if (home == null) {
                tr = new TransientRepository();
                REPOSITORY_INSTANCES.put(null, tr);
            } else {
                tr = new TransientRepository(conf, home);
            }
            REPOSITORY_INSTANCES.put(tr.getHomeDir(), tr);
            this.ownRepositories.add(tr);
            repo = tr;
        }
        return repo;
    }

    public RepositoryManager getRepositoryManager(JackrabbitRepository repo) throws RepositoryException {
        if (!(repo instanceof TransientRepository)) {
            throw new RepositoryException("The repository was not created in this factory");
        }
        if (!this.ownRepositories.contains(repo)) {
            throw new RepositoryException("The repository was not created in this factory");
        }
        return new RepositoryManagerImpl((TransientRepository)repo);
    }
}

