/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import javax.security.auth.Subject;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.AbstractSession;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.NodeTypeInstanceHandler;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.retention.RetentionManagerImpl;
import org.apache.jackrabbit.core.retention.RetentionRegistry;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.value.ValueFactoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.xml.ImportHandler;
import org.apache.jackrabbit.core.xml.SessionImporter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IdentifierResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class SessionImpl
extends AbstractSession
implements JackrabbitSession,
NamespaceResolver,
NamePathResolver,
IdentifierResolver,
Dumpable {
    public static final String DISABLE_CLUSTER_SYNC_ON_REFRESH = "org.apache.jackrabbit.disableClusterSyncOnRefresh";
    private static Logger log = LoggerFactory.getLogger(SessionImpl.class);
    protected boolean alive = true;
    protected final RepositoryImpl rep;
    protected AuthContext loginContext;
    protected final Subject subject;
    protected final String userId;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected final NodeTypeManagerImpl ntMgr;
    protected AccessManager accessMgr;
    protected final SessionItemStateManager itemStateMgr;
    protected final HierarchyManager hierMgr;
    protected final ItemManager itemMgr;
    protected final WorkspaceImpl wsp;
    protected NamePathResolver namePathResolver;
    protected final InternalVersionManager versionMgr;
    protected final NodeTypeInstanceHandler ntInstanceHandler;
    protected final Map<SessionListener, SessionListener> listeners = new ReferenceMap(2, 2);
    protected ValueFactory valueFactory;
    private PrincipalManager principalManager;
    private UserManager userManager;
    private RetentionManager retentionManager;
    private Exception openStackTrace = new Exception("Stack Trace");
    private ItemValidator validator;

    protected SessionImpl(RepositoryImpl rep, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this(rep, loginContext.getSubject(), wspConfig);
        this.loginContext = loginContext;
    }

    protected SessionImpl(RepositoryImpl rep, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this.rep = rep;
        this.subject = subject;
        this.userId = this.retrieveUserId(subject, wspConfig.getName());
        this.namePathResolver = new DefaultNamePathResolver((NamespaceResolver)this, (IdentifierResolver)this, true);
        this.ntMgr = new NodeTypeManagerImpl(rep.getNodeTypeRegistry(), this, rep.getDataStore());
        String wspName = wspConfig.getName();
        this.wsp = this.createWorkspaceInstance(wspConfig, rep.getWorkspaceStateManager(wspName), rep, this);
        this.itemStateMgr = this.createSessionItemStateManager(this.wsp.getItemStateManager());
        this.hierMgr = this.itemStateMgr.getHierarchyMgr();
        this.itemMgr = this.createItemManager(this.itemStateMgr, this.hierMgr);
        this.accessMgr = this.createAccessManager(subject, this.itemStateMgr.getHierarchyMgr());
        this.versionMgr = this.createVersionManager(rep);
        this.ntInstanceHandler = new NodeTypeInstanceHandler(this.userId);
    }

    protected String retrieveUserId(Subject subject, String workspaceName) throws RepositoryException {
        return this.rep.getSecurityManager().getUserID(subject, workspaceName);
    }

    protected SessionItemStateManager createSessionItemStateManager(LocalItemStateManager manager) {
        return SessionItemStateManager.createInstance(this.rep.getRootNodeId(), manager, this.rep.getNodeTypeRegistry());
    }

    protected WorkspaceImpl createWorkspaceInstance(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        return new WorkspaceImpl(wspConfig, stateMgr, rep, session);
    }

    protected ItemManager createItemManager(SessionItemStateManager itemStateMgr, HierarchyManager hierMgr) {
        return ItemManager.createInstance(itemStateMgr, hierMgr, this, this.ntMgr.getRootNodeDefinition(), this.rep.getRootNodeId());
    }

    protected InternalVersionManager createVersionManager(RepositoryImpl rep) throws RepositoryException {
        return rep.getVersionManager();
    }

    protected AccessManager createAccessManager(Subject subject, HierarchyManager hierarchyManager) throws AccessDeniedException, RepositoryException {
        String wspName = this.getWorkspace().getName();
        AMContext ctx = new AMContext(new File(this.rep.getConfig().getHomeDir()), this.rep.getFileSystem(), (Session)this, this.getSubject(), hierarchyManager, this, wspName);
        return this.rep.getSecurityManager().getAccessManager((Session)this, ctx);
    }

    protected void sanityCheck() throws RepositoryException {
        if (!this.alive) {
            throw new RepositoryException("this session has been closed");
        }
    }

    public synchronized ItemValidator getValidator() throws RepositoryException {
        if (this.validator == null) {
            this.validator = new ItemValidator(this.rep.getNodeTypeRegistry(), this.getHierarchyManager(), this);
        }
        return this.validator;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Session createSession(String workspaceName) throws AccessDeniedException, NoSuchWorkspaceException, RepositoryException {
        if (workspaceName == null) {
            workspaceName = this.rep.getConfig().getDefaultWorkspaceName();
        }
        if (this.loginContext != null) {
            return this.rep.createSession(this.loginContext, workspaceName);
        }
        return this.rep.createSession(this.getSubject(), workspaceName);
    }

    public AccessManager getAccessManager() {
        return this.accessMgr;
    }

    public NodeTypeManagerImpl getNodeTypeManager() {
        return this.ntMgr;
    }

    public ItemManager getItemManager() {
        return this.itemMgr;
    }

    protected SessionItemStateManager getItemStateManager() {
        return this.itemStateMgr;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierMgr;
    }

    public InternalVersionManager getInternalVersionManager() {
        return this.versionMgr;
    }

    protected RetentionRegistry getRetentionRegistry() throws RepositoryException {
        return this.wsp.getRetentionRegistry();
    }

    public NodeTypeInstanceHandler getNodeTypeInstanceHandler() {
        return this.ntInstanceHandler;
    }

    protected void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public NodeImpl getNodeById(NodeId id) throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            return (NodeImpl)this.getItemManager().getItem(id);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(id.toString());
        }
    }

    protected String[] getWorkspaceNames() throws RepositoryException {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.rep.getWorkspaceNames()) {
            try {
                if (!this.getAccessManager().canAccess(name)) continue;
                names.add(name);
            }
            catch (NoSuchWorkspaceException e) {
                log.warn("Workspace disappeared unexpectedly: " + name, (Throwable)e);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    protected void createWorkspace(String workspaceName) throws AccessDeniedException, RepositoryException {
        this.rep.createWorkspace(workspaceName);
    }

    protected void createWorkspace(String workspaceName, InputSource configTemplate) throws AccessDeniedException, RepositoryException {
        this.rep.createWorkspace(workspaceName, configTemplate);
    }

    protected void notifyLoggingOut() {
        ArrayList<SessionListener> copy = new ArrayList<SessionListener>(this.listeners.values());
        for (SessionListener listener : copy) {
            if (listener == null) continue;
            listener.loggingOut(this);
        }
    }

    protected void notifyLoggedOut() {
        ArrayList<SessionListener> copy = new ArrayList<SessionListener>(this.listeners.values());
        for (SessionListener listener : copy) {
            if (listener == null) continue;
            listener.loggedOut(this);
        }
    }

    public void addListener(SessionListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public GarbageCollector createDataStoreGarbageCollector() throws RepositoryException {
        ArrayList<PersistenceManager> pmList = new ArrayList<PersistenceManager>();
        InternalVersionManagerImpl vm = (InternalVersionManagerImpl)this.rep.getVersionManager();
        PersistenceManager pm = vm.getPersistenceManager();
        pmList.add(pm);
        String[] wspNames = this.rep.getWorkspaceNames();
        Session[] sessions = new Session[wspNames.length];
        for (int i = 0; i < wspNames.length; ++i) {
            String wspName = wspNames[i];
            RepositoryImpl.WorkspaceInfo wspInfo = this.rep.getWorkspaceInfo(wspName);
            SystemSession session = SystemSession.create(this.rep, wspInfo.getConfig());
            this.rep.onSessionCreated(session);
            wspInfo.initialize();
            sessions[i] = session;
            pm = wspInfo.getPersistenceManager();
            pmList.add(pm);
        }
        IterablePersistenceManager[] ipmList = new IterablePersistenceManager[pmList.size()];
        for (int i = 0; i < pmList.size(); ++i) {
            pm = (PersistenceManager)pmList.get(i);
            if (!(pm instanceof IterablePersistenceManager)) {
                ipmList = null;
                break;
            }
            ipmList[i] = (IterablePersistenceManager)pm;
        }
        GarbageCollector gc = new GarbageCollector(this.rep, this, ipmList, sessions);
        return gc;
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + uri, (Throwable)e);
        }
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + prefix, (Throwable)e);
        }
    }

    public String getJCRName(Name name) throws NamespaceException {
        return this.namePathResolver.getJCRName(name);
    }

    public Name getQName(String name) throws IllegalNameException, NamespaceException {
        return this.namePathResolver.getQName(name);
    }

    public String getJCRPath(Path path) throws NamespaceException {
        return this.namePathResolver.getJCRPath(path);
    }

    public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.namePathResolver.getQPath(path);
    }

    public Path getQPath(String path, boolean normalizeIdentifier) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.namePathResolver.getQPath(path, normalizeIdentifier);
    }

    public Path getPath(String identifier) throws MalformedPathException {
        try {
            return this.getHierarchyManager().getPath(NodeId.valueOf(identifier));
        }
        catch (RepositoryException e) {
            throw new MalformedPathException("Identifier '" + identifier + "' cannot be resolved.");
        }
    }

    public void checkFormat(String identifier) throws MalformedPathException {
        try {
            NodeId.valueOf(identifier);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedPathException("Invalid identifier: " + identifier);
        }
    }

    public PrincipalManager getPrincipalManager() throws RepositoryException, AccessDeniedException {
        if (this.principalManager == null) {
            this.principalManager = this.rep.getSecurityManager().getPrincipalManager((Session)this);
        }
        return this.principalManager;
    }

    public UserManager getUserManager() throws AccessDeniedException, RepositoryException {
        if (this.userManager == null) {
            this.userManager = this.rep.getSecurityManager().getUserManager((Session)this);
        }
        return this.userManager;
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        if (!this.hasPermission(absPath, actions)) {
            throw new AccessControlException(actions);
        }
    }

    public Workspace getWorkspace() {
        return this.getWorkspaceImpl();
    }

    WorkspaceImpl getWorkspaceImpl() {
        return this.wsp;
    }

    public Session impersonate(Credentials otherCredentials) throws LoginException, RepositoryException {
        this.sanityCheck();
        if (!(otherCredentials instanceof SimpleCredentials)) {
            String msg = "impersonate failed: incompatible credentials, SimpleCredentials expected";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        SimpleCredentials creds = (SimpleCredentials)otherCredentials;
        creds.setAttribute("org.apache.jackrabbit.core.security.impersonator", (Object)this.subject);
        try {
            Session session = this.rep.login(otherCredentials, this.getWorkspace().getName());
            return session;
        }
        catch (NoSuchWorkspaceException nswe) {
            String msg = "impersonate failed";
            log.error(msg, (Throwable)nswe);
            throw new RepositoryException(msg, (Throwable)nswe);
        }
        finally {
            creds.removeAttribute("org.apache.jackrabbit.core.security.impersonator");
        }
    }

    public Node getRootNode() throws RepositoryException {
        this.sanityCheck();
        return this.getItemManager().getRootNode();
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        try {
            NodeImpl node = this.getNodeById(new NodeId(uuid));
            if (node.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
                return node;
            }
            throw new ItemNotFoundException(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException("Invalid UUID: " + uuid, (Throwable)e);
        }
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().getItem(p);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().itemExists(p);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        if (this.hasPermission("/", "read")) {
            this.getItemManager().getRootNode().save();
        } else {
            NodeId id = this.getItemStateManager().getIdOfRootTransientNodeState();
            this.getItemManager().getItem(id).save();
        }
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.sanityCheck();
        ClusterNode cluster = this.rep.getClusterNode();
        if (cluster != null && this.clusterSyncOnRefresh()) {
            try {
                cluster.sync();
            }
            catch (ClusterException e) {
                throw new RepositoryException("Unable to synchronize with the cluster", (Throwable)e);
            }
        }
        if (!keepChanges) {
            this.itemStateMgr.disposeAllTransientItemStates();
        }
    }

    protected boolean clusterSyncOnRefresh() {
        return this.getAttribute(DISABLE_CLUSTER_SYNC_ON_REFRESH) == null;
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.sanityCheck();
        return this.itemStateMgr.hasAnyTransientItemStates();
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        AccessManager acMgr;
        NodeDefinitionImpl newTargetDef;
        NodeImpl destParentNode;
        Path.Element destName;
        Path destPath;
        NodeImpl srcParentNode;
        NodeImpl targetNode;
        Path.Element srcName;
        Path srcPath;
        this.sanityCheck();
        try {
            srcPath = this.getQPath(srcAbsPath).getNormalizedPath();
            if (!srcPath.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + srcAbsPath);
            }
            srcName = srcPath.getNameElement();
            Path srcParentPath = srcPath.getAncestor(1);
            targetNode = this.getItemManager().getNode(srcPath);
            srcParentNode = this.getItemManager().getNode(srcParentPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(srcAbsPath);
        }
        catch (NameException e) {
            String msg = srcAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        try {
            destPath = this.getQPath(destAbsPath).getNormalizedPath();
            if (!destPath.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + destAbsPath);
            }
            if (srcPath.isAncestorOf(destPath)) {
                String msg = destAbsPath + ": invalid destination path (cannot be descendant of source path)";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            destName = destPath.getNameElement();
            Path destParentPath = destPath.getAncestor(1);
            destParentNode = this.getItemManager().getNode(destParentPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(destAbsPath);
        }
        catch (NameException e) {
            String msg = destAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        if (this.hierMgr.isShareAncestor(targetNode.getNodeId(), destParentNode.getNodeId())) {
            String msg = destAbsPath + ": invalid destination path (share cycle detected)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = destAbsPath + ": invalid destination path (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeImpl existing = null;
        try {
            existing = this.getItemManager().getNode(destPath);
            if (!existing.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException("Same name siblings are not allowed: " + existing);
            }
        }
        catch (AccessDeniedException ade) {
            throw new ItemExistsException(destAbsPath);
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        int options = 406;
        this.getValidator().checkRemove(srcParentNode, options, 0);
        this.getValidator().checkModify(destParentNode, options, 0);
        NodeTypeImpl nt = (NodeTypeImpl)targetNode.getPrimaryNodeType();
        try {
            newTargetDef = destParentNode.getApplicableChildNodeDefinition(destName.getName(), nt.getQName());
        }
        catch (RepositoryException re) {
            String msg = destAbsPath + ": no definition found in parent node's node type for new node";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        if (existing != null && !newTargetDef.allowsSameNameSiblings()) {
            throw new ItemExistsException("Same name siblings not allowed: " + existing);
        }
        NodeId targetId = targetNode.getNodeId();
        int index = srcName.getIndex();
        if (index == 0) {
            index = 1;
        }
        if (!(acMgr = this.getAccessManager()).isGranted(srcPath, 8) || !acMgr.isGranted(destPath, 132)) {
            String msg = "Not allowed to move node " + srcAbsPath + " to " + destAbsPath;
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
        if (srcParentNode.isSame(destParentNode)) {
            destParentNode.renameChildNode(srcName.getName(), index, targetId, destName.getName());
        } else {
            if (targetNode.getNodeState().isShareable()) {
                String msg = "Moving a shareable node is not supported.";
                log.debug(msg);
                throw new UnsupportedRepositoryOperationException(msg);
            }
            NodeState srcParentState = (NodeState)srcParentNode.getOrCreateTransientItemState();
            srcParentState.removeChildNodeEntry(srcName.getName(), index);
            NodeState targetState = (NodeState)targetNode.getOrCreateTransientItemState();
            targetState.setParentId(destParentNode.getNodeId());
            NodeState destParentState = (NodeState)destParentNode.getOrCreateTransientItemState();
            destParentState.addChildNodeEntry(destName.getName(), targetId);
        }
        targetNode.onRedefine(newTargetDef.unwrap());
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        NodeImpl parent;
        this.sanityCheck();
        try {
            Path p = this.getQPath(parentAbsPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + parentAbsPath);
            }
            parent = this.getItemManager().getNode(p);
        }
        catch (NameException e) {
            String msg = parentAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(parentAbsPath);
        }
        int options = 406;
        this.getValidator().checkModify(parent, options, 0);
        SessionImporter importer = new SessionImporter(parent, this, uuidBehavior, this.wsp.getConfig().getImportConfig());
        return new ImportHandler(importer, (Session)this);
    }

    public boolean isLive() {
        return this.alive;
    }

    private void removeRegisteredEventListeners() {
        try {
            ObservationManager manager = this.getWorkspace().getObservationManager();
            List listeners = IteratorUtils.toList((Iterator)manager.getRegisteredEventListeners());
            for (EventListener listener : listeners) {
                try {
                    manager.removeEventListener(listener);
                }
                catch (RepositoryException e) {
                    log.warn("Error removing event listener: " + listener, (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Error removing event listeners", (Throwable)e);
        }
    }

    public synchronized void logout() {
        if (!this.alive) {
            return;
        }
        this.removeRegisteredEventListeners();
        this.itemStateMgr.disposeAllTransientItemStates();
        this.notifyLoggingOut();
        this.itemStateMgr.dispose();
        this.itemMgr.dispose();
        this.wsp.dispose();
        this.alive = false;
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (javax.security.auth.login.LoginException le) {
                log.warn("failed to logout current subject: " + le.getMessage());
            }
            this.loginContext = null;
        }
        try {
            this.accessMgr.close();
        }
        catch (Exception e) {
            log.warn("error while closing AccessManager", (Throwable)e);
        }
        this.notifyLoggedOut();
    }

    public Repository getRepository() {
        return this.rep;
    }

    public ValueFactory getValueFactory() {
        if (this.valueFactory == null) {
            this.valueFactory = new ValueFactoryImpl(this, this.rep.getDataStore());
        }
        return this.valueFactory;
    }

    public String getUserID() {
        return this.userId;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        super.setNamespacePrefix(prefix, uri);
        this.namePathResolver = new DefaultNamePathResolver((NamespaceResolver)this, true);
    }

    public void addLockToken(String lt) {
        try {
            this.wsp.getLockManager().addLockToken(lt);
        }
        catch (RepositoryException e) {
            log.debug("Error while adding lock token.");
        }
    }

    public String[] getLockTokens() {
        try {
            return this.wsp.getLockManager().getLockTokens();
        }
        catch (RepositoryException e) {
            log.debug("Error while accessing lock tokens.");
            return new String[0];
        }
    }

    public void removeLockToken(String lt) {
        try {
            this.wsp.getLockManager().removeLockToken(lt);
        }
        catch (RepositoryException e) {
            log.debug("Error while removing lock token.");
        }
    }

    public LockManager getLockManager() throws RepositoryException {
        return this.wsp.getInternalLockManager();
    }

    public Lock[] getLocks() {
        if (!this.alive) {
            log.error("failed to retrieve locks: session has been closed");
            return new Lock[0];
        }
        try {
            return this.getLockManager().getLocks(this);
        }
        catch (RepositoryException e) {
            log.error("Lock manager not available.", (Throwable)e);
            return new Lock[0];
        }
    }

    public Node getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        NodeId nodeId;
        try {
            nodeId = NodeId.valueOf(id);
        }
        catch (IllegalArgumentException iae) {
            throw new RepositoryException("invalid identifier: " + id);
        }
        return this.getNodeById(nodeId);
    }

    public Node getNode(String absPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().getNode(p);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().getProperty(p);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().nodeExists(p);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().propertyExists(p);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public void removeItem(String absPath) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        ItemImpl item;
        this.sanityCheck();
        try {
            Path p = this.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            item = this.getItemManager().getItem(p);
        }
        catch (AccessDeniedException e) {
            throw new PathNotFoundException(absPath);
        }
        catch (NameException e) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        item.remove();
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        this.sanityCheck();
        Path path = this.getQPath(absPath).getNormalizedPath();
        if (!path.isAbsolute()) {
            throw new RepositoryException("Absolute path expected. Was:" + absPath);
        }
        HashSet<String> s = new HashSet<String>(Arrays.asList(actions.split(",")));
        int permissions = 0;
        if (s.remove("read")) {
            permissions |= 1;
        }
        if (s.remove("add_node")) {
            permissions |= 4;
        }
        if (s.remove("set_property")) {
            permissions |= 2;
        }
        if (s.remove("remove")) {
            permissions = this.nodeExists(absPath) ? (permissions |= this.propertyExists(absPath) ? 24 : 8) : (this.propertyExists(absPath) ? (permissions |= 0x10) : 24);
        }
        if (!s.isEmpty()) {
            throw new IllegalArgumentException("Unknown actions: " + s);
        }
        try {
            return this.getAccessManager().isGranted(path, permissions);
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        int options = 406;
        if (target instanceof Node) {
            if (methodName.equals("addNode") || methodName.equals("addMixin") || methodName.equals("orderBefore") || methodName.equals("removeMixin") || methodName.equals("removeShare") || methodName.equals("removeSharedSet") || methodName.equals("setPrimaryType") || methodName.equals("setProperty") || methodName.equals("update")) {
                return this.getValidator().canModify((ItemImpl)target, options, 0);
            }
            if (methodName.equals("remove")) {
                try {
                    this.getValidator().checkRemove((ItemImpl)target, options, 0);
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        } else if (target instanceof Property) {
            if (methodName.equals("setValue") || methodName.equals("save")) {
                return this.getValidator().canModify((ItemImpl)target, options, 0);
            }
            if (methodName.equals("remove")) {
                try {
                    this.getValidator().checkRemove((ItemImpl)target, options, 0);
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        } else if (target instanceof Workspace ? !methodName.equals("clone") && !methodName.equals("copy") && !methodName.equals("createWorkspace") && !methodName.equals("deleteWorkspace") && !methodName.equals("getImportContentHandler") && !methodName.equals("importXML") && methodName.equals("move") : !(target instanceof Session) || methodName.equals("clone") || methodName.equals("removeItem") || methodName.equals("getImportContentHandler") || methodName.equals("importXML") || methodName.equals("save")) {
            // empty if block
        }
        return true;
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.accessMgr instanceof AccessControlManager) {
            return (AccessControlManager)this.accessMgr;
        }
        throw new UnsupportedRepositoryOperationException("Access control discovery is not supported.");
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        if (this.retentionManager == null) {
            this.getRetentionRegistry();
            this.retentionManager = new RetentionManagerImpl(this);
        }
        return this.retentionManager;
    }

    public void dump(PrintStream ps) {
        ps.print("Session: ");
        if (this.userId == null) {
            ps.print("unknown");
        } else {
            ps.print(this.userId);
        }
        ps.println(" (" + this + ")");
        ps.println();
        this.itemMgr.dump(ps);
        ps.println();
        this.itemStateMgr.dump(ps);
    }

    public void finalize() {
        if (this.alive) {
            log.warn("Unclosed session detected. The session was opened here: ", (Throwable)this.openStackTrace);
            this.logout();
        }
    }
}

