/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.ConfigurationParser;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.apache.jackrabbit.core.util.RepositoryLockMechanismFactory;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfig
implements FileSystemFactory,
DataStoreFactory,
QueryHandlerFactory {
    private static Logger log = LoggerFactory.getLogger(RepositoryConfig.class);
    private static final String REPOSITORY_XML = "repository.xml";
    private static final String WORKSPACE_XML = "workspace.xml";
    private Map<String, WorkspaceConfig> workspaces = new HashMap<String, WorkspaceConfig>();
    private final String home;
    private final SecurityConfig sec;
    private final FileSystemFactory fsf;
    private final String defaultWorkspace;
    private final RepositoryConfigurationParser parser;
    private final String workspaceDirectory;
    private final String workspaceConfigDirectory;
    private final int workspaceMaxIdleTime;
    private final Element template;
    private final VersioningConfig vc;
    private final QueryHandlerFactory qhf;
    private final ClusterConfig cc;
    private final DataStoreFactory dsf;
    private final RepositoryLockMechanismFactory rlf;
    private final DataSourceConfig dsc;
    private final ConnectionFactory cf;

    public static RepositoryConfig install(File dir) throws IOException, ConfigurationException {
        return RepositoryConfig.install(new File(dir, REPOSITORY_XML), dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryConfig install(File xml, File dir) throws IOException, ConfigurationException {
        if (!dir.exists()) {
            log.info("Creating repository directory {}", (Object)dir);
            dir.mkdirs();
        }
        if (!xml.exists()) {
            log.info("Installing default repository configuration to {}", (Object)xml);
            FileOutputStream output = new FileOutputStream(xml);
            try {
                InputStream input = RepositoryImpl.class.getResourceAsStream(REPOSITORY_XML);
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                finally {
                    input.close();
                }
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        return RepositoryConfig.create(xml, dir);
    }

    public static RepositoryConfig create(File dir) throws ConfigurationException {
        return RepositoryConfig.create(new File(dir, REPOSITORY_XML), dir);
    }

    public static RepositoryConfig create(File xml, File dir) throws ConfigurationException {
        if (!dir.isDirectory()) {
            throw new ConfigurationException("Repository directory " + dir + " does not exist");
        }
        if (!xml.isFile()) {
            throw new ConfigurationException("Repository configuration file " + xml + " does not exist");
        }
        return RepositoryConfig.create(new InputSource(xml.toURI().toString()), dir.getPath());
    }

    public static RepositoryConfig create(String file, String home) throws ConfigurationException {
        URI uri = new File(file).toURI();
        return RepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig create(URI uri, String home) throws ConfigurationException {
        return RepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig create(InputStream input, String home) throws ConfigurationException {
        return RepositoryConfig.create(new InputSource(input), home);
    }

    public static RepositoryConfig create(InputSource xml, String home) throws ConfigurationException {
        Properties variables = new Properties(System.getProperties());
        variables.setProperty("rep.home", home);
        RepositoryConfigurationParser parser = new RepositoryConfigurationParser(variables, new ConnectionFactory());
        RepositoryConfig config = parser.parseRepositoryConfig(xml);
        config.init();
        return config;
    }

    public RepositoryConfig(String home, SecurityConfig sec, FileSystemFactory fsf, String workspaceDirectory, String workspaceConfigDirectory, String defaultWorkspace, int workspaceMaxIdleTime, Element template, VersioningConfig vc, QueryHandlerFactory qhf, ClusterConfig cc, DataStoreFactory dsf, RepositoryLockMechanismFactory rlf, DataSourceConfig dsc, ConnectionFactory cf, RepositoryConfigurationParser parser) {
        this.home = home;
        this.sec = sec;
        this.fsf = fsf;
        this.workspaceDirectory = workspaceDirectory;
        this.workspaceConfigDirectory = workspaceConfigDirectory;
        this.workspaceMaxIdleTime = workspaceMaxIdleTime;
        this.defaultWorkspace = defaultWorkspace;
        this.template = template;
        this.vc = vc;
        this.qhf = qhf;
        this.cc = cc;
        this.dsf = dsf;
        this.rlf = rlf;
        this.dsc = dsc;
        this.cf = cf;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigurationException, IllegalStateException {
        try {
            this.cf.registerDataSources(this.dsc);
        }
        catch (RepositoryException e) {
            throw new ConfigurationException("failed to register data sources", (Exception)((Object)e));
        }
        if (!this.workspaces.isEmpty()) {
            throw new IllegalStateException("Repository configuration has already been initialized.");
        }
        File directory = new File(this.workspaceDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (this.workspaceConfigDirectory != null) {
            try {
                FileSystem fs = this.fsf.getFileSystem();
                try {
                    String[] dirNames;
                    if (!fs.exists(this.workspaceConfigDirectory)) {
                        fs.createFolder(this.workspaceConfigDirectory);
                    }
                    for (String dir : dirNames = fs.listFolders(this.workspaceConfigDirectory)) {
                        String configDir = this.workspaceConfigDirectory + "/" + dir;
                        WorkspaceConfig wc = this.loadWorkspaceConfig(fs, configDir);
                        if (wc == null) continue;
                        this.addWorkspaceConfig(wc);
                    }
                }
                finally {
                    fs.close();
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("error while loading workspace configurations from path " + this.workspaceConfigDirectory, e);
            }
        } else {
            File[] files = directory.listFiles();
            if (files == null) {
                throw new ConfigurationException("Invalid workspace root directory: " + this.workspaceDirectory);
            }
            for (File file : files) {
                WorkspaceConfig wc = this.loadWorkspaceConfig(file);
                if (wc == null) continue;
                this.addWorkspaceConfig(wc);
            }
        }
        if (!this.workspaces.containsKey(this.defaultWorkspace)) {
            if (!this.workspaces.isEmpty()) {
                log.warn("Potential misconfiguration. No configuration found for default workspace: " + this.defaultWorkspace);
            }
            this.createWorkspaceConfig(this.defaultWorkspace, (StringBuffer)null);
        }
    }

    private WorkspaceConfig loadWorkspaceConfig(File directory) throws ConfigurationException {
        try {
            File file = new File(directory, WORKSPACE_XML);
            InputSource xml = new InputSource(new FileInputStream(file));
            xml.setSystemId(file.toURI().toString());
            Properties variables = new Properties();
            variables.setProperty("wsp.home", directory.getPath());
            RepositoryConfigurationParser localParser = this.parser.createSubParser(variables);
            return localParser.parseWorkspaceConfig(xml);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private WorkspaceConfig loadWorkspaceConfig(FileSystem fs, String configDir) throws ConfigurationException {
        InputStreamReader configReader = null;
        try {
            String configPath = configDir + "/" + WORKSPACE_XML;
            if (!fs.exists(configPath)) {
                WorkspaceConfig workspaceConfig = null;
                return workspaceConfig;
            }
            configReader = new InputStreamReader(fs.getInputStream(configPath));
            InputSource xml = new InputSource(configReader);
            xml.setSystemId(configPath);
            File homeDir = new File(this.workspaceDirectory, FileSystemPathUtil.getName(configDir));
            if (!homeDir.exists()) {
                homeDir.mkdir();
            }
            Properties variables = new Properties(this.parser.getVariables());
            variables.setProperty("wsp.home", homeDir.getPath());
            RepositoryConfigurationParser localParser = this.parser.createSubParser(variables);
            WorkspaceConfig workspaceConfig = localParser.parseWorkspaceConfig(xml);
            IOUtils.closeQuietly((Reader)configReader);
            return workspaceConfig;
        }
        catch (FileSystemException e) {
            throw new ConfigurationException("Failed to load workspace configuration", e);
        }
        finally {
            IOUtils.closeQuietly(configReader);
        }
    }

    private void addWorkspaceConfig(WorkspaceConfig wc) throws ConfigurationException {
        String name = wc.getName();
        if (this.workspaces.containsKey(name)) {
            throw new ConfigurationException("Duplicate workspace configuration: " + name);
        }
        this.workspaces.put(name, wc);
    }

    private synchronized WorkspaceConfig internalCreateWorkspaceConfig(String name, Element template, StringBuffer configContent) throws ConfigurationException {
        FileSystem virtualFS;
        File directory = new File(this.workspaceDirectory, name);
        if (!directory.mkdir()) {
            if (directory.exists()) {
                throw new ConfigurationException("Workspace directory already exists: " + name);
            }
            throw new ConfigurationException("Failed to create workspace directory: " + name);
        }
        if (this.workspaceConfigDirectory != null) {
            try {
                virtualFS = this.fsf.getFileSystem();
            }
            catch (RepositoryException e) {
                throw new ConfigurationException("File system configuration error", (Exception)((Object)e));
            }
        } else {
            virtualFS = null;
        }
        try {
            WorkspaceConfig wc;
            OutputStreamWriter configWriter;
            if (virtualFS != null) {
                String configDir = this.workspaceConfigDirectory + "/" + name;
                String configFile = configDir + "/" + WORKSPACE_XML;
                try {
                    virtualFS.createFolder(configDir);
                    configWriter = new OutputStreamWriter(virtualFS.getOutputStream(configFile));
                }
                catch (FileSystemException e) {
                    throw new ConfigurationException("failed to create workspace configuration at path " + configFile, e);
                }
            }
            File file = new File(directory, WORKSPACE_XML);
            try {
                configWriter = new FileWriter(file);
            }
            catch (IOException e) {
                throw new ConfigurationException("failed to create workspace configuration at path " + file.getPath(), e);
            }
            try {
                template.setAttribute("name", name);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                if (configContent == null) {
                    transformer.transform(new DOMSource(template), new StreamResult(configWriter));
                } else {
                    StringWriter writer = new StringWriter();
                    transformer.transform(new DOMSource(template), new StreamResult(writer));
                    String s = writer.getBuffer().toString();
                    configWriter.write(s);
                    configContent.append(s);
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Cannot create a workspace configuration file", e);
            }
            catch (TransformerConfigurationException e) {
                throw new ConfigurationException("Cannot create a workspace configuration writer", e);
            }
            catch (TransformerException e) {
                throw new ConfigurationException("Cannot create a workspace configuration file", e);
            }
            finally {
                IOUtils.closeQuietly((Writer)configWriter);
            }
            if (virtualFS != null) {
                String configDir = this.workspaceConfigDirectory + "/" + name;
                wc = this.loadWorkspaceConfig(virtualFS, configDir);
            } else {
                wc = this.loadWorkspaceConfig(directory);
            }
            if (wc != null) {
                this.addWorkspaceConfig(wc);
                WorkspaceConfig workspaceConfig = wc;
                return workspaceConfig;
            }
            throw new ConfigurationException("Failed to load the created configuration for workspace " + name + ".");
        }
        finally {
            try {
                if (virtualFS != null) {
                    virtualFS.close();
                }
            }
            catch (FileSystemException ignore) {}
        }
    }

    public WorkspaceConfig createWorkspaceConfig(String name, StringBuffer configContent) throws ConfigurationException {
        return this.internalCreateWorkspaceConfig(name, this.template, configContent);
    }

    public WorkspaceConfig createWorkspaceConfig(String name, InputSource template) throws ConfigurationException {
        ConfigurationParser parser = new ConfigurationParser(new Properties());
        Element workspaceTemplate = parser.parseXML(template);
        return this.internalCreateWorkspaceConfig(name, workspaceTemplate, null);
    }

    public String getHomeDir() {
        return this.home;
    }

    @Override
    public FileSystem getFileSystem() throws RepositoryException {
        return this.fsf.getFileSystem();
    }

    public String getAppName() {
        return this.sec.getAppName();
    }

    public AccessManagerConfig getAccessManagerConfig() {
        return this.sec.getAccessManagerConfig();
    }

    public LoginModuleConfig getLoginModuleConfig() {
        return this.sec.getLoginModuleConfig();
    }

    public SecurityConfig getSecurityConfig() {
        return this.sec;
    }

    public String getWorkspacesConfigRootDir() {
        return this.workspaceDirectory;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public int getWorkspaceMaxIdleTime() {
        return this.workspaceMaxIdleTime;
    }

    public Collection<WorkspaceConfig> getWorkspaceConfigs() {
        return this.workspaces.values();
    }

    public WorkspaceConfig getWorkspaceConfig(String name) {
        return this.workspaces.get(name);
    }

    public VersioningConfig getVersioningConfig() {
        return this.vc;
    }

    public boolean isSearchEnabled() {
        return this.qhf != null;
    }

    @Override
    public QueryHandler getQueryHandler(QueryHandlerContext context) throws RepositoryException {
        if (this.qhf != null) {
            return this.qhf.getQueryHandler(context);
        }
        return null;
    }

    public ClusterConfig getClusterConfig() {
        return this.cc;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.cf;
    }

    @Override
    public DataStore getDataStore() throws RepositoryException {
        return this.dsf.getDataStore();
    }

    public RepositoryLockMechanism getRepositoryLockMechanism() throws RepositoryException {
        return this.rlf.getRepositoryLockMechanism();
    }
}

