/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.util.Text;

public class CryptedSimpleCredentials
implements Credentials {
    private final String algorithm;
    private final String cryptedPassword;
    private final String userId;
    private final Map<String, Object> attributes;

    public CryptedSimpleCredentials(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.userId = credentials.getUserID();
        if (this.userId == null || this.userId.length() == 0) {
            throw new IllegalArgumentException();
        }
        char[] pwd = credentials.getPassword();
        if (pwd == null) {
            throw new IllegalArgumentException();
        }
        String password = new String(pwd);
        String algo = CryptedSimpleCredentials.getAlgorithm(password);
        if (algo == null) {
            this.algorithm = "sha1";
            this.cryptedPassword = CryptedSimpleCredentials.crypt(password, this.algorithm);
        } else {
            this.algorithm = algo;
            this.cryptedPassword = password;
        }
        String[] attNames = credentials.getAttributeNames();
        this.attributes = new HashMap<String, Object>(attNames.length);
        for (String attName : attNames) {
            this.attributes.put(attName, credentials.getAttribute(attName));
        }
    }

    public CryptedSimpleCredentials(String userId, String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (userId == null || userId.length() == 0 || password == null) {
            throw new IllegalArgumentException("Invalid userID or password. Neither may be null, the userID must have a length > 0.");
        }
        this.userId = userId;
        String algo = CryptedSimpleCredentials.getAlgorithm(password);
        if (algo == null) {
            this.algorithm = "sha1";
            this.cryptedPassword = CryptedSimpleCredentials.crypt(password, this.algorithm);
        } else {
            this.algorithm = algo;
            this.cryptedPassword = password;
        }
        this.attributes = Collections.emptyMap();
    }

    public String getUserID() {
        return this.userId;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPassword() {
        return this.cryptedPassword;
    }

    public boolean matches(SimpleCredentials credentials) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.getUserID().equalsIgnoreCase(credentials.getUserID())) {
            String toMatch = new String(credentials.getPassword());
            String algr = CryptedSimpleCredentials.getAlgorithm(toMatch);
            if (algr == null && this.algorithm != null) {
                return CryptedSimpleCredentials.crypt(toMatch, this.algorithm).equals(this.cryptedPassword);
            }
            if (algr != null && this.algorithm == null) {
                return CryptedSimpleCredentials.crypt(algr, this.cryptedPassword).equals(toMatch);
            }
            return toMatch.equals(this.cryptedPassword);
        }
        return false;
    }

    private static String crypt(String pwd, String algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder password = new StringBuilder();
        password.append("{").append(algorithm).append("}");
        password.append(Text.digest((String)algorithm, (byte[])pwd.getBytes("UTF-8")));
        return password.toString();
    }

    private static String getAlgorithm(String password) {
        int end = password.indexOf("}");
        if (password.startsWith("{") && end > 0) {
            return password.substring(1, end);
        }
        return null;
    }
}

