/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AbstractACLTemplate;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ACLTemplate
extends AbstractACLTemplate {
    private static final Logger log = LoggerFactory.getLogger(ACLTemplate.class);
    private final List<Entry> entries = new ArrayList<Entry>();
    private final PrincipalManager principalMgr;
    private final PrivilegeRegistry privilegeRegistry;

    ACLTemplate(String path, PrincipalManager principalMgr, PrivilegeRegistry privilegeRegistry, ValueFactory valueFactory) {
        super(path, valueFactory);
        this.principalMgr = principalMgr;
        this.privilegeRegistry = privilegeRegistry;
    }

    ACLTemplate(NodeImpl aclNode, PrivilegeRegistry privilegeRegistry) throws RepositoryException {
        super(aclNode != null ? aclNode.getParent().getPath() : null, aclNode != null ? aclNode.getSession().getValueFactory() : null);
        if (aclNode == null || !aclNode.isNodeType(AccessControlConstants.NT_REP_ACL)) {
            throw new IllegalArgumentException("Node must be of type 'rep:ACL'");
        }
        SessionImpl sImpl = (SessionImpl)aclNode.getSession();
        this.principalMgr = sImpl.getPrincipalManager();
        this.privilegeRegistry = privilegeRegistry;
        AccessControlManager acMgr = sImpl.getAccessControlManager();
        NodeIterator itr = aclNode.getNodes();
        while (itr.hasNext()) {
            NodeImpl aceNode = (NodeImpl)itr.nextNode();
            try {
                String principalName = aceNode.getProperty(AccessControlConstants.P_PRINCIPAL_NAME).getString();
                Object princ = this.principalMgr.getPrincipal(principalName);
                if (princ == null) {
                    log.debug("Principal with name " + principalName + " unknown to PrincipalManager.");
                    princ = new PrincipalImpl(principalName);
                }
                Value[] privValues = aceNode.getProperty(AccessControlConstants.P_PRIVILEGES).getValues();
                Privilege[] privs = new Privilege[privValues.length];
                for (int i = 0; i < privValues.length; ++i) {
                    privs[i] = acMgr.privilegeFromName(privValues[i].getString());
                }
                Entry ace = new Entry((Principal)princ, privs, aceNode.isNodeType(AccessControlConstants.NT_REP_GRANT_ACE), this.valueFactory);
                this.internalAdd(ace);
            }
            catch (RepositoryException e) {
                log.debug("Failed to build ACE from content.", (Object)e.getMessage());
            }
        }
    }

    private List<Entry> internalGetEntries(Principal principal) {
        String principalName = principal.getName();
        ArrayList<Entry> entriesPerPrincipal = new ArrayList<Entry>(2);
        for (Entry entry : this.entries) {
            if (!principalName.equals(entry.getPrincipal().getName())) continue;
            entriesPerPrincipal.add(entry);
        }
        return entriesPerPrincipal;
    }

    private synchronized boolean internalAdd(Entry entry) throws AccessControlException {
        Principal principal = entry.getPrincipal();
        List<Entry> entriesPerPrincipal = this.internalGetEntries(principal);
        if (entriesPerPrincipal.isEmpty()) {
            this.entries.add(entry);
            return true;
        }
        if (entriesPerPrincipal.contains(entry)) {
            return false;
        }
        int updateIndex = -1;
        AccessControlEntryImpl complementEntry = null;
        for (Entry e : entriesPerPrincipal) {
            if (entry.isAllow() == e.isAllow()) {
                int existingPrivs = e.getPrivilegeBits();
                if ((existingPrivs | ~entry.getPrivilegeBits()) == -1) {
                    return false;
                }
                updateIndex = this.entries.indexOf(e);
                this.entries.remove(e);
                int mergedBits = e.getPrivilegeBits() | entry.getPrivilegeBits();
                Privilege[] mergedPrivs = this.privilegeRegistry.getPrivileges(mergedBits);
                entry = new Entry(entry.getPrincipal(), mergedPrivs, entry.isAllow(), this.valueFactory);
                continue;
            }
            complementEntry = e;
        }
        if (complementEntry != null) {
            int complPrivs = complementEntry.getPrivilegeBits();
            int resultPrivs = Permission.diff(complPrivs, entry.getPrivilegeBits());
            if (resultPrivs == 0) {
                this.entries.remove(complementEntry);
                --updateIndex;
            } else if (resultPrivs != complPrivs) {
                int index = this.entries.indexOf(complementEntry);
                this.entries.remove(complementEntry);
                Entry tmpl = new Entry(entry.getPrincipal(), this.privilegeRegistry.getPrivileges(resultPrivs), !entry.isAllow(), this.valueFactory);
                this.entries.add(index, tmpl);
            }
        }
        if (updateIndex < 0) {
            this.entries.add(entry);
        } else {
            this.entries.add(updateIndex, entry);
        }
        return true;
    }

    @Override
    protected void checkValidEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException {
        if (restrictions != null && !restrictions.isEmpty()) {
            throw new AccessControlException("This AccessControlList does not allow for additional restrictions.");
        }
        if (principal instanceof UnknownPrincipal) {
            log.debug("Consider fallback principal as valid: {}", (Object)principal.getName());
        } else if (!this.principalMgr.hasPrincipal(principal.getName())) {
            throw new AccessControlException("Principal " + principal.getName() + " does not exist.");
        }
    }

    @Override
    protected List<? extends AccessControlEntry> getEntries() {
        return this.entries;
    }

    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        List<? extends AccessControlEntry> l = this.getEntries();
        return l.toArray(new AccessControlEntry[l.size()]);
    }

    public synchronized void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        if (!(ace instanceof Entry)) {
            throw new AccessControlException("Invalid AccessControlEntry implementation " + ace.getClass().getName() + ".");
        }
        if (!this.entries.contains(ace)) {
            throw new AccessControlException("AccessControlEntry " + ace + " cannot be removed from ACL defined at " + this.getPath());
        }
        this.entries.remove(ace);
    }

    public String[] getRestrictionNames() {
        return new String[0];
    }

    public int getRestrictionType(String restrictionName) {
        return 0;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.getEntries().size();
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException, RepositoryException {
        this.checkValidEntry(principal, privileges, isAllow, restrictions);
        Entry ace = new Entry(principal, privileges, isAllow, this.valueFactory);
        return this.internalAdd(ace);
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACLTemplate) {
            ACLTemplate acl = (ACLTemplate)obj;
            return this.path.equals(acl.path) && ((Object)this.entries).equals(acl.entries);
        }
        return false;
    }

    static class Entry
    extends AccessControlEntryImpl {
        Entry(Principal principal, Privilege[] privileges, boolean allow, ValueFactory valueFactory) throws AccessControlException {
            super(principal, privileges, allow, Collections.<String, Value>emptyMap(), valueFactory);
        }
    }
}

