/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collections;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexNodeResolver
extends NodeResolver {
    private final QueryManager queryManager;

    IndexNodeResolver(Session session, NamePathResolver resolver) throws RepositoryException {
        super(session, resolver);
        this.queryManager = session.getWorkspace().getQueryManager();
    }

    @Override
    public Node findNode(Name nodeName, Name ntName) throws RepositoryException {
        Query query = this.buildQuery(nodeName, ntName);
        NodeIterator res = query.execute().getNodes();
        if (res.hasNext()) {
            return res.nextNode();
        }
        return null;
    }

    @Override
    public Node findNode(Name propertyName, String value, Name ntName) throws RepositoryException {
        Query query = this.buildQuery(value, Collections.singleton(propertyName), ntName, true, 1L);
        NodeIterator res = query.execute().getNodes();
        if (res.hasNext()) {
            return res.nextNode();
        }
        return null;
    }

    @Override
    public NodeIterator findNodes(Set<Name> propertyNames, String value, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        Query query = this.buildQuery(value, propertyNames, ntName, exact, maxSize);
        return query.execute().getNodes();
    }

    private Query buildQuery(Name nodeName, Name ntName) throws RepositoryException {
        StringBuilder stmt = new StringBuilder("/jcr:root");
        stmt.append(this.getSearchRoot(ntName));
        stmt.append("//element(");
        stmt.append(ISO9075.encode((String)this.getNamePathResolver().getJCRName(nodeName)));
        stmt.append(",");
        stmt.append(this.getNamePathResolver().getJCRName(ntName));
        stmt.append(")");
        return this.queryManager.createQuery(stmt.toString(), "xpath");
    }

    private Query buildQuery(String value, Set<Name> props, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        StringBuilder stmt = new StringBuilder("/jcr:root");
        String searchRoot = this.getSearchRoot(ntName);
        if (!"/".equals(searchRoot)) {
            stmt.append(searchRoot);
        }
        stmt.append("//element(*,");
        stmt.append(this.getNamePathResolver().getJCRName(ntName));
        if (value == null) {
            stmt.append(")");
        } else {
            stmt.append(")[");
            int i = 0;
            for (Name prop : props) {
                stmt.append(exact ? "@" : "jcr:like(@");
                String pName = this.getNamePathResolver().getJCRName(prop);
                stmt.append(ISO9075.encode((String)pName));
                if (exact) {
                    stmt.append("='");
                    stmt.append(value);
                    stmt.append("'");
                } else {
                    stmt.append(",'%");
                    stmt.append(IndexNodeResolver.escapeForQuery(value));
                    stmt.append("%')");
                }
                if (++i >= props.size()) continue;
                stmt.append(" or ");
            }
            stmt.append("]");
        }
        Query q = this.queryManager.createQuery(stmt.toString(), "xpath");
        q.setLimit(maxSize);
        return q;
    }

    private static String escapeForQuery(String value) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\'') {
                ret.append("\\'");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

