/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntries;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NameSet;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.spi.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeState
extends ItemState {
    private Name nodeTypeName;
    private NameSet mixinTypeNames = new NameSet();
    private NodeId id;
    private NodeId parentId;
    private ChildNodeEntries childNodeEntries = new ChildNodeEntries();
    private NameSet propertyNames = new NameSet();
    private Set<NodeId> sharedSet = Collections.emptySet();
    private boolean sharedSetRW;
    private transient NodeStateListener listener;

    public NodeState(NodeState overlayedState, int initialStatus, boolean isTransient) {
        super(overlayedState, initialStatus, isTransient);
        this.pull();
    }

    public NodeState(NodeId id, Name nodeTypeName, NodeId parentId, int initialStatus, boolean isTransient) {
        super(initialStatus, isTransient);
        this.id = id;
        this.parentId = parentId;
        this.nodeTypeName = nodeTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void copy(ItemState state, boolean syncModCount) {
        ItemState itemState = state;
        synchronized (itemState) {
            NodeState nodeState = (NodeState)state;
            this.id = nodeState.id;
            this.parentId = nodeState.parentId;
            this.nodeTypeName = nodeState.nodeTypeName;
            this.mixinTypeNames = (NameSet)nodeState.mixinTypeNames.clone();
            this.propertyNames = (NameSet)nodeState.propertyNames.clone();
            this.childNodeEntries = (ChildNodeEntries)nodeState.childNodeEntries.clone();
            if (syncModCount) {
                this.setModCount(state.getModCount());
            }
            this.sharedSet = nodeState.sharedSet;
            this.sharedSetRW = false;
        }
    }

    @Override
    public final boolean isNode() {
        return true;
    }

    @Override
    public NodeId getParentId() {
        return this.parentId;
    }

    @Override
    public ItemId getId() {
        return this.id;
    }

    public NodeId getNodeId() {
        return this.id;
    }

    public void setParentId(NodeId parentId) {
        this.parentId = parentId;
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public synchronized Set<Name> getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    public synchronized void setMixinTypeNames(Set<Name> names) {
        this.mixinTypeNames.replaceAll(names);
    }

    public boolean hasChildNodeEntries() {
        return !this.childNodeEntries.isEmpty();
    }

    public synchronized boolean hasChildNodeEntry(Name name) {
        return !this.childNodeEntries.get(name).isEmpty();
    }

    public synchronized boolean hasChildNodeEntry(NodeId id) {
        return this.childNodeEntries.get(id) != null;
    }

    public synchronized boolean hasChildNodeEntry(Name name, int index) {
        return this.childNodeEntries.get(name, index) != null;
    }

    public synchronized boolean hasPropertyName(Name propName) {
        return this.propertyNames.contains(propName);
    }

    public synchronized ChildNodeEntry getChildNodeEntry(Name nodeName, int index) {
        return this.childNodeEntries.get(nodeName, index);
    }

    public synchronized ChildNodeEntry getChildNodeEntry(NodeId id) {
        return this.childNodeEntries.get(id);
    }

    public synchronized List<ChildNodeEntry> getChildNodeEntries() {
        return this.childNodeEntries;
    }

    public synchronized List<ChildNodeEntry> getChildNodeEntries(Name nodeName) {
        return this.childNodeEntries.get(nodeName);
    }

    public synchronized ChildNodeEntry addChildNodeEntry(Name nodeName, NodeId id) {
        ChildNodeEntry entry = this.childNodeEntries.add(nodeName, id);
        this.notifyNodeAdded(entry);
        return entry;
    }

    public synchronized boolean renameChildNodeEntry(Name oldName, int index, Name newName) {
        ChildNodeEntry oldEntry = this.childNodeEntries.remove(oldName, index);
        if (oldEntry != null) {
            ChildNodeEntry newEntry = this.childNodeEntries.add(newName, oldEntry.getId());
            this.notifyNodeAdded(newEntry);
            this.notifyNodeRemoved(oldEntry);
            return true;
        }
        return false;
    }

    public synchronized boolean removeChildNodeEntry(Name nodeName, int index) {
        ChildNodeEntry entry = this.childNodeEntries.remove(nodeName, index);
        if (entry != null) {
            this.notifyNodeRemoved(entry);
        }
        return entry != null;
    }

    public synchronized boolean removeChildNodeEntry(NodeId id) {
        ChildNodeEntry entry = this.childNodeEntries.remove(id);
        if (entry != null) {
            this.notifyNodeRemoved(entry);
        }
        return entry != null;
    }

    public synchronized void removeAllChildNodeEntries() {
        this.childNodeEntries.removeAll();
        this.notifyNodesReplaced();
    }

    public synchronized void setChildNodeEntries(List<ChildNodeEntry> nodeEntries) {
        if (nodeEntries instanceof ChildNodeEntries) {
            ChildNodeEntries entries = (ChildNodeEntries)nodeEntries;
            this.childNodeEntries = (ChildNodeEntries)entries.clone();
        } else {
            this.childNodeEntries.removeAll();
            this.childNodeEntries.addAll(nodeEntries);
        }
        this.notifyNodesReplaced();
    }

    public synchronized Set<Name> getPropertyNames() {
        return this.propertyNames;
    }

    public synchronized void addPropertyName(Name propName) {
        this.propertyNames.add(propName);
    }

    public synchronized boolean removePropertyName(Name propName) {
        return this.propertyNames.remove(propName);
    }

    public synchronized void removeAllPropertyNames() {
        this.propertyNames.removeAll();
    }

    public synchronized void setPropertyNames(Set<Name> propNames) {
        this.propertyNames.replaceAll(propNames);
    }

    public synchronized void setNodeTypeName(Name nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    public synchronized boolean isShareable() {
        return this.sharedSet != Collections.EMPTY_SET;
    }

    public synchronized boolean addShare(NodeId parentId) {
        if (this.sharedSet.contains(parentId)) {
            return false;
        }
        if (!this.sharedSetRW) {
            this.sharedSet = new LinkedHashSet<NodeId>(this.sharedSet);
            this.sharedSetRW = true;
        }
        return this.sharedSet.add(parentId);
    }

    public synchronized boolean containsShare(NodeId parentId) {
        return this.sharedSet.contains(parentId);
    }

    public Set<NodeId> getSharedSet() {
        if (this.sharedSet != Collections.EMPTY_SET) {
            return Collections.unmodifiableSet(this.sharedSet);
        }
        return Collections.emptySet();
    }

    public synchronized void setSharedSet(Set<NodeId> set) {
        if (set != Collections.EMPTY_SET) {
            this.sharedSet = new LinkedHashSet<NodeId>(set);
            this.sharedSetRW = true;
        } else {
            this.sharedSet = Collections.emptySet();
            this.sharedSetRW = false;
        }
    }

    public synchronized int removeShare(NodeId parentId) {
        if (this.sharedSet.contains(parentId)) {
            if (!this.sharedSetRW) {
                this.sharedSet = new LinkedHashSet<NodeId>(this.sharedSet);
                this.sharedSetRW = true;
            }
            this.sharedSet.remove(parentId);
            if (parentId.equals(this.parentId)) {
                this.parentId = !this.sharedSet.isEmpty() ? this.sharedSet.iterator().next() : null;
            }
        }
        return this.sharedSet.size();
    }

    public synchronized Set<Name> getAddedPropertyNames() {
        if (!this.hasOverlayedState()) {
            return this.propertyNames;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet<Name> set = new HashSet<Name>(this.propertyNames);
        set.removeAll(other.propertyNames);
        return set;
    }

    public synchronized List<ChildNodeEntry> getAddedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return this.childNodeEntries;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        return this.childNodeEntries.removeAll(other.childNodeEntries);
    }

    public synchronized Set<Name> getRemovedPropertyNames() {
        if (!this.hasOverlayedState()) {
            return Collections.emptySet();
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet<Name> set = new HashSet<Name>(other.propertyNames);
        set.removeAll(this.propertyNames);
        return set;
    }

    public synchronized List<ChildNodeEntry> getRemovedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.emptyList();
        }
        NodeState other = (NodeState)this.getOverlayedState();
        return other.childNodeEntries.removeAll(this.childNodeEntries);
    }

    public synchronized List<ChildNodeEntry> getRenamedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.emptyList();
        }
        ChildNodeEntries otherChildNodeEntries = ((NodeState)this.overlayedState).childNodeEntries;
        ArrayList<ChildNodeEntry> renamed = null;
        for (ChildNodeEntry cne : this.childNodeEntries) {
            ChildNodeEntry cneOther = otherChildNodeEntries.get(cne.getId());
            if (cneOther == null || cne.getName().equals(cneOther.getName())) continue;
            if (renamed == null) {
                renamed = new ArrayList<ChildNodeEntry>();
            }
            renamed.add(cne);
        }
        if (renamed == null) {
            return Collections.emptyList();
        }
        return renamed;
    }

    public synchronized List<ChildNodeEntry> getReorderedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.emptyList();
        }
        ChildNodeEntries otherChildNodeEntries = ((NodeState)this.overlayedState).childNodeEntries;
        if (this.childNodeEntries.isEmpty() || otherChildNodeEntries.isEmpty()) {
            return Collections.emptyList();
        }
        List<ChildNodeEntry> ours = this.childNodeEntries.retainAll(otherChildNodeEntries);
        List<ChildNodeEntry> others = otherChildNodeEntries.retainAll(this.childNodeEntries);
        ArrayList<ChildNodeEntry> reordered = null;
        int i = 0;
        while (i < ours.size()) {
            int j;
            ChildNodeEntry other;
            ChildNodeEntry entry = ours.get(i);
            if (entry == (other = others.get(i)) || entry.getId().equals(other.getId())) {
                ++i;
                continue;
            }
            if (reordered == null) {
                reordered = new ArrayList<ChildNodeEntry>();
            }
            if (i + 1 < ours.size() && entry.getId().equals(others.get(i + 1).getId())) {
                for (j = i; j < ours.size(); ++j) {
                    if (!ours.get(j).getId().equals(other.getId())) continue;
                    entry = ours.get(j);
                    break;
                }
            }
            reordered.add(entry);
            for (j = i; j < ours.size(); ++j) {
                if (!ours.get(j).getId().equals(entry.getId())) continue;
                ours.remove(j);
            }
            for (j = i; j < ours.size(); ++j) {
                if (!others.get(j).getId().equals(entry.getId())) continue;
                others.remove(j);
            }
        }
        if (reordered == null) {
            return Collections.emptyList();
        }
        return reordered;
    }

    public synchronized Set<NodeId> getAddedShares() {
        if (!this.hasOverlayedState() || !this.isShareable()) {
            return Collections.emptySet();
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet<NodeId> set = new HashSet<NodeId>(this.sharedSet);
        set.removeAll(other.sharedSet);
        return set;
    }

    public synchronized Set<NodeId> getRemovedShares() {
        if (!this.hasOverlayedState() || !this.isShareable()) {
            return Collections.emptySet();
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet<NodeId> set = new HashSet<NodeId>(other.sharedSet);
        set.removeAll(this.sharedSet);
        return set;
    }

    @Override
    public void setContainer(ItemStateListener listener) {
        if (listener instanceof NodeStateListener) {
            if (this.listener != null) {
                throw new IllegalStateException("State already connected to a listener: " + this.listener);
            }
            this.listener = (NodeStateListener)listener;
        }
        super.setContainer(listener);
    }

    @Override
    public long calculateMemoryFootprint() {
        return 350 + this.mixinTypeNames.size() * 250 + this.childNodeEntries.size() * 300 + this.propertyNames.size() * 250;
    }

    protected void notifyNodeAdded(ChildNodeEntry added) {
        if (this.listener != null) {
            this.listener.nodeAdded(this, added.getName(), added.getIndex(), added.getId());
        }
    }

    protected void notifyNodesReplaced() {
        if (this.listener != null) {
            this.listener.nodesReplaced(this);
        }
    }

    protected void notifyNodeRemoved(ChildNodeEntry removed) {
        if (this.listener != null) {
            this.listener.nodeRemoved(this, removed.getName(), removed.getIndex(), removed.getId());
        }
    }
}

