/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.util.EmptyLinkedMap;
import org.apache.jackrabbit.spi.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildNodeEntries
implements List<ChildNodeEntry>,
Cloneable {
    private LinkedMap entries;
    private Map<Name, Object> nameMap;
    private boolean shared;

    ChildNodeEntries() {
        this.init();
    }

    ChildNodeEntry get(NodeId id) {
        return (ChildNodeEntry)this.entries.get((Object)id);
    }

    List<ChildNodeEntry> get(Name nodeName) {
        Object obj = this.nameMap.get(nodeName);
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof List) {
            return Collections.unmodifiableList((List)obj);
        }
        return Collections.singletonList((ChildNodeEntry)obj);
    }

    ChildNodeEntry get(Name nodeName, int index) {
        if (index < 1) {
            throw new IllegalArgumentException("index is 1-based");
        }
        Object obj = this.nameMap.get(nodeName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List siblings = (List)obj;
            if (index <= siblings.size()) {
                return (ChildNodeEntry)siblings.get(index - 1);
            }
        } else if (index == 1) {
            return (ChildNodeEntry)obj;
        }
        return null;
    }

    ChildNodeEntry add(Name nodeName, NodeId id) {
        this.ensureModifiable();
        ArrayList<ChildNodeEntry> siblings = null;
        int index = 0;
        Object obj = this.nameMap.get(nodeName);
        if (obj != null) {
            if (obj instanceof List) {
                siblings = (ArrayList<ChildNodeEntry>)obj;
                if (siblings.size() > 0) {
                    nodeName = ((ChildNodeEntry)siblings.get(0)).getName();
                }
            } else {
                siblings = new ArrayList<ChildNodeEntry>();
                siblings.add((ChildNodeEntry)obj);
                this.nameMap.put(nodeName, siblings);
            }
            index = siblings.size();
        }
        ChildNodeEntry entry = new ChildNodeEntry(nodeName, id, ++index);
        if (siblings != null) {
            siblings.add(entry);
        } else {
            this.nameMap.put(nodeName, entry);
        }
        this.entries.put((Object)id, (Object)entry);
        return entry;
    }

    void addAll(List<ChildNodeEntry> entriesList) {
        for (ChildNodeEntry entry : entriesList) {
            this.add(entry.getName(), entry.getId());
        }
    }

    public ChildNodeEntry remove(Name nodeName, int index) {
        if (index < 1) {
            throw new IllegalArgumentException("index is 1-based");
        }
        this.ensureModifiable();
        Object obj = this.nameMap.get(nodeName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof ChildNodeEntry) {
            if (index != 1) {
                return null;
            }
            ChildNodeEntry removedEntry = (ChildNodeEntry)obj;
            this.nameMap.remove(nodeName);
            this.entries.remove((Object)removedEntry.getId());
            return removedEntry;
        }
        List siblings = (List)obj;
        if (index > siblings.size()) {
            return null;
        }
        ChildNodeEntry removedEntry = (ChildNodeEntry)siblings.remove(index - 1);
        this.entries.remove((Object)removedEntry.getId());
        for (int i = index - 1; i < siblings.size(); ++i) {
            ChildNodeEntry oldEntry = (ChildNodeEntry)siblings.get(i);
            ChildNodeEntry newEntry = new ChildNodeEntry(nodeName, oldEntry.getId(), oldEntry.getIndex() - 1);
            siblings.set(i, newEntry);
            this.entries.put((Object)newEntry.getId(), (Object)newEntry);
        }
        if (siblings.size() == 0) {
            this.nameMap.remove(nodeName);
        } else if (siblings.size() == 1) {
            this.nameMap.put(nodeName, siblings.get(0));
        }
        return removedEntry;
    }

    ChildNodeEntry remove(NodeId id) {
        ChildNodeEntry entry = (ChildNodeEntry)this.entries.get((Object)id);
        if (entry != null) {
            return this.remove(entry.getName(), entry.getIndex());
        }
        return entry;
    }

    public ChildNodeEntry remove(ChildNodeEntry entry) {
        return this.remove(entry.getName(), entry.getIndex());
    }

    public void removeAll() {
        this.init();
    }

    List<ChildNodeEntry> removeAll(ChildNodeEntries other) {
        if (this.entries.isEmpty()) {
            return Collections.emptyList();
        }
        if (other.isEmpty()) {
            return this;
        }
        ArrayList<ChildNodeEntry> result = new ArrayList<ChildNodeEntry>();
        for (ChildNodeEntry entry : this) {
            ChildNodeEntry otherEntry;
            if (entry == (otherEntry = other.get(entry.getId())) || otherEntry != null && entry.getName().equals(otherEntry.getName())) continue;
            result.add(entry);
        }
        return result;
    }

    List<ChildNodeEntry> retainAll(ChildNodeEntries other) {
        if (this.entries.isEmpty() || other.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ChildNodeEntry> result = new ArrayList<ChildNodeEntry>();
        for (ChildNodeEntry entry : this) {
            ChildNodeEntry otherEntry;
            if (entry == (otherEntry = other.get(entry.getId()))) {
                result.add(entry);
                continue;
            }
            if (otherEntry == null || !entry.getName().equals(otherEntry.getName())) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof ChildNodeEntry) {
            return this.entries.containsKey((Object)((ChildNodeEntry)o).getId());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object entry : c) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ChildNodeEntry get(int index) {
        return (ChildNodeEntry)this.entries.getValue(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof ChildNodeEntry) {
            return this.entries.indexOf((Object)((ChildNodeEntry)o).getId());
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public Iterator<ChildNodeEntry> iterator() {
        return new EntriesIterator();
    }

    @Override
    public ListIterator<ChildNodeEntry> listIterator() {
        return new EntriesIterator();
    }

    @Override
    public ListIterator<ChildNodeEntry> listIterator(int index) {
        if (index < 0 || index >= this.entries.size()) {
            throw new IndexOutOfBoundsException();
        }
        EntriesIterator iter = new EntriesIterator();
        while (index-- > 0) {
            iter.next();
        }
        return iter;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public List<ChildNodeEntry> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(new ArrayList<ChildNodeEntry>(this).subList(fromIndex, toIndex));
    }

    @Override
    public Object[] toArray() {
        Object[] array = new ChildNodeEntry[this.size()];
        return this.toArray(array);
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (!a.getClass().getComponentType().isAssignableFrom(ChildNodeEntry.class)) {
            throw new ArrayStoreException();
        }
        if (a.length < this.size()) {
            a = new ChildNodeEntry[this.size()];
        }
        MapIterator iter = this.entries.mapIterator();
        int i = 0;
        while (iter.hasNext()) {
            iter.next();
            a[i] = this.entries.getValue(i);
            ++i;
        }
        while (i < a.length) {
            a[i++] = null;
        }
        return a;
    }

    @Override
    public void add(int index, ChildNodeEntry element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(ChildNodeEntry o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends ChildNodeEntry> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends ChildNodeEntry> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChildNodeEntry remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChildNodeEntry set(int index, ChildNodeEntry element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChildNodeEntries) {
            ChildNodeEntries other = (ChildNodeEntries)obj;
            return ((Object)this.nameMap).equals(other.nameMap) && this.entries.equals((Object)other.entries) && this.shared == other.shared;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    protected Object clone() {
        try {
            ChildNodeEntries clone = (ChildNodeEntries)super.clone();
            if (this.nameMap != Collections.EMPTY_MAP) {
                clone.shared = true;
                this.shared = true;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void init() {
        this.nameMap = Collections.emptyMap();
        this.entries = EmptyLinkedMap.INSTANCE;
        this.shared = false;
    }

    private void ensureModifiable() {
        if (this.nameMap == Collections.EMPTY_MAP) {
            this.nameMap = new HashMap<Name, Object>();
            this.entries = new LinkedMap();
        } else if (this.shared) {
            this.entries = (LinkedMap)this.entries.clone();
            this.nameMap = new HashMap<Name, Object>(this.nameMap);
            for (Map.Entry<Name, Object> entry : this.nameMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof List)) continue;
                entry.setValue(new ArrayList((List)value));
            }
            this.shared = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntriesIterator
    implements ListIterator<ChildNodeEntry> {
        private final OrderedMapIterator mapIter;

        EntriesIterator() {
            this.mapIter = ChildNodeEntries.this.entries.orderedMapIterator();
        }

        @Override
        public boolean hasNext() {
            return this.mapIter.hasNext();
        }

        @Override
        public ChildNodeEntry next() {
            this.mapIter.next();
            return (ChildNodeEntry)this.mapIter.getValue();
        }

        @Override
        public boolean hasPrevious() {
            return this.mapIter.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return ChildNodeEntries.this.entries.indexOf(this.mapIter.getKey()) + 1;
        }

        @Override
        public ChildNodeEntry previous() {
            this.mapIter.previous();
            return (ChildNodeEntry)this.mapIter.getValue();
        }

        @Override
        public int previousIndex() {
            return ChildNodeEntries.this.entries.indexOf(this.mapIter.getKey()) - 1;
        }

        @Override
        public void add(ChildNodeEntry o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(ChildNodeEntry o) {
            throw new UnsupportedOperationException();
        }
    }
}

