/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlListener;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLTemplate;
import org.apache.jackrabbit.core.security.authorization.principalbased.EntriesCache;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger(ACLProvider.class);
    private static final AccessControlPolicy effectivePolicy = EffectivePrincipalBasedPolicy.access$000();
    private NodeImpl acRoot;
    private ACLEditor editor;
    private EntriesCache entriesCache;
    private int readBits;

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        if (root.hasNode(N_ACCESSCONTROL)) {
            this.acRoot = root.getNode(N_ACCESSCONTROL);
            if (!this.acRoot.isNodeType(NT_REP_ACCESS_CONTROL)) {
                throw new RepositoryException("Error while initializing Access Control Provider: Found ac-root to be wrong node type " + this.acRoot.getPrimaryNodeType().getName());
            }
        } else {
            this.acRoot = root.addNode(N_ACCESSCONTROL, NT_REP_ACCESS_CONTROL, null);
        }
        this.editor = new ACLEditor(this.session, this.resolver.getQPath(this.acRoot.getPath()));
        this.entriesCache = new EntriesCache(this.session, this.editor, this.acRoot.getPath());
        this.readBits = PrivilegeRegistry.getBits(new Privilege[]{this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
        if (!configuration.containsKey("omit-default-permission")) {
            try {
                log.debug("Install initial permissions: ...");
                ValueFactory vf = this.session.getValueFactory();
                HashMap<String, Value> restrictions = new HashMap<String, Value>();
                restrictions.put(this.session.getJCRName(ACLTemplate.P_NODE_PATH), vf.createValue(root.getPath(), 8));
                restrictions.put(this.session.getJCRName(ACLTemplate.P_GLOB), vf.createValue("*"));
                PrincipalManager pMgr = this.session.getPrincipalManager();
                AccessControlManager acMgr = this.session.getAccessControlManager();
                String pName = "administrators";
                if (pMgr.hasPrincipal(pName)) {
                    Principal administrators = pMgr.getPrincipal(pName);
                    ACLProvider.installDefaultPermissions(administrators, new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")}, restrictions, this.editor);
                } else {
                    log.info("Administrators principal group is missing -> Not adding default permissions.");
                }
                ACLProvider.installDefaultPermissions(pMgr.getEveryone(), new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")}, restrictions, this.editor);
                this.session.save();
            }
            catch (RepositoryException e) {
                log.error("Failed to set-up minimal access control for root node of workspace " + this.session.getWorkspace().getName());
                this.session.getRootNode().refresh(false);
            }
        }
    }

    private static void installDefaultPermissions(Principal principal, Privilege[] privs, Map<String, Value> restrictions, AccessControlEditor editor) throws RepositoryException, AccessControlException {
        JackrabbitAccessControlPolicy[] acls = editor.editAccessControlPolicies(principal);
        if (acls.length > 0) {
            ACLTemplate acl = (ACLTemplate)acls[0];
            if (acl.isEmpty()) {
                acl.addEntry(principal, privs, true, restrictions);
                editor.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
            } else {
                log.debug("... policy for principal '" + principal.getName() + "' already present.");
            }
        } else {
            log.debug("... policy for principal  '" + principal.getName() + "'  already present.");
        }
    }

    @Override
    public void close() {
        super.close();
        this.entriesCache.close();
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        return new AccessControlPolicy[]{effectivePolicy};
    }

    @Override
    public AccessControlEditor getEditor(Session editingSession) {
        this.checkInitialized();
        if (editingSession instanceof SessionImpl) {
            try {
                return new ACLEditor((SessionImpl)editingSession, this.session.getQPath(this.acRoot.getPath()));
            }
            catch (RepositoryException e) {
                log.error("Internal error: ", (Object)e.getMessage());
            }
        }
        log.debug("Unable to build access control editor " + ACLEditor.class.getName() + ".");
        return null;
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionImpl(principals);
    }

    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        CompiledPermissionImpl cp = new CompiledPermissionImpl(principals, false);
        return cp.canRead(((NodeImpl)this.session.getRootNode()).getPrimaryPath());
    }

    private static final class EffectivePrincipalBasedPolicy
    implements AccessControlPolicy {
        private static EffectivePrincipalBasedPolicy INSTANCE = new EffectivePrincipalBasedPolicy();

        private EffectivePrincipalBasedPolicy() {
        }

        private static EffectivePrincipalBasedPolicy getInstance() {
            return INSTANCE;
        }

        static /* synthetic */ EffectivePrincipalBasedPolicy access$000() {
            return EffectivePrincipalBasedPolicy.getInstance();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompiledPermissionImpl
    extends AbstractCompiledPermissions
    implements AccessControlListener {
        private final Set<Principal> principals;
        private final Set<String> acPaths;
        private List<AccessControlEntry> entries;
        private boolean canReadAll;
        private final Map<ItemId, Boolean> readCache = new LRUMap(2000);
        private final Object monitor = new Object();

        private CompiledPermissionImpl(Set<Principal> principals) throws RepositoryException {
            this(principals, true);
        }

        private CompiledPermissionImpl(Set<Principal> principals, boolean listenToEvents) throws RepositoryException {
            this.principals = principals;
            this.acPaths = new HashSet<String>(principals.size());
            this.reload();
            if (listenToEvents) {
                ACLProvider.this.entriesCache.addListener(this);
            }
        }

        private void reload() throws RepositoryException {
            this.acPaths.clear();
            for (Principal p : this.principals) {
                this.acPaths.add(ACLProvider.this.editor.getPathToAcNode(p));
            }
            this.entries = ACLProvider.this.entriesCache.getEntries(this.principals);
            this.canReadAll = this.canRead(ACLProvider.this.session.getQPath("/"));
            if (this.canReadAll) {
                for (AccessControlEntry entry : this.entries) {
                    AccessControlEntryImpl ace = (AccessControlEntryImpl)entry;
                    if (ace.isAllow() || (ace.getPrivilegeBits() & ACLProvider.this.readBits) != ACLProvider.this.readBits) continue;
                    this.canReadAll = false;
                    break;
                }
            }
        }

        @Override
        protected synchronized AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            if (!absPath.isAbsolute()) {
                throw new RepositoryException("Absolute path expected.");
            }
            boolean isAcItem = ACLProvider.this.isAcItem(absPath);
            String jcrPath = ACLProvider.this.session.getJCRPath(absPath);
            return this.buildResult(jcrPath, isAcItem);
        }

        private AbstractCompiledPermissions.Result buildResult(String targetPath, boolean isAcItem) throws RepositoryException {
            int allows = 0;
            int denies = 0;
            int allowPrivileges = 0;
            int denyPrivileges = 0;
            int parentAllows = 0;
            int parentDenies = 0;
            String parentPath = Text.getRelativeParent((String)targetPath, (int)1);
            for (AccessControlEntry entry : this.entries) {
                int permissions;
                boolean matches;
                if (!(entry instanceof ACLTemplate.Entry)) {
                    log.warn("Unexpected AccessControlEntry instance -> ignore");
                    continue;
                }
                ACLTemplate.Entry entr = (ACLTemplate.Entry)entry;
                int privs = entr.getPrivilegeBits();
                if (!"".equals(parentPath) && entr.matches(parentPath)) {
                    if (entr.isAllow()) {
                        parentAllows |= Permission.diff(privs, parentDenies);
                    } else {
                        parentDenies |= Permission.diff(privs, parentAllows);
                    }
                }
                if (!(matches = entr.matches(targetPath))) continue;
                if (entr.isAllow()) {
                    permissions = PrivilegeRegistry.calculatePermissions(allowPrivileges |= Permission.diff(privs, denyPrivileges), parentAllows, true, isAcItem);
                    allows |= Permission.diff(permissions, denies);
                    continue;
                }
                permissions = PrivilegeRegistry.calculatePermissions(denyPrivileges |= Permission.diff(privs, allowPrivileges), parentDenies, false, isAcItem);
                denies |= Permission.diff(permissions, allows);
            }
            return new AbstractCompiledPermissions.Result(allows, denies, allowPrivileges, denyPrivileges);
        }

        @Override
        public void close() {
            ACLProvider.this.entriesCache.removeListener(this);
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
            boolean canRead;
            if (path == null) {
                Object object = this.monitor;
                synchronized (object) {
                    if (!this.readCache.containsKey(itemId)) {
                        boolean canRead2 = this.canRead(ACLProvider.this.session.getHierarchyManager().getPath(itemId));
                        this.readCache.put(itemId, canRead2);
                        return canRead2;
                    }
                    canRead = this.readCache.get(itemId);
                }
            } else {
                canRead = this.canRead(path);
            }
            return canRead;
        }

        private boolean canRead(Path path) throws RepositoryException {
            return this.canReadAll && !ACLProvider.this.isAcItem(path) || this.grants(path, 1);
        }

        @Override
        public void acModified(AccessControlModifications modifications) {
            try {
                boolean reload = false;
                Iterator keys = modifications.getNodeIdentifiers().iterator();
                while (keys.hasNext() && !reload) {
                    String path = keys.next().toString();
                    reload = this.acPaths.contains(path);
                }
                if (reload) {
                    this.clearCache();
                    this.reload();
                }
            }
            catch (RepositoryException e) {
                log.warn("Internal error: ", (Object)e.getMessage());
            }
        }
    }
}

