/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.core.LowPriorityTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JackrabbitThreadPool
extends ScheduledThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitThreadPool.class);
    private static final int size = Runtime.getRuntime().availableProcessors() * 2;
    private static final ClassLoader loader = JackrabbitThreadPool.class.getClassLoader();
    private static final AtomicInteger counter = new AtomicInteger(1);
    private static final ThreadFactory factory = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            int count = counter.getAndIncrement();
            String name = "jackrabbit-pool-" + count;
            Thread thread = new Thread(runnable, name);
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            thread.setContextClassLoader(loader);
            return thread;
        }
    };
    private static final RejectedExecutionHandler handler = new ThreadPoolExecutor.CallerRunsPolicy();
    public static final String MAX_LOAD_FOR_LOW_PRIORITY_TASKS_PROPERTY = "org.apache.jackrabbit.core.JackrabbitThreadPool.maxLoadForLowPriorityTasks";
    private static final Integer maxLoadForLowPriorityTasks = JackrabbitThreadPool.getMaxLoadForLowPriorityTasks();
    private final BlockingQueue<Runnable> lowPriorityTasksQueue = new LinkedBlockingQueue<Runnable>();
    private final RetryLowPriorityTask retryTask = new RetryLowPriorityTask(this, this.lowPriorityTasksQueue);

    private static int getMaxLoadForLowPriorityTasks() {
        int defaultMaxLoad = 75;
        int max = Integer.getInteger(MAX_LOAD_FOR_LOW_PRIORITY_TASKS_PROPERTY, 75);
        if (max < 0 || max > 100) {
            return 75;
        }
        return max;
    }

    public JackrabbitThreadPool() {
        super(size, factory, handler);
    }

    public void execute(Runnable command) {
        if (command instanceof LowPriorityTask) {
            this.scheduleLowPriority(command);
            return;
        }
        super.execute(command);
    }

    private void scheduleLowPriority(Runnable command) {
        if (this.isOverDefinedMaxLoad()) {
            this.lowPriorityTasksQueue.add(command);
            this.retryTask.retryLater();
            return;
        }
        super.execute(command);
    }

    private boolean isOverDefinedMaxLoad() {
        if (maxLoadForLowPriorityTasks == 0) {
            return false;
        }
        double currentLoad = (double)this.getActiveCount() / (double)this.getPoolSize() * 100.0;
        return currentLoad > (double)maxLoadForLowPriorityTasks.intValue();
    }

    int getPendingLowPriorityTaskCount() {
        return this.lowPriorityTasksQueue.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RetryLowPriorityTask
    implements Runnable {
        private static final int LATER_MS = 50;
        private final JackrabbitThreadPool executor;
        private final BlockingQueue<Runnable> lowPriorityTasksQueue;
        private final AtomicBoolean retryPending;

        public RetryLowPriorityTask(JackrabbitThreadPool executor, BlockingQueue<Runnable> lowPriorityTasksQueue) {
            this.executor = executor;
            this.lowPriorityTasksQueue = lowPriorityTasksQueue;
            this.retryPending = new AtomicBoolean(false);
        }

        public void retryLater() {
            if (!this.retryPending.getAndSet(true)) {
                this.executor.schedule(this, 50L, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void run() {
            int count = 0;
            while (!this.executor.isOverDefinedMaxLoad()) {
                Runnable r = (Runnable)this.lowPriorityTasksQueue.poll();
                if (r == null) {
                    log.debug("Executed {} low priority tasks.", (Object)count);
                    break;
                }
                ++count;
                this.executor.execute(r);
            }
            this.retryPending.set(false);
            if (!this.lowPriorityTasksQueue.isEmpty()) {
                log.debug("Executor is under load, will schedule {} remaining tasks for {} ms later", (Object)this.lowPriorityTasksQueue.size(), (Object)50);
                this.retryLater();
            }
        }
    }
}

