/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeStateMerger {
    NodeStateMerger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean merge(NodeState state, MergeContext context) {
        NodeState overlayedState = (NodeState)state.getOverlayedState();
        if (overlayedState == null || state.getModCount() == overlayedState.getModCount()) {
            return false;
        }
        NodeState nodeState = overlayedState;
        synchronized (nodeState) {
            NodeState nodeState2 = state;
            synchronized (nodeState2) {
                AbstractCollection removed;
                AbstractCollection added;
                if (!state.getReorderedChildNodeEntries().isEmpty()) {
                    return false;
                }
                if (!state.getNodeTypeName().equals(overlayedState.getNodeTypeName())) {
                    return false;
                }
                if (!NodeStateMerger.mergeMixinTypes(state, overlayedState, context)) {
                    return false;
                }
                if (state.getParentId() != null && !state.getParentId().equals(overlayedState.getParentId())) {
                    return false;
                }
                if (!state.getChildNodeEntries().equals(overlayedState.getChildNodeEntries())) {
                    added = new ArrayList();
                    removed = new ArrayList();
                    for (ChildNodeEntry cne : state.getAddedChildNodeEntries()) {
                        if (!context.isAdded(cne.getId()) && (!context.isModified(cne.getId()) || !NodeStateMerger.isParent(state, cne, context))) continue;
                        if (overlayedState.hasChildNodeEntry(cne.getName()) && cne.getIndex() < 2 && !context.allowsSameNameSiblings(cne.getId())) {
                            return false;
                        }
                        ((ArrayList)added).add(cne);
                    }
                    for (ChildNodeEntry cne : state.getRemovedChildNodeEntries()) {
                        if (!context.isDeleted(cne.getId()) && !context.isModified(cne.getId())) continue;
                        ((ArrayList)removed).add(cne);
                    }
                    state.setChildNodeEntries(overlayedState.getChildNodeEntries());
                    for (ChildNodeEntry cne : removed) {
                        state.removeChildNodeEntry(cne.getId());
                    }
                    for (ChildNodeEntry cne : added) {
                        state.addChildNodeEntry(cne.getName(), cne.getId());
                    }
                }
                if (!state.getPropertyNames().equals(overlayedState.getPropertyNames())) {
                    PropertyId propId;
                    added = new HashSet();
                    removed = new HashSet();
                    for (Name name : state.getAddedPropertyNames()) {
                        propId = new PropertyId(state.getNodeId(), name);
                        if (!context.isAdded(propId)) continue;
                        ((HashSet)added).add(name);
                    }
                    for (Name name : state.getRemovedPropertyNames()) {
                        propId = new PropertyId(state.getNodeId(), name);
                        if (!context.isDeleted(propId)) continue;
                        ((HashSet)removed).add(name);
                    }
                    state.setPropertyNames(overlayedState.getPropertyNames());
                    for (Name name : added) {
                        state.addPropertyName(name);
                    }
                    for (Name name : removed) {
                        state.removePropertyName(name);
                    }
                }
                state.setModCount(overlayedState.getModCount());
                return true;
            }
        }
    }

    private static boolean mergeMixinTypes(NodeState state, NodeState overlayedState, MergeContext ctx) {
        boolean mergeDone;
        HashSet<Name> overlayedMixins;
        HashSet<Name> mixins = new HashSet<Name>(state.getMixinTypeNames());
        if (mixins.equals(overlayedMixins = new HashSet<Name>(overlayedState.getMixinTypeNames()))) {
            return true;
        }
        PropertyId mixinPropId = new PropertyId(state.getNodeId(), NameConstants.JCR_MIXINTYPES);
        if (ctx.isAdded(mixinPropId)) {
            if (overlayedMixins.isEmpty() || mixins.containsAll(overlayedMixins)) {
                mixins.removeAll(overlayedMixins);
                mergeDone = !NodeStateMerger.conflicts(state, mixins, ctx, true);
            } else {
                mergeDone = false;
            }
        } else if (ctx.isDeleted(mixinPropId)) {
            mergeDone = false;
        } else if (ctx.isModified(mixinPropId)) {
            if (mixins.containsAll(overlayedMixins)) {
                mixins.removeAll(overlayedMixins);
                mergeDone = !NodeStateMerger.conflicts(state, mixins, ctx, true);
            } else {
                mergeDone = false;
            }
        } else if (overlayedMixins.containsAll(mixins)) {
            overlayedMixins.removeAll(mixins);
            if (!NodeStateMerger.conflicts(state, overlayedMixins, ctx, false)) {
                state.setMixinTypeNames(overlayedMixins);
                mergeDone = true;
            } else {
                mergeDone = false;
            }
        } else {
            mergeDone = false;
        }
        return mergeDone;
    }

    private static boolean conflicts(NodeState state, Set<Name> addedMixins, MergeContext ctx, boolean compareToOverlayed) {
        try {
            for (Name mixinName : addedMixins) {
                EffectiveNodeType ent = ctx.getEffectiveNodeType(mixinName);
                if (ent.getUnnamedItemDefs().length > 0) {
                    return false;
                }
                NodeState overlayed = (NodeState)state.getOverlayedState();
                for (ChildNodeEntry cne : state.getChildNodeEntries()) {
                    if (ent.getNamedNodeDefs(cne.getName()).length <= 0 || !ctx.isAdded(cne.getId()) && !NodeStateMerger.isAutoCreated(cne, ent) || compareToOverlayed && !overlayed.hasChildNodeEntry(cne.getName())) continue;
                    return true;
                }
                for (Name propName : state.getPropertyNames()) {
                    PropertyId pid;
                    if (ent.getNamedPropDefs(propName).length <= 0 || !ctx.isAdded(pid = new PropertyId(state.getNodeId(), propName)) && !NodeStateMerger.isAutoCreated(propName, ent) || compareToOverlayed && !overlayed.hasPropertyName(propName)) continue;
                    return true;
                }
            }
        }
        catch (NoSuchNodeTypeException e) {
            return true;
        }
        return false;
    }

    private static boolean isParent(NodeState state, ChildNodeEntry entry, MergeContext context) {
        try {
            return state.getId().equals(context.getNodeState(entry.getId()).getParentId());
        }
        catch (ItemStateException e) {
            return false;
        }
    }

    private static boolean isAutoCreated(ChildNodeEntry cne, EffectiveNodeType ent) {
        for (QNodeDefinition def : ent.getAutoCreateNodeDefs()) {
            if (!def.getName().equals(cne.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAutoCreated(Name propertyName, EffectiveNodeType ent) {
        for (QPropertyDefinition def : ent.getAutoCreatePropDefs()) {
            if (!def.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    static interface MergeContext {
        public boolean isAdded(ItemId var1);

        public boolean isDeleted(ItemId var1);

        public boolean isModified(ItemId var1);

        public boolean allowsSameNameSiblings(NodeId var1);

        public NodeState getNodeState(NodeId var1) throws ItemStateException;

        public EffectiveNodeType getEffectiveNodeType(Name var1) throws NoSuchNodeTypeException;
    }
}

