/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import javax.sql.DataSource;
import org.apache.jackrabbit.core.journal.DatabaseJournal;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.OracleConnectionHelper;

public class OracleDatabaseJournal
extends DatabaseJournal {
    public static final String TABLE_SPACE_VARIABLE = "${tableSpace}";
    protected String tableSpace = "";

    public OracleDatabaseJournal() {
        this.setDatabaseType("oracle");
        this.setDriver("oracle.jdbc.OracleDriver");
        this.setSchemaObjectPrefix("");
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        OracleConnectionHelper helper = new OracleConnectionHelper(dataSrc, false);
        helper.init();
        return helper;
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        return super.createCheckSchemaOperation().addVariableReplacement(TABLE_SPACE_VARIABLE, this.tableSpace);
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace != null && tableSpace.trim().length() > 0 ? "tablespace " + tableSpace.trim() : "";
    }
}

