/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.pool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DbNameIndex;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDbPersistenceManager
extends AbstractBundlePersistenceManager
implements DatabaseAware {
    private static Logger log = LoggerFactory.getLogger(BundleDbPersistenceManager.class);
    public static final int SM_BINARY_KEYS = 1;
    public static final int SM_LONGLONG_KEYS = 2;
    protected boolean initialized;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected String databaseType;
    protected String dataSourceName;
    protected ConnectionHelper conHelper;
    protected String schemaObjectPrefix;
    protected boolean consistencyCheck;
    protected boolean consistencyFix;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    protected boolean externalBLOBs;
    protected boolean blockOnConnectionLoss;
    protected String bundleInsertSQL;
    protected String bundleUpdateSQL;
    protected String bundleSelectSQL;
    protected String bundleDeleteSQL;
    protected String bundleSelectAllIdsFromSQL;
    protected String bundleSelectAllIdsSQL;
    protected String nodeReferenceInsertSQL;
    protected String nodeReferenceUpdateSQL;
    protected String nodeReferenceSelectSQL;
    protected String nodeReferenceDeleteSQL;
    protected CloseableBLOBStore blobStore;
    private StringIndex nameIndex;
    private int minBlobSize = 4096;
    protected ErrorHandling errorHandling = new ErrorHandling();
    protected BundleBinding binding;
    private String name = super.toString();
    private boolean schemaCheckEnabled = true;
    private ConnectionFactory connectionFactory;

    @Override
    public void setConnectionFactory(ConnectionFactory connnectionFactory) {
        this.connectionFactory = connnectionFactory;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public String getSchema() {
        return this.databaseType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setSchema(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean isExternalBLOBs() {
        return this.externalBLOBs;
    }

    public void setExternalBLOBs(boolean externalBLOBs) {
        this.externalBLOBs = externalBLOBs;
    }

    public String getConsistencyCheck() {
        return Boolean.toString(this.consistencyCheck);
    }

    public void setConsistencyCheck(String consistencyCheck) {
        this.consistencyCheck = Boolean.valueOf(consistencyCheck);
    }

    public String getConsistencyFix() {
        return Boolean.toString(this.consistencyFix);
    }

    public void setConsistencyFix(String consistencyFix) {
        this.consistencyFix = Boolean.valueOf(consistencyFix);
    }

    public String getMinBlobSize() {
        return String.valueOf(this.minBlobSize);
    }

    public void setMinBlobSize(String minBlobSize) {
        this.minBlobSize = Integer.decode(minBlobSize);
    }

    public void setErrorHandling(String errorHandling) {
        this.errorHandling = new ErrorHandling(errorHandling);
    }

    public String getErrorHandling() {
        return this.errorHandling.toString();
    }

    public void setBlockOnConnectionLoss(String block) {
        this.blockOnConnectionLoss = Boolean.valueOf(block);
    }

    public String getBlockOnConnectionLoss() {
        return Boolean.toString(this.blockOnConnectionLoss);
    }

    public boolean useDbBlobStore() {
        return !this.externalBLOBs;
    }

    public boolean useLocalFsBlobStore() {
        return this.externalBLOBs;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.schemaCheckEnabled;
    }

    public final void setSchemaCheckEnabled(boolean enabled) {
        this.schemaCheckEnabled = enabled;
    }

    @Override
    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        int failures = 0;
        ItemStateException lastException = null;
        boolean sleepInterrupted = false;
        while (!sleepInterrupted && (this.blockOnConnectionLoss || failures <= 1)) {
            try {
                this.conHelper.startBatch();
                super.store(changeLog);
                this.conHelper.endBatch(true);
                return;
            }
            catch (SQLException e) {
                lastException = new ItemStateException(e.getMessage(), e);
            }
            catch (ItemStateException e) {
                lastException = e;
                try {
                    this.conHelper.endBatch(false);
                }
                catch (SQLException e2) {
                    DbUtility.logException("rollback failed", e2);
                }
            }
            log.error("Failed to persist ChangeLog (stacktrace on DEBUG log level), blockOnConnectionLoss = " + this.blockOnConnectionLoss, (Throwable)lastException);
            log.debug("Failed to persist ChangeLog", (Throwable)lastException);
            if (!this.blockOnConnectionLoss && ++failures > 1) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                sleepInterrupted = true;
                log.error("Interrupted: canceling retry of ChangeLog storage");
            }
        }
        throw lastException;
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        super.init(context);
        this.conHelper = this.createConnectionHelper(this.getDataSource());
        this.name = context.getHomeDir().getName();
        this.schemaObjectPrefix = this.conHelper.prepareDbIdentifier(this.schemaObjectPrefix);
        if (this.isSchemaCheckEnabled()) {
            this.createCheckSchemaOperation().run();
        }
        this.blobStore = this.createBlobStore();
        this.buildSQLStatements();
        this.binding = new BundleBinding(this.errorHandling, this.blobStore, this.getNsIndex(), this.getNameIndex(), context.getDataStore());
        this.binding.setMinBlobSize(this.minBlobSize);
        this.initialized = true;
        if (this.consistencyCheck) {
            this.checkConsistency(null, true, this.consistencyFix);
        }
    }

    private DataSource getDataSource() throws Exception {
        if (this.getDataSourceName() == null || "".equals(this.getDataSourceName())) {
            return this.connectionFactory.getDataSource(this.getDriver(), this.getUrl(), this.getUser(), this.getPassword());
        }
        String dbType = this.connectionFactory.getDataBaseType(this.dataSourceName);
        if (BundleDbPersistenceManager.class.getResourceAsStream(dbType + ".ddl") != null) {
            this.setDatabaseType(dbType);
        }
        return this.connectionFactory.getDataSource(this.dataSourceName);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new ConnectionHelper(dataSrc, this.blockOnConnectionLoss);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream in = AbstractBundlePersistenceManager.class.getResourceAsStream(this.databaseType + ".ddl");
        return new CheckSchemaOperation(this.conHelper, in, this.schemaObjectPrefix + "BUNDLE").addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    @Override
    protected BLOBStore getBlobStore() {
        return this.blobStore;
    }

    protected CloseableBLOBStore createBlobStore() throws Exception {
        if (this.useLocalFsBlobStore()) {
            return this.createLocalFSBlobStore(this.context);
        }
        return this.createDBBlobStore(this.context);
    }

    @Override
    public StringIndex getNameIndex() {
        try {
            if (this.nameIndex == null) {
                FileSystemResource res = new FileSystemResource(this.context.getFileSystem(), "/names.properties");
                this.nameIndex = res.exists() ? super.getNameIndex() : this.createDbNameIndex();
            }
            return this.nameIndex;
        }
        catch (Exception e) {
            IllegalStateException exception = new IllegalStateException("Unable to create nsIndex");
            exception.initCause(e);
            throw exception;
        }
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new DbNameIndex(this.conHelper, this.schemaObjectPrefix);
    }

    public int getStorageModel() {
        return 1;
    }

    protected CloseableBLOBStore createLocalFSBlobStore(PMContext context) throws Exception {
        LocalFileSystem blobFS = new LocalFileSystem();
        blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
        blobFS.init();
        return new FSBlobStore(blobFS);
    }

    protected CloseableBLOBStore createDBBlobStore(PMContext context) throws Exception {
        return new DbBlobStore();
    }

    protected void checkBundleConsistency(NodeId id, NodePropBundle bundle, boolean fix, Collection<NodePropBundle> modifications) {
        if (id.toString().endsWith("babecafebabe") && !id.toString().equals("cafebabe-cafe-babe-cafe-babecafebabe")) {
            return;
        }
        ArrayList<NodePropBundle.ChildNodeEntry> missingChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
            if (entry.getId().toString().endsWith("babecafebabe")) continue;
            try {
                NodePropBundle child = this.loadBundle(entry.getId());
                if (child == null) {
                    log.error("NodeState '" + id + "' references inexistent child" + " '" + entry.getName() + "' with id " + "'" + entry.getId() + "'");
                    missingChildren.add(entry);
                    continue;
                }
                NodeId cp = child.getParentId();
                if (cp == null) {
                    log.error("ChildNode has invalid parent uuid: <null>");
                    continue;
                }
                if (cp.equals(id)) continue;
                log.error("ChildNode has invalid parent uuid: '" + cp + "' (instead of '" + id + "')");
            }
            catch (ItemStateException e) {}
        }
        if (fix && !missingChildren.isEmpty()) {
            for (NodePropBundle.ChildNodeEntry entry : missingChildren) {
                bundle.getChildNodeEntries().remove(entry);
            }
            modifications.add(bundle);
        }
        NodeId parentId = bundle.getParentId();
        try {
            if (parentId != null && !id.toString().endsWith("babecafebabe") && this.loadBundle(parentId) == null) {
                log.error("NodeState '" + id + "' references inexistent parent uuid '" + parentId + "'");
            }
        }
        catch (ItemStateException e) {
            log.error("Error reading node '" + parentId + "' (parent of '" + id + "'): " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
        ArrayList<NodePropBundle> modifications;
        int total;
        int count;
        block31: {
            int i;
            NodeId id;
            block32: {
                count = 0;
                total = 0;
                modifications = new ArrayList<NodePropBundle>();
                if (uuids != null) break block32;
                ResultSet rs = null;
                try {
                    String sql = "select count(*) from " + this.schemaObjectPrefix + "BUNDLE";
                    rs = this.conHelper.exec(sql, new Object[0], false, 0);
                    try {
                        if (!rs.next()) {
                            log.error("Could not retrieve total number of bundles. empty result set.");
                            DbUtility.close(rs);
                            total = count;
                            return;
                        }
                        total = rs.getInt(1);
                    }
                    finally {
                        DbUtility.close(rs);
                    }
                    sql = this.getStorageModel() == 1 ? "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE" : "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE";
                    rs = this.conHelper.exec(sql, new Object[0], false, 0);
                    while (rs.next()) {
                        id = this.getStorageModel() == 1 ? new NodeId(rs.getBytes(1)) : new NodeId(rs.getLong(1), rs.getLong(2));
                        ResultSet bRs = null;
                        try {
                            bRs = this.conHelper.exec(this.bundleSelectSQL, this.getKey(id), false, 0);
                            if (!bRs.next()) {
                                throw new SQLException("bundle cannot be retrieved?");
                            }
                            NodePropBundle bundle = this.readBundle(id, bRs, 1);
                            this.checkBundleConsistency(id, bundle, fix, modifications);
                        }
                        catch (SQLException e) {
                            try {
                                log.error("Unable to parse bundle " + id, (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                DbUtility.close(bRs);
                                throw throwable;
                            }
                            DbUtility.close(bRs);
                        }
                        DbUtility.close(bRs);
                        if (++count % 1000 != 0) continue;
                        log.info(this.name + ": checked " + count + "/" + total + " bundles...");
                    }
                    DbUtility.close(rs);
                }
                catch (Exception e) {
                    log.error("Error loading bundle", (Throwable)e);
                    break block31;
                }
                finally {
                    DbUtility.close(rs);
                    total = count;
                }
                total = count;
                break block31;
            }
            ArrayList<NodeId> idList = new ArrayList<NodeId>(uuids.length);
            for (i = 0; i < uuids.length; ++i) {
                try {
                    idList.add(new NodeId(uuids[i]));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.error("Invalid uuid for consistency check, skipping: '" + uuids[i] + "': " + e);
                }
            }
            for (i = 0; i < idList.size(); ++i) {
                id = (NodeId)idList.get(i);
                try {
                    NodePropBundle bundle = this.loadBundle(id);
                    if (bundle == null) {
                        log.error("No bundle found for uuid '" + id + "'");
                        continue;
                    }
                    this.checkBundleConsistency(id, bundle, fix, modifications);
                    if (recursive) {
                        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                            idList.add(entry.getId());
                        }
                    }
                    if (++count % 1000 != 0) continue;
                    log.info(this.name + ": checked " + count + "/" + idList.size() + " bundles...");
                    continue;
                }
                catch (ItemStateException e) {
                    // empty catch block
                }
            }
            total = idList.size();
        }
        if (fix && !modifications.isEmpty()) {
            log.info(this.name + ": Fixing " + modifications.size() + " inconsistent bundle(s)...");
            for (NodePropBundle bundle : modifications) {
                try {
                    log.info(this.name + ": Fixing bundle '" + bundle.getId() + "'");
                    bundle.markOld();
                    this.storeBundle(bundle);
                    this.evictBundle(bundle.getId());
                }
                catch (ItemStateException e) {
                    log.error(this.name + ": Error storing fixed bundle: " + e);
                }
            }
        }
        log.info(this.name + ": checked " + count + "/" + total + " bundles.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (this.nameIndex instanceof DbNameIndex) {
                ((DbNameIndex)this.nameIndex).close();
            }
            this.blobStore.close();
            this.blobStore = null;
            super.close();
        }
        finally {
            this.initialized = false;
        }
    }

    protected Object[] getKey(NodeId id) {
        if (this.getStorageModel() == 1) {
            return new Object[]{id.getRawBytes()};
        }
        return new Object[]{id.getMostSignificantBits(), id.getLeastSignificantBits()};
    }

    protected Object[] createParams(NodeId id, Object p, boolean before) {
        ArrayList<Object> key = new ArrayList<Object>();
        if (this.getStorageModel() == 1) {
            key.add(id.getRawBytes());
        } else {
            key.add(id.getMostSignificantBits());
            key.add(id.getLeastSignificantBits());
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (before) {
            params.add(p);
            params.addAll(key);
        } else {
            params.addAll(key);
            params.add(p);
        }
        return params.toArray();
    }

    @Override
    public synchronized Iterable<NodeId> getAllNodeIds(NodeId bigger, int maxCount) throws ItemStateException, RepositoryException {
        ArrayList<NodeId> arrayList;
        ResultSet rs = null;
        try {
            String sql = this.bundleSelectAllIdsSQL;
            NodeId lowId = null;
            Object[] keys = new Object[]{};
            if (bigger != null) {
                sql = this.bundleSelectAllIdsFromSQL;
                lowId = bigger;
                keys = this.getKey(bigger);
            }
            if (maxCount > 0) {
                maxCount += 10;
            }
            rs = this.conHelper.exec(sql, keys, false, maxCount);
            ArrayList<NodeId> result = new ArrayList<NodeId>();
            while ((maxCount == 0 || result.size() < maxCount) && rs.next()) {
                NodeId current;
                if (this.getStorageModel() == 1) {
                    current = new NodeId(rs.getBytes(1));
                } else {
                    long high = rs.getLong(1);
                    long low = rs.getLong(2);
                    current = new NodeId(high, low);
                }
                if (lowId != null && current.compareTo(lowId) <= 0) continue;
                result.add(current);
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                String msg = "getAllNodeIds failed.";
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close(rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        try {
            ResultSet rs = this.conHelper.exec(this.bundleSelectSQL, this.getKey(id), false, 0);
            try {
                if (rs.next()) {
                    NodePropBundle nodePropBundle = this.readBundle(id, rs, 1);
                    return nodePropBundle;
                }
                NodePropBundle nodePropBundle = null;
                return nodePropBundle;
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            String msg = "failed to read bundle: " + id + ": " + e;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodePropBundle readBundle(NodeId id, ResultSet rs, int column) throws SQLException {
        NodePropBundle nodePropBundle;
        InputStream in = rs.getMetaData().getColumnType(column) == 2004 ? rs.getBlob(column).getBinaryStream() : rs.getBinaryStream(column);
        try {
            nodePropBundle = this.binding.readBundle(in, id);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                SQLException exception = new SQLException("Failed to parse bundle " + id);
                exception.initCause(e);
                throw exception;
            }
        }
        in.close();
        return nodePropBundle;
    }

    @Override
    protected synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            this.binding.writeBundle(out, bundle);
            String sql = bundle.isNew() ? this.bundleInsertSQL : this.bundleUpdateSQL;
            Object[] params = this.createParams(bundle.getId(), out.toByteArray(), true);
            this.conHelper.update(sql, params);
        }
        catch (Exception e) {
            String msg = "failed to write bundle: " + bundle.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    protected synchronized void destroyBundle(NodePropBundle bundle) throws ItemStateException {
        try {
            this.conHelper.update(this.bundleDeleteSQL, this.getKey(bundle.getId()));
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)e;
            }
            String msg = "failed to delete bundle: " + bundle.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    public synchronized NodeReferences loadReferencesTo(NodeId targetId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences nodeReferences;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ResultSet rs = null;
        InputStream in = null;
        try {
            rs = this.conHelper.exec(this.nodeReferenceSelectSQL, this.getKey(targetId), false, 0);
            if (!rs.next()) {
                throw new NoSuchItemStateException(targetId.toString());
            }
            in = rs.getBinaryStream(1);
            NodeReferences refs = new NodeReferences(targetId);
            Serializer.deserialize(refs, in);
            nodeReferences = refs;
        }
        catch (Exception e) {
            try {
                if (e instanceof NoSuchItemStateException) {
                    throw (NoSuchItemStateException)e;
                }
                String msg = "failed to read references: " + targetId;
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                DbUtility.close(rs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        DbUtility.close(rs);
        return nodeReferences;
    }

    @Override
    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = this.existsReferencesTo(refs.getTargetId());
        String sql = update ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            Object[] params = this.createParams(refs.getTargetId(), out.toByteArray(), true);
            this.conHelper.exec(sql, params);
        }
        catch (Exception e) {
            String msg = "failed to write " + refs;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.conHelper.exec(this.nodeReferenceDeleteSQL, this.getKey(refs.getTargetId()));
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)e;
            }
            String msg = "failed to delete " + refs;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, e);
        }
    }

    @Override
    public synchronized boolean existsReferencesTo(NodeId targetId) throws ItemStateException {
        boolean bl;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ResultSet rs = null;
        try {
            rs = this.conHelper.exec(this.nodeReferenceSelectSQL, this.getKey(targetId), false, 0);
            bl = rs.next();
        }
        catch (Exception e) {
            try {
                String msg = "failed to check existence of node references: " + targetId;
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
        }
        DbUtility.close(rs);
        return bl;
    }

    public String toString() {
        return this.name;
    }

    protected void buildSQLStatements() {
        if (this.getStorageModel() == 1) {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID) values (?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID) values (?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE WHERE NODE_ID > ? ORDER BY NODE_ID";
        } else {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID_HI, NODE_ID_LO) values (?, ?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS" + " (REFS_DATA, NODE_ID_HI, NODE_ID_LO) values (?, ?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS" + " set REFS_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE" + " WHERE (NODE_ID_HI >= ?) AND (? IS NOT NULL)" + " ORDER BY NODE_ID_HI, NODE_ID_LO";
        }
    }

    protected class DbBlobStore
    implements CloseableBLOBStore {
        protected String blobInsertSQL;
        protected String blobUpdateSQL;
        protected String blobSelectSQL;
        protected String blobSelectExistSQL;
        protected String blobDeleteSQL;

        public DbBlobStore() throws SQLException {
            this.blobInsertSQL = "insert into " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL (BINVAL_DATA, BINVAL_ID) values (?, ?)";
            this.blobUpdateSQL = "update " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL set BINVAL_DATA = ? where BINVAL_ID = ?";
            this.blobSelectSQL = "select BINVAL_DATA from " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobSelectExistSQL = "select 1 from " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobDeleteSQL = "delete from " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
        }

        public String createId(PropertyId id, int index) {
            StringBuffer buf = new StringBuffer();
            buf.append(id.getParentId().toString());
            buf.append('.');
            buf.append(BundleDbPersistenceManager.this.getNsIndex().stringToIndex(id.getName().getNamespaceURI()));
            buf.append('.');
            buf.append(BundleDbPersistenceManager.this.getNameIndex().stringToIndex(id.getName().getLocalName()));
            buf.append('.');
            buf.append(index);
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream get(String blobId) throws Exception {
            FilterInputStream filterInputStream;
            block7: {
                InputStream in;
                boolean close;
                ResultSet rs;
                block5: {
                    ByteArrayInputStream byteArrayInputStream;
                    block6: {
                        rs = null;
                        close = true;
                        try {
                            rs = BundleDbPersistenceManager.this.conHelper.exec(this.blobSelectSQL, new Object[]{blobId}, false, 0);
                            if (!rs.next()) {
                                throw new Exception("no such BLOB: " + blobId);
                            }
                            in = rs.getBinaryStream(1);
                            if (in != null) break block5;
                            byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                            if (!close) break block6;
                        }
                        catch (Throwable throwable) {
                            if (close) {
                                DbUtility.close(rs);
                            }
                            throw throwable;
                        }
                        DbUtility.close(rs);
                    }
                    return byteArrayInputStream;
                }
                close = false;
                final ResultSet rs2 = rs;
                filterInputStream = new FilterInputStream(in){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws IOException {
                        try {
                            this.in.close();
                        }
                        finally {
                            DbUtility.close(rs2);
                        }
                    }
                };
                if (!close) break block7;
                DbUtility.close(rs);
            }
            return filterInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            boolean exists;
            ResultSet rs = null;
            try {
                rs = BundleDbPersistenceManager.this.conHelper.exec(this.blobSelectExistSQL, new Object[]{blobId}, false, 0);
                exists = rs.next();
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                throw throwable;
            }
            DbUtility.close(rs);
            String sql = exists ? this.blobUpdateSQL : this.blobInsertSQL;
            Object[] params = new Object[]{new StreamWrapper(in, size), blobId};
            BundleDbPersistenceManager.this.conHelper.exec(sql, params);
        }

        public synchronized boolean remove(String blobId) throws Exception {
            return BundleDbPersistenceManager.this.conHelper.update(this.blobDeleteSQL, new Object[]{blobId}) == 1;
        }

        public void close() {
        }
    }

    protected class FSBlobStore
    extends FileSystemBLOBStore
    implements CloseableBLOBStore {
        private FileSystem fs;

        public FSBlobStore(FileSystem fs) {
            super(fs);
            this.fs = fs;
        }

        public String createId(PropertyId id, int index) {
            return BundleDbPersistenceManager.this.buildBlobFilePath(null, id, index).toString();
        }

        public void close() {
            try {
                this.fs.close();
                this.fs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static interface CloseableBLOBStore
    extends BLOBStore {
        public void close();
    }
}

