/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.query.lucene.join.JoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.OperandEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildNodeJoinMerger
extends JoinMerger {
    private final String childSelector;
    private final String parentSelector;

    public ChildNodeJoinMerger(Join join, Map<String, PropertyValue> columns, OperandEvaluator evaluator, QueryObjectModelFactory factory, ChildNodeJoinCondition condition) throws RepositoryException {
        super(join, columns, evaluator, factory);
        this.childSelector = condition.getChildSelectorName();
        this.parentSelector = condition.getParentSelectorName();
    }

    @Override
    public Set<String> getLeftValues(Row row) throws RepositoryException {
        return this.getValues(this.leftSelectors, row);
    }

    @Override
    public Set<String> getRightValues(Row row) throws RepositoryException {
        return this.getValues(this.rightSelectors, row);
    }

    @Override
    public List<Constraint> getRightJoinConstraints(List<Row> leftRows) throws RepositoryException {
        HashSet<String> paths = new HashSet<String>();
        for (Row row : leftRows) {
            paths.addAll(this.getLeftValues(row));
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (String path : paths) {
            if (this.rightSelectors.contains(this.childSelector)) {
                constraints.add((Constraint)this.factory.childNode(this.childSelector, path));
                continue;
            }
            constraints.add((Constraint)this.factory.sameNode(this.parentSelector, path));
        }
        return constraints;
    }

    private Set<String> getValues(Set<String> selectors, Row row) throws RepositoryException {
        if (selectors.contains(this.childSelector)) {
            Node node = row.getNode(this.childSelector);
            if (node != null && node.getDepth() > 0) {
                return Collections.singleton(node.getParent().getPath());
            }
        } else if (selectors.contains(this.parentSelector)) {
            Node node = row.getNode(this.parentSelector);
            if (node != null) {
                return Collections.singleton(node.getPath());
            }
        } else {
            throw new RepositoryException("Invalid child node join");
        }
        return Collections.emptySet();
    }
}

