/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

class JackrabbitThreadPool
extends ScheduledThreadPoolExecutor {
    private static final int size = Runtime.getRuntime().availableProcessors() * 2;
    private static final ClassLoader loader = JackrabbitThreadPool.class.getClassLoader();
    private static final AtomicInteger counter = new AtomicInteger(1);
    private static final ThreadFactory factory = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            int count = counter.getAndIncrement();
            String name = "jackrabbit-pool-" + count;
            Thread thread = new Thread(runnable, name);
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            thread.setContextClassLoader(loader);
            return thread;
        }
    };
    private static final RejectedExecutionHandler handler = new ThreadPoolExecutor.CallerRunsPolicy();

    public JackrabbitThreadPool() {
        super(size, factory, handler);
    }
}

