/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyData;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyImpl
extends ItemImpl
implements Property {
    private static Logger log = LoggerFactory.getLogger(PropertyImpl.class);
    private final PropertyData data;

    PropertyImpl(ItemManager itemMgr, SessionContext sessionContext, PropertyData data) {
        super(itemMgr, sessionContext, data);
        this.data = data;
    }

    private PropertyState getPropertyState() throws RepositoryException {
        ItemState state = this.getItemState();
        this.sanityCheck();
        return (PropertyState)state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ItemState getOrCreateTransientItemState() throws RepositoryException {
        PropertyData propertyData = this.data;
        synchronized (propertyData) {
            if (!this.isTransient()) {
                try {
                    PropertyState transientState = this.stateMgr.createTransientPropertyState(this.data.getPropertyState(), 2);
                    this.data.setState(transientState);
                }
                catch (ItemStateException ise) {
                    String msg = "failed to create transient state";
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)ise);
                }
            }
            return this.getItemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makePersistent() throws InvalidItemStateException {
        if (!this.isTransient()) {
            log.debug(this + " (" + this.id + "): there's no transient state to persist");
            return;
        }
        PropertyState transientState = this.data.getPropertyState();
        PropertyState persistentState = (PropertyState)transientState.getOverlayedState();
        if (persistentState == null) {
            try {
                persistentState = this.stateMgr.createNew(transientState);
            }
            catch (ItemStateException e) {
                throw new InvalidItemStateException((Throwable)e);
            }
        }
        PropertyState propertyState = persistentState;
        synchronized (propertyState) {
            if (transientState.isStale()) {
                String msg = this + ": the property cannot be saved because it has" + " been modified externally.";
                log.debug(msg);
                throw new InvalidItemStateException(msg);
            }
            persistentState.setType(transientState.getType());
            persistentState.setMultiValued(transientState.isMultiValued());
            persistentState.setValues(transientState.getValues());
            this.stateMgr.store(persistentState);
        }
        this.stateMgr.disconnectTransientItemState(transientState);
        this.data.setState(persistentState);
        this.data.setStatus(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreTransient(PropertyState transientState) throws RepositoryException {
        PropertyState thisState = null;
        if (!this.isTransient()) {
            thisState = (PropertyState)this.getOrCreateTransientItemState();
            if (transientState.getStatus() == 4 && thisState.getStatus() != 4) {
                thisState.setStatus(4);
                this.stateMgr.disconnectTransientItemState(thisState);
            }
        } else {
            PropertyData propertyData = this.data;
            synchronized (propertyData) {
                try {
                    thisState = this.stateMgr.createTransientPropertyState(transientState.getParentId(), transientState.getName(), 4);
                    this.data.setState(thisState);
                }
                catch (ItemStateException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        }
        thisState.setType(transientState.getType());
        thisState.setMultiValued(transientState.isMultiValued());
        thisState.setValues(transientState.getValues());
        thisState.setModCount(transientState.getModCount());
    }

    protected void onRedefine(QPropertyDefinition def) throws RepositoryException {
        PropertyDefinitionImpl newDef = this.sessionContext.getNodeTypeManager().getPropertyDefinition(def);
        this.data.setDefinition((ItemDefinition)newDef);
    }

    protected long getLength(InternalValue value) throws RepositoryException {
        long length;
        switch (value.getType()) {
            case 7: 
            case 8: {
                String str = ValueFormat.getJCRString((QValue)value, (NamePathResolver)this.sessionContext);
                length = str.length();
                break;
            }
            default: {
                length = value.getLength();
            }
        }
        return length;
    }

    protected void checkSetValue(boolean multipleValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        NodeImpl parent = (NodeImpl)this.getParent(false);
        if (multipleValues != this.isMultiple()) {
            String msg = multipleValues ? "Single-valued property can not be set to an array of values:" : "Multivalued property can not be set to a single value (an array of length one is OK): ";
            throw new ValueFormatException(msg + this);
        }
        this.sessionContext.getItemValidator().checkModify(this, 16, 0);
        this.sessionContext.getItemValidator().checkModify(parent, 390, 0);
    }

    protected void internalSetValue(InternalValue[] values, int type) throws ConstraintViolationException, RepositoryException {
        if (values == null) {
            ((NodeImpl)this.getParent()).removeChildProperty(((PropertyId)this.id).getName());
            return;
        }
        ArrayList<InternalValue> list = new ArrayList<InternalValue>();
        for (InternalValue v : values) {
            if (v == null) continue;
            list.add(v);
        }
        values = list.toArray(new InternalValue[list.size()]);
        PropertyState thisState = (PropertyState)this.getOrCreateTransientItemState();
        InternalValue[] oldValues = thisState.getValues();
        if (oldValues != null) {
            for (InternalValue old : oldValues) {
                if (old == null || old.getType() != 2) continue;
                old.discard();
            }
        }
        thisState.setValues(values);
        if (type == 0) {
            type = 1;
        }
        thisState.setType(type);
    }

    protected Node getParent(boolean checkPermission) throws RepositoryException {
        return (Node)this.itemMgr.getItem(this.getPropertyState().getParentId(), checkPermission);
    }

    public void setValue(Name name) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        InternalValue internalValue;
        this.sanityCheck();
        this.checkSetValue(false);
        PropertyDefinition definition = this.data.getPropertyDefinition();
        int reqType = definition.getRequiredType();
        if (reqType == 0) {
            reqType = 7;
        }
        if (name == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        if (reqType != 7) {
            Value targetValue = ValueHelper.convert((Value)ValueFormat.getJCRValue((QValue)InternalValue.create(name), (NamePathResolver)this.sessionContext, (ValueFactory)this.getSession().getValueFactory()), (int)reqType, (ValueFactory)this.getSession().getValueFactory());
            internalValue = InternalValue.create(targetValue, this.sessionContext, this.sessionContext.getDataStore());
        } else {
            internalValue = InternalValue.create(name);
        }
        this.internalSetValue(new InternalValue[]{internalValue}, reqType);
    }

    public void setValue(Name[] names) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(true);
        PropertyDefinition definition = this.data.getPropertyDefinition();
        int reqType = definition.getRequiredType();
        if (reqType == 0) {
            reqType = 7;
        }
        InternalValue[] internalValues = null;
        if (names != null) {
            internalValues = new InternalValue[names.length];
            for (int i = 0; i < names.length; ++i) {
                Name name = names[i];
                InternalValue internalValue = null;
                if (name != null) {
                    if (reqType != 7) {
                        Value targetValue = ValueHelper.convert((Value)ValueFormat.getJCRValue((QValue)InternalValue.create(name), (NamePathResolver)this.sessionContext, (ValueFactory)this.getSession().getValueFactory()), (int)reqType, (ValueFactory)this.getSession().getValueFactory());
                        internalValue = InternalValue.create(targetValue, this.sessionContext, this.sessionContext.getDataStore());
                    } else {
                        internalValue = InternalValue.create(name);
                    }
                }
                internalValues[i] = internalValue;
            }
        }
        this.internalSetValue(internalValues, reqType);
    }

    public Name getQName() {
        return ((PropertyId)this.id).getName();
    }

    public InternalValue[] internalGetValues() throws RepositoryException {
        PropertyDefinition definition = this.data.getPropertyDefinition();
        if (this.isMultiple()) {
            return this.getPropertyState().getValues();
        }
        throw new ValueFormatException(this + " is a single-valued property," + " so it's value can not be retrieved as an array");
    }

    public InternalValue internalGetValue() throws RepositoryException {
        if (this.isMultiple()) {
            throw new ValueFormatException(this + " is a multi-valued property," + " so it's values can only be retrieved as an array");
        }
        InternalValue[] values = this.getPropertyState().getValues();
        if (values.length > 0) {
            return values[0];
        }
        throw new RepositoryException(this + ": single-valued property with no value");
    }

    public Value[] getValues() throws RepositoryException {
        InternalValue[] internals = this.internalGetValues();
        Value[] values = new Value[internals.length];
        for (int i = 0; i < internals.length; ++i) {
            values[i] = ValueFormat.getJCRValue((QValue)internals[i], (NamePathResolver)this.sessionContext, (ValueFactory)this.getSession().getValueFactory());
        }
        return values;
    }

    public Value getValue() throws RepositoryException {
        try {
            return ValueFormat.getJCRValue((QValue)this.internalGetValue(), (NamePathResolver)this.sessionContext, (ValueFactory)this.getSession().getValueFactory());
        }
        catch (RuntimeException e) {
            String msg = "Internal error while retrieving value of " + this;
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public String getString() throws RepositoryException {
        return this.getValue().getString();
    }

    public InputStream getStream() throws RepositoryException {
        final Binary binary = this.getValue().getBinary();
        return new AutoCloseInputStream(binary.getStream()){

            public void close() throws IOException {
                super.close();
                binary.dispose();
            }
        };
    }

    public long getLong() throws RepositoryException {
        return this.getValue().getLong();
    }

    public double getDouble() throws RepositoryException {
        return this.getValue().getDouble();
    }

    public Calendar getDate() throws RepositoryException {
        return this.getValue().getDate();
    }

    public boolean getBoolean() throws RepositoryException {
        return this.getValue().getBoolean();
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        Session session = this.getSession();
        Value value = this.getValue();
        int type = value.getType();
        switch (type) {
            case 9: 
            case 10: {
                return session.getNodeByUUID(value.getString());
            }
            case 7: 
            case 8: {
                String path = value.getString();
                Path p = this.sessionContext.getQPath(path);
                boolean absolute = p.isAbsolute();
                try {
                    return absolute ? session.getNode(path) : this.getParent().getNode(path);
                }
                catch (PathNotFoundException e) {
                    throw new ItemNotFoundException(path);
                }
            }
            case 1: {
                try {
                    Value refValue = ValueHelper.convert((Value)value, (int)9, (ValueFactory)session.getValueFactory());
                    return session.getNodeByUUID(refValue.getString());
                }
                catch (RepositoryException e) {
                    Value pathValue = ValueHelper.convert((Value)value, (int)8, (ValueFactory)session.getValueFactory());
                    Path p = this.sessionContext.getQPath(pathValue.getString());
                    boolean absolute = p.isAbsolute();
                    try {
                        return absolute ? session.getNode(pathValue.getString()) : this.getParent().getNode(pathValue.getString());
                    }
                    catch (PathNotFoundException e1) {
                        throw new ItemNotFoundException(pathValue.getString());
                    }
                }
            }
        }
        throw new ValueFormatException("Property value cannot be converted to a PATH, REFERENCE or WEAKREFERENCE");
    }

    public Property getProperty() throws RepositoryException {
        boolean absolute;
        Value value = this.getValue();
        Value pathValue = ValueHelper.convert((Value)value, (int)8, (ValueFactory)this.getSession().getValueFactory());
        String path = pathValue.getString();
        try {
            Path p = this.sessionContext.getQPath(path);
            absolute = p.isAbsolute();
        }
        catch (RepositoryException e) {
            throw new ValueFormatException("Property value cannot be converted to a PATH");
        }
        try {
            return absolute ? this.getSession().getProperty(path) : this.getParent().getProperty(path);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(path);
        }
    }

    public BigDecimal getDecimal() throws RepositoryException {
        return this.getValue().getDecimal();
    }

    public void setValue(BigDecimal value) throws RepositoryException {
        if (value != null) {
            this.setValue(this.getValueFactory().createValue(value));
        } else {
            this.setValue((Value)null);
        }
    }

    public Binary getBinary() throws RepositoryException {
        return this.getValue().getBinary();
    }

    public void setValue(Binary value) throws RepositoryException {
        if (value != null) {
            this.setValue(this.getValueFactory().createValue(value));
        } else {
            this.setValue((Value)null);
        }
    }

    public void setValue(Calendar value) throws RepositoryException {
        if (value != null) {
            try {
                this.setValue(this.getSession().getValueFactory().createValue(value));
            }
            catch (IllegalArgumentException e) {
                throw new ValueFormatException("Value is not an ISO8601 date: " + value, (Throwable)e);
            }
        } else {
            this.setValue((Value)null);
        }
    }

    public void setValue(double value) throws RepositoryException {
        this.setValue(this.getValueFactory().createValue(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(InputStream value) throws RepositoryException {
        if (value != null) {
            Binary binary = this.getValueFactory().createBinary(value);
            try {
                this.setValue(this.getValueFactory().createValue(binary));
            }
            finally {
                binary.dispose();
            }
        } else {
            this.setValue((Value)null);
        }
    }

    public void setValue(String value) throws RepositoryException {
        if (value != null) {
            this.setValue(this.getValueFactory().createValue(value));
        } else {
            this.setValue((Value)null);
        }
    }

    public void setValue(String[] strings) throws RepositoryException {
        if (strings != null) {
            this.setValue(this.getValues(strings, 1));
        } else {
            this.setValue((Value[])null);
        }
    }

    public void setValue(boolean value) throws RepositoryException {
        this.setValue(this.getValueFactory().createValue(value));
    }

    public void setValue(Node value) throws RepositoryException {
        if (value != null) {
            try {
                this.setValue(this.getValueFactory().createValue(value));
            }
            catch (UnsupportedRepositoryOperationException e) {
                throw new ValueFormatException("Node is not referenceable: " + value, (Throwable)e);
            }
        } else {
            this.setValue((Value)null);
        }
    }

    public void setValue(long value) throws RepositoryException {
        this.setValue(this.getValueFactory().createValue(value));
    }

    public synchronized void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        InternalValue internalValue;
        this.sanityCheck();
        this.checkSetValue(false);
        PropertyDefinition definition = this.data.getPropertyDefinition();
        int reqType = definition.getRequiredType();
        if (reqType == 0) {
            reqType = value != null ? value.getType() : 1;
        }
        if (value == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        if (reqType != value.getType()) {
            Value targetVal = ValueHelper.convert((Value)value, (int)reqType, (ValueFactory)this.getSession().getValueFactory());
            internalValue = InternalValue.create(targetVal, this.sessionContext, this.sessionContext.getDataStore());
        } else {
            internalValue = InternalValue.create(value, this.sessionContext, this.sessionContext.getDataStore());
        }
        this.internalSetValue(new InternalValue[]{internalValue}, reqType);
    }

    public void setValue(Value[] values) throws RepositoryException {
        this.setValue(values, 0);
    }

    public void setValue(Value[] values, int valueType) throws RepositoryException {
        PropertyDefinition definition;
        int reqType;
        this.sanityCheck();
        this.checkSetValue(true);
        if (values != null) {
            int firstValueType = 0;
            for (Value value : values) {
                if (value == null) continue;
                if (firstValueType == 0) {
                    firstValueType = value.getType();
                    continue;
                }
                if (firstValueType == value.getType()) continue;
                throw new ValueFormatException("inhomogeneous type of values");
            }
        }
        if ((reqType = (definition = this.data.getPropertyDefinition()).getRequiredType()) == 0) {
            reqType = valueType;
        }
        InternalValue[] internalValues = null;
        if (values != null) {
            internalValues = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value;
                value = values[i];
                if (value != null) {
                    if (reqType == 0) {
                        reqType = value.getType();
                    }
                    if (reqType != value.getType()) {
                        value = ValueHelper.convert((Value)value, (int)reqType, (ValueFactory)this.getSession().getValueFactory());
                    }
                    internalValues[i] = InternalValue.create(value, this.sessionContext, this.sessionContext.getDataStore());
                    continue;
                }
                internalValues[i] = null;
            }
        }
        this.internalSetValue(internalValues, reqType);
    }

    public long getLength() throws RepositoryException {
        return this.getLength(this.internalGetValue());
    }

    public long[] getLengths() throws RepositoryException {
        InternalValue[] values = this.internalGetValues();
        long[] lengths = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            lengths[i] = this.getLength(values[i]);
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        this.sanityCheck();
        return this.data.getPropertyDefinition();
    }

    public int getType() throws RepositoryException {
        return this.getPropertyState().getType();
    }

    public boolean isMultiple() throws RepositoryException {
        this.sanityCheck();
        return this.getPropertyState().isMultiValued();
    }

    public boolean isNode() {
        return false;
    }

    public String getName() throws RepositoryException {
        this.sanityCheck();
        return this.sessionContext.getJCRName(((PropertyId)this.id).getName());
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.sanityCheck();
        visitor.visit((Property)this);
    }

    public Node getParent() throws RepositoryException {
        return this.getParent(true);
    }

    public String toString() {
        return "property " + super.toString();
    }
}

