/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx;

import org.apache.jackrabbit.core.jmx.core.CoreStat;
import org.apache.jackrabbit.core.jmx.core.CoreStatImpl;
import org.apache.jackrabbit.core.jmx.query.QueryStat;
import org.apache.jackrabbit.core.jmx.query.QueryStatImpl;
import org.apache.jackrabbit.core.jmx.registry.JmxRegistry;
import org.apache.jackrabbit.core.jmx.registry.JmxRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatManager {
    private static final Logger log = LoggerFactory.getLogger(StatManager.class);
    private static final Boolean DEFAULT_JMX_SUPPORT = Boolean.valueOf(System.getProperty("enableJmxSupport", "false"));
    private JmxRegistry jmxRegistry;
    private final boolean enableJmxSupport;
    private final QueryStat queryStat = new QueryStatImpl();
    private final CoreStat coreStat = new CoreStatImpl();

    public StatManager(boolean enableJmxSupport) {
        this.enableJmxSupport = enableJmxSupport;
    }

    public StatManager() {
        this(DEFAULT_JMX_SUPPORT);
    }

    public void init() {
        this.coreStat.setEnabled(false);
        this.queryStat.setEnabled(false);
        if (this.enableJmxSupport) {
            this.enableJxmRegistry();
        }
        log.debug("Started StatManager. Jmx support enabled {}.", (Object)this.enableJmxSupport);
    }

    protected void enableJxmRegistry() {
        if (this.jmxRegistry != null) {
            return;
        }
        this.jmxRegistry = new JmxRegistryImpl(this);
        this.jmxRegistry.start();
    }

    public void stop() {
        if (this.jmxRegistry != null) {
            this.jmxRegistry.stop();
        }
    }

    public CoreStat getCoreStat() {
        return this.coreStat;
    }

    public QueryStat getQueryStat() {
        return this.queryStat;
    }
}

