/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx.core;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.core.jmx.core.CoreStat;
import org.apache.jackrabbit.core.jmx.util.CachingOpsPerSecondDto;

public class CoreStatImpl
implements CoreStat {
    private final AtomicLong sessions = new AtomicLong(0L);
    private boolean enabled = false;
    private final CachingOpsPerSecondDto reads = new CachingOpsPerSecondDto();
    private final CachingOpsPerSecondDto writes = new CachingOpsPerSecondDto();

    public void sessionCreated() {
        if (!this.enabled) {
            return;
        }
        this.sessions.incrementAndGet();
    }

    public void sessionLoggedOut() {
        if (!this.enabled || this.sessions.get() == 0L) {
            return;
        }
        this.sessions.decrementAndGet();
    }

    public long getNumberOfSessions() {
        return this.sessions.get();
    }

    public void resetNumberOfSessions() {
        this.sessions.set(0L);
    }

    public void onSessionOperation(boolean isWrite, long timeNs) {
        if (!this.enabled) {
            return;
        }
        if (isWrite) {
            this.writes.onOp(timeNs);
        } else {
            this.reads.onOp(timeNs);
        }
    }

    public double getReadOpsPerSecond() {
        return this.reads.getOpsPerSecond();
    }

    public double getWriteOpsPerSecond() {
        return this.writes.getOpsPerSecond();
    }

    public void resetNumberOfOperations() {
        this.reads.reset();
        this.writes.reset();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!this.enabled) {
            this.reset();
        }
    }

    public void reset() {
        this.resetNumberOfSessions();
        this.resetNumberOfOperations();
    }
}

