/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jmx.registry;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.jackrabbit.core.jmx.JackrabbitBaseMBean;
import org.apache.jackrabbit.core.jmx.StatManager;
import org.apache.jackrabbit.core.jmx.core.CoreStatManager;
import org.apache.jackrabbit.core.jmx.query.QueryStatManager;
import org.apache.jackrabbit.core.jmx.registry.JmxRegistry;
import org.apache.jackrabbit.core.jmx.registry.JmxRegistryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxRegistryImpl
implements JmxRegistry {
    private static Logger log = LoggerFactory.getLogger(JmxRegistryImpl.class);
    private MBeanServer server;
    private final List<ObjectName> registry = new ArrayList<ObjectName>();
    private final StatManager statManager;

    public JmxRegistryImpl(StatManager statManager) {
        this.statManager = statManager;
    }

    public void start() {
        this.server = ManagementFactory.getPlatformMBeanServer();
        this.enableRegistry();
        log.debug("Started JMX Registry.");
    }

    public void enableRegistry() {
        if (this.server == null) {
            return;
        }
        try {
            this.register(new JmxRegistryManager(this), new ObjectName("org.apache.jackrabbit:type=DynamicRegistry"));
            log.debug("JMX Registry - registered DynamicRegistry.");
        }
        catch (Exception e) {
            log.error("JMX Registry - Unable to register DynamicRegistry.", (Throwable)e);
        }
    }

    public void enableCoreStatJmx() {
        if (this.server == null) {
            return;
        }
        try {
            this.register(new CoreStatManager(this.statManager.getCoreStat()), new ObjectName("org.apache.jackrabbit:type=CoreStats"));
            log.debug("JMX Registry - registered CoreStats.");
        }
        catch (Exception e) {
            log.error("JMX Registry - Unable to register CoreStats.", (Throwable)e);
        }
    }

    public void enableQueryStatJmx() {
        if (this.server == null) {
            return;
        }
        try {
            this.register(new QueryStatManager(this.statManager.getQueryStat()), new ObjectName("org.apache.jackrabbit:type=QueryStats"));
            log.debug("JMX Registry - registered QueryStats.");
        }
        catch (Exception e) {
            log.error("JMX Registry - Unable to register CoreStats.", (Throwable)e);
        }
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        ArrayList<ObjectName> registryCopy = new ArrayList<ObjectName>(this.registry);
        for (ObjectName o : registryCopy) {
            try {
                this.unregister(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.registry.clear();
    }

    public void register(JackrabbitBaseMBean bean, ObjectName name) throws Exception {
        if (this.server == null || this.server.isRegistered(name)) {
            return;
        }
        this.server.registerMBean(bean, name);
        this.registry.add(name);
    }

    public void unregister(ObjectName name) throws Exception {
        if (this.server == null || !this.server.isRegistered(name)) {
            return;
        }
        this.registry.remove(name);
        this.server.unregisterMBean(name);
    }
}

