/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.MemoryRevision;
import org.apache.jackrabbit.core.journal.ReadRecord;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryJournal
extends AbstractJournal {
    private static final long DEFAULT_READ_DELAY = 0L;
    private static final long DEFAULT_WRITE_DELAY = 0L;
    private static Logger log = LoggerFactory.getLogger(MemoryJournal.class);
    private InstanceRevision revision = new MemoryRevision();
    private List<MemoryRecord> records = Collections.synchronizedList(new ArrayList());
    private long readDelay = 0L;
    private long writeDelay = 0L;
    private boolean closed;

    @Override
    public InstanceRevision getInstanceRevision() throws JournalException {
        return this.revision;
    }

    @Override
    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
    }

    @Override
    protected void doLock() throws JournalException {
        this.checkState();
    }

    @Override
    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        int len;
        this.checkState();
        byte[] data = new byte[length];
        for (int off = 0; off < data.length; off += len) {
            try {
                len = in.read(data, off, data.length - off);
                if (len >= 0) continue;
                String msg = "Unexpected end of record after " + off + " bytes.";
                throw new JournalException(msg);
            }
            catch (IOException e) {
                String msg = "I/O error after " + off + " bytes.";
                throw new JournalException(msg, e);
            }
        }
        try {
            Thread.sleep(this.writeDelay);
        }
        catch (InterruptedException e) {
            throw new JournalException("Interrupted in append().");
        }
        this.records.add(new MemoryRecord(this.getId(), record.getProducerId(), data));
        record.setRevision(this.records.size());
    }

    @Override
    protected void doUnlock(boolean successful) {
        try {
            this.checkState();
        }
        catch (JournalException e) {
            log.warn("Journal already closed while unlocking.");
        }
    }

    @Override
    public RecordIterator getRecords(long startRevision) throws JournalException {
        this.checkState();
        startRevision = Math.max(startRevision, 0L);
        long stopRevision = this.records.size();
        return new MemoryRecordIterator(startRevision, stopRevision);
    }

    @Override
    public RecordIterator getRecords() throws JournalException {
        return new MemoryRecordIterator(0L, this.records.size());
    }

    public void setRecords(List<MemoryRecord> records) {
        this.records = records;
    }

    public long getReadDelay() {
        return this.readDelay;
    }

    public void setReadDelay(long readDelay) {
        this.readDelay = readDelay;
    }

    public long getWriteDelay() {
        return this.writeDelay;
    }

    public void setWriteDelay(long writeDelay) {
        this.writeDelay = writeDelay;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void checkState() throws JournalException {
        if (this.closed) {
            throw new JournalException("Journal closed.");
        }
    }

    public class MemoryRecordIterator
    implements RecordIterator {
        private long revision;
        private final long stopRevision;

        public MemoryRecordIterator(long startRevision, long stopRevision) {
            this.revision = startRevision;
            this.stopRevision = stopRevision;
        }

        public boolean hasNext() {
            return this.revision < this.stopRevision;
        }

        public Record nextRecord() throws NoSuchElementException, JournalException {
            int index = (int)this.revision;
            MemoryRecord record = (MemoryRecord)MemoryJournal.this.records.get(index);
            MemoryJournal.this.checkState();
            byte[] data = record.getData();
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(data));
            try {
                Thread.sleep(MemoryJournal.this.readDelay);
            }
            catch (InterruptedException e) {
                throw new JournalException("Interrupted in read().");
            }
            return new ReadRecord(record.getJournalId(), record.getProducerId(), ++this.revision, dataIn, data.length, MemoryJournal.this.getResolver(), MemoryJournal.this.getNamePathResolver());
        }

        public void close() {
        }
    }

    public static class MemoryRecord {
        private String journalId;
        private String producerId;
        private byte[] data;

        public MemoryRecord(String journalId, String producerId, byte[] data) {
            this.journalId = journalId;
            this.producerId = producerId;
            this.data = data;
        }

        public String getJournalId() {
            return this.journalId;
        }

        public String getProducerId() {
            return this.producerId;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

