/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;

public class NodeTraversingQueryHits
extends AbstractQueryHits {
    private final Iterator<Node> nodes;

    public NodeTraversingQueryHits(Node start, boolean includeStart) {
        this(start, includeStart, Integer.MAX_VALUE);
    }

    public NodeTraversingQueryHits(Node start, boolean includeStart, int maxDepth) {
        this.nodes = new TraversingNodeIterator(start, maxDepth);
        if (!includeStart) {
            this.nodes.next();
        }
    }

    public ScoreNode nextScoreNode() throws IOException {
        if (this.nodes.hasNext()) {
            NodeImpl n = (NodeImpl)this.nodes.next();
            return new ScoreNode(n.getNodeId(), 1.0f);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TraversingNodeIterator
    implements Iterator<Node> {
        private final Node currentNode;
        private final int maxDepth;
        private Iterator<Node> selfAndChildren;

        TraversingNodeIterator(Node start, int maxDepth) {
            if (maxDepth < 0) {
                throw new IllegalArgumentException("maxDepth must be >= 0");
            }
            this.currentNode = start;
            this.maxDepth = maxDepth;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            this.init();
            return this.selfAndChildren.hasNext();
        }

        @Override
        public Node next() {
            this.init();
            return this.selfAndChildren.next();
        }

        private void init() {
            if (this.selfAndChildren == null) {
                ArrayList<Iterator<Object>> allIterators = new ArrayList<Iterator<Object>>();
                Iterator<Node> current = Collections.singletonList(this.currentNode).iterator();
                allIterators.add(current);
                if (this.maxDepth != 0) {
                    if (this.maxDepth == 1) {
                        try {
                            allIterators.add((Iterator<Object>)this.currentNode.getNodes());
                        }
                        catch (RepositoryException e) {}
                    } else {
                        try {
                            NodeIterator children = this.currentNode.getNodes();
                            while (children.hasNext()) {
                                allIterators.add(new TraversingNodeIterator(children.nextNode(), this.maxDepth - 1));
                            }
                        }
                        catch (RepositoryException repositoryException) {
                            // empty catch block
                        }
                    }
                }
                this.selfAndChildren = new IteratorChain(allIterators);
            }
        }
    }
}

