/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.AbstractWeight;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.Transformable;
import org.apache.jackrabbit.core.query.lucene.WildcardTermEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardQuery
extends Query
implements Transformable {
    private static final Logger log = LoggerFactory.getLogger(WildcardQuery.class);
    private final String field;
    private final WildcardTermEnum.TermValueFactory tvf;
    private final String pattern;
    private int transform = 0;
    private final PerQueryCache cache;
    private Query multiTermQuery;

    public WildcardQuery(String field, final String propName, String pattern, int transform, PerQueryCache cache) {
        this.field = field.intern();
        this.pattern = pattern;
        this.transform = transform;
        this.cache = cache;
        this.tvf = propName != null ? new WildcardTermEnum.TermValueFactory(){

            public String createValue(String s) {
                return FieldNames.createNamedValue(propName, s);
            }
        } : new WildcardTermEnum.TermValueFactory();
    }

    public WildcardQuery(String field, String propName, String pattern, PerQueryCache cache) {
        this(field, propName, pattern, 0, cache);
    }

    @Override
    public void setTransformation(int transformation) {
        this.transform = transformation;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        MultiTermQuery stdWildcardQuery = new MultiTermQuery(){

            protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
                return new WildcardTermEnum(reader, WildcardQuery.this.field, WildcardQuery.this.tvf, WildcardQuery.this.pattern, WildcardQuery.this.transform);
            }

            public String toString(String field) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(field);
                buffer.append(':');
                buffer.append(ToStringUtils.boost((float)this.getBoost()));
                return buffer.toString();
            }
        };
        try {
            this.multiTermQuery = stdWildcardQuery.rewrite(reader);
            return this.multiTermQuery;
        }
        catch (BooleanQuery.TooManyClauses e) {
            log.debug("Too many terms to enumerate, using custom WildcardQuery.");
            return this;
        }
    }

    public Weight createWeight(Searcher searcher) {
        return new WildcardQueryWeight(searcher, this.cache);
    }

    public String toString(String field) {
        return field + ":" + this.tvf.createValue(this.pattern);
    }

    public void extractTerms(Set<Term> terms) {
        if (this.multiTermQuery != null) {
            this.multiTermQuery.extractTerms(terms);
        }
    }

    private final class WildcardQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private boolean hitsCalculated;
        private int nextDoc;
        private final String cacheKey;
        private final Map<String, BitSet> resultMap;

        WildcardQueryScorer(Similarity similarity, IndexReader reader, PerQueryCache cache) {
            super(similarity);
            this.hitsCalculated = false;
            this.nextDoc = -1;
            this.reader = reader;
            this.cacheKey = WildcardQuery.this.field + '\uffff' + WildcardQuery.this.tvf.createValue('\uffff' + WildcardQuery.this.pattern) + '\uffff' + WildcardQuery.this.transform;
            HashMap m = (HashMap)cache.get(WildcardQueryScorer.class, reader);
            if (m == null) {
                m = new HashMap();
                cache.put(WildcardQueryScorer.class, reader, m);
            }
            this.resultMap = m;
            BitSet result = this.resultMap.get(this.cacheKey);
            if (result == null) {
                result = new BitSet(reader.maxDoc());
            } else {
                this.hitsCalculated = true;
            }
            this.hits = result;
        }

        public int nextDoc() throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        public int docID() {
            return this.nextDoc;
        }

        public float score() {
            return 1.0f;
        }

        public int advance(int target) throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(target);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateHits() throws IOException {
            if (this.hitsCalculated) {
                return;
            }
            WildcardTermEnum terms = new WildcardTermEnum(this.reader, WildcardQuery.this.field, WildcardQuery.this.tvf, WildcardQuery.this.pattern, WildcardQuery.this.transform);
            try {
                TermDocs docs = this.reader.termDocs();
                try {
                    while (terms.term() != null) {
                        docs.seek((TermEnum)terms);
                        while (docs.next()) {
                            this.hits.set(docs.doc());
                        }
                        if (terms.next()) continue;
                        break;
                    }
                }
                finally {
                    docs.close();
                }
            }
            finally {
                terms.close();
            }
            this.hitsCalculated = true;
            this.resultMap.put(this.cacheKey, this.hits);
        }
    }

    private class WildcardQueryWeight
    extends AbstractWeight {
        private final PerQueryCache cache;

        public WildcardQueryWeight(Searcher searcher, PerQueryCache cache) {
            super(searcher);
            this.cache = cache;
        }

        protected Scorer createScorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) {
            return new WildcardQueryScorer(this.searcher.getSimilarity(), reader, this.cache);
        }

        public Query getQuery() {
            return WildcardQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

