/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.sort;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.Ordering;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.sort.AbstractFieldComparator;
import org.apache.jackrabbit.core.query.lucene.sort.ValueComparableWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;

public final class DynamicOperandFieldComparator
extends AbstractFieldComparator {
    private final Session session;
    private final OperandEvaluator evaluator;
    private final Ordering ordering;
    private final boolean reversed;

    public DynamicOperandFieldComparator(Session session, OperandEvaluator evaluator, Ordering ordering, int numHits, boolean reversed) {
        super(numHits);
        this.session = session;
        this.evaluator = evaluator;
        this.ordering = ordering;
        this.reversed = reversed;
    }

    protected Comparable sortValue(int doc) {
        try {
            int idx = this.readerIndex(doc);
            IndexReader reader = (IndexReader)this.readers.get(idx);
            Document document = reader.document(doc - this.starts[idx]);
            String uuid = document.get(FieldNames.UUID);
            Node n = this.session.getNodeByIdentifier(uuid);
            Value[] v = this.evaluator.getValues((Operand)this.ordering.getOperand(), n);
            return new ValueComparableWrapper(v, this.reversed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

