/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccessControlProvider
implements AccessControlProvider,
AccessControlUtils,
AccessControlConstants {
    public static final String PARAM_OMIT_DEFAULT_PERMISSIONS = "omit-default-permission";
    protected SessionImpl session;
    protected ObservationManager observationMgr;
    protected PrivilegeManagerImpl privilegeManager;
    private boolean initialized;

    protected AbstractAccessControlProvider() {
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized or already closed.");
        }
    }

    protected PrivilegeManagerImpl getPrivilegeManagerImpl() throws RepositoryException {
        return this.privilegeManager;
    }

    protected CompiledPermissions getAdminPermissions() {
        return new CompiledPermissions(){

            @Override
            public void close() {
            }

            @Override
            public boolean grants(Path absPath, int permissions) {
                return true;
            }

            @Override
            public int getPrivileges(Path absPath) throws RepositoryException {
                return PrivilegeRegistry.getBits(new Privilege[]{this.getAllPrivilege()});
            }

            @Override
            public boolean hasPrivileges(Path absPath, Privilege ... privileges) {
                return true;
            }

            @Override
            public Set<Privilege> getPrivilegeSet(Path absPath) throws RepositoryException {
                return Collections.singleton(this.getAllPrivilege());
            }

            @Override
            public boolean canReadAll() {
                return true;
            }

            @Override
            public boolean canRead(Path itemPath, ItemId itemId) {
                return true;
            }

            private Privilege getAllPrivilege() throws RepositoryException {
                return AbstractAccessControlProvider.this.getPrivilegeManagerImpl().getPrivilege("{http://www.jcp.org/jcr/1.0}all");
            }
        };
    }

    protected CompiledPermissions getReadOnlyPermissions() {
        return new CompiledPermissions(){

            @Override
            public void close() {
            }

            @Override
            public boolean grants(Path absPath, int permissions) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return false;
                }
                return permissions == 1;
            }

            @Override
            public int getPrivileges(Path absPath) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return 0;
                }
                return PrivilegeRegistry.getBits(new Privilege[]{this.getReadPrivilege()});
            }

            @Override
            public boolean hasPrivileges(Path absPath, Privilege ... privileges) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return false;
                }
                return privileges != null && privileges.length == 1 && this.getReadPrivilege().equals(privileges[0]);
            }

            @Override
            public Set<Privilege> getPrivilegeSet(Path absPath) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(this.getReadPrivilege());
            }

            @Override
            public boolean canReadAll() {
                return false;
            }

            @Override
            public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
                if (itemPath != null) {
                    return !AbstractAccessControlProvider.this.isAcItem(itemPath);
                }
                return !AbstractAccessControlProvider.this.isAcItem(AbstractAccessControlProvider.this.session.getItemManager().getItem(itemId));
            }

            private Privilege getReadPrivilege() throws RepositoryException {
                return AbstractAccessControlProvider.this.getPrivilegeManagerImpl().getPrivilege("{http://www.jcp.org/jcr/1.0}read");
            }
        };
    }

    @Override
    public boolean isAcItem(Path absPath) throws RepositoryException {
        Path.Element[] elems = absPath.getElements();
        if (elems.length > 1) {
            int index = elems.length - 1;
            for (int j = 1; index >= 0 && j <= 3; --index, ++j) {
                if (!N_POLICY.equals(elems[index].getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        NodeImpl n = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        Name ntName = ((NodeTypeImpl)n.getPrimaryNodeType()).getQName();
        return ntName.equals(NT_REP_ACL) || ntName.equals(NT_REP_GRANT_ACE) || ntName.equals(NT_REP_DENY_ACE);
    }

    @Override
    public boolean isAdminOrSystem(Set<Principal> principals) {
        for (Principal p : principals) {
            if (!(p instanceof AdminPrincipal) && !(p instanceof SystemPrincipal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadOnly(Set<Principal> principals) {
        return false;
    }

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (!(systemSession instanceof SessionImpl)) {
            throw new RepositoryException("SessionImpl (system session) expected.");
        }
        this.session = (SessionImpl)systemSession;
        this.observationMgr = systemSession.getWorkspace().getObservationManager();
        this.privilegeManager = (PrivilegeManagerImpl)((JackrabbitWorkspace)this.session.getWorkspace()).getPrivilegeManager();
        this.initialized = true;
    }

    @Override
    public void close() {
        this.checkInitialized();
        this.initialized = false;
    }

    @Override
    public boolean isLive() {
        return this.initialized && this.session.isLive();
    }
}

