/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.Arrays;

public class PrivilegeBits {
    public static final PrivilegeBits EMPTY = new PrivilegeBits(UnmodifiableData.access$000());
    private static final long READ = 1L;
    private final Data d;

    private PrivilegeBits(Data d) {
        this.d = d;
    }

    long longValue() {
        return this.d.longValue();
    }

    PrivilegeBits nextBits() {
        if (this == EMPTY) {
            return EMPTY;
        }
        return new PrivilegeBits(this.d.next());
    }

    PrivilegeBits unmodifiable() {
        if (this.d instanceof ModifiableData) {
            return this.d.isSimple() ? PrivilegeBits.getInstance(this.d.longValue()) : PrivilegeBits.getInstance(this.d.longValues());
        }
        return this;
    }

    static PrivilegeBits getInstance(long bits) {
        if (bits == 0L) {
            return EMPTY;
        }
        if (bits < 0L) {
            throw new IllegalArgumentException();
        }
        return new PrivilegeBits(new UnmodifiableData(bits));
    }

    private static PrivilegeBits getInstance(long[] bits) {
        long[] bts = new long[bits.length];
        System.arraycopy(bits, 0, bts, 0, bits.length);
        return new PrivilegeBits(new UnmodifiableData(bts));
    }

    public static PrivilegeBits getInstance() {
        return new PrivilegeBits(new ModifiableData());
    }

    public static PrivilegeBits getInstance(PrivilegeBits base) {
        return new PrivilegeBits(new ModifiableData(base.d));
    }

    public boolean isEmpty() {
        return this.d.isEmpty();
    }

    public boolean includesRead() {
        if (this == EMPTY) {
            return false;
        }
        if (this.d.isSimple()) {
            return (this.d.longValue() & 1L) == 1L;
        }
        return (this.d.longValues()[0] & 1L) == 1L;
    }

    public boolean includes(PrivilegeBits otherBits) {
        return this.d.includes(otherBits.d);
    }

    public void add(PrivilegeBits other) {
        if (!(this.d instanceof ModifiableData)) {
            throw new UnsupportedOperationException("immutable privilege bits");
        }
        ((ModifiableData)this.d).add(other.d);
    }

    public void diff(PrivilegeBits other) {
        if (!(this.d instanceof ModifiableData)) {
            throw new UnsupportedOperationException("immutable privilege bits");
        }
        ((ModifiableData)this.d).diff(other.d);
    }

    public void addDifference(PrivilegeBits a, PrivilegeBits b) {
        if (!(this.d instanceof ModifiableData)) {
            throw new UnsupportedOperationException("immutable privilege bits");
        }
        ((ModifiableData)this.d).addDifference(a.d, b.d);
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PrivilegeBits) {
            return this.d.equals(((PrivilegeBits)o).d);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PrivilegeBits: ");
        if (this.d.isSimple()) {
            sb.append(this.d.longValue());
        } else {
            sb.append(Arrays.toString(this.d.longValues()));
        }
        return sb.toString();
    }

    private static class ModifiableData
    extends Data {
        private long[] bits;

        private ModifiableData() {
            this.bits = new long[]{0L};
        }

        private ModifiableData(Data base) {
            long[] b = base.longValues();
            switch (b.length) {
                case 0: {
                    this.bits = new long[]{0L};
                    break;
                }
                case 1: {
                    this.bits = new long[]{b[0]};
                    break;
                }
                default: {
                    this.bits = new long[b.length];
                    System.arraycopy(b, 0, this.bits, 0, b.length);
                }
            }
        }

        boolean isEmpty() {
            return this.bits.length == 1 && this.bits[0] == 0L;
        }

        long longValue() {
            return this.bits.length == 1 ? this.bits[0] : 0L;
        }

        long[] longValues() {
            return this.bits;
        }

        boolean isSimple() {
            return this.bits.length == 1;
        }

        Data next() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        boolean includes(Data other) {
            if (this.bits.length == 1) {
                return other.isSimple() && ModifiableData.includes(this.bits[0], other.longValue());
            }
            return ModifiableData.includes(this.bits, other.longValues());
        }

        private void add(Data other) {
            if (other != this) {
                if (this.bits.length == 1 && other.isSimple()) {
                    this.bits[0] = this.bits[0] | other.longValue();
                } else {
                    this.or(other.longValues());
                }
            }
        }

        private void diff(Data other) {
            if (this.bits.length == 1 && other.isSimple()) {
                this.bits[0] = this.bits[0] & (other.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.bits = ModifiableData.diff(this.bits, other.longValues());
            }
        }

        private void addDifference(Data a, Data b) {
            if (a.isSimple() && b.isSimple()) {
                this.bits[0] = this.bits[0] | a.longValue() & (b.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                long[] diff = ModifiableData.diff(a.longValues(), b.longValues());
                this.or(diff);
            }
        }

        private void or(long[] b) {
            if (b.length > this.bits.length) {
                long[] res = new long[b.length];
                System.arraycopy(this.bits, 0, res, 0, this.bits.length);
                this.bits = res;
            }
            for (int i = 0; i < b.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | b[i];
            }
        }

        private static long[] diff(long[] a, long[] b) {
            int index = -1;
            long[] res = new long[a.length > b.length ? a.length : b.length];
            for (int i = 0; i < res.length; ++i) {
                if (i < a.length && i < b.length) {
                    res[i] = a[i] & (b[i] ^ 0xFFFFFFFFFFFFFFFFL);
                } else {
                    long l = res[i] = i < a.length ? a[i] : 0L;
                }
                if (res[i] != 0L) {
                    index = -1;
                    continue;
                }
                if (index != -1) continue;
                index = i;
            }
            switch (index) {
                case -1: {
                    return res;
                }
                case 0: {
                    return new long[]{0L};
                }
            }
            long[] r2 = new long[index];
            System.arraycopy(res, 0, r2, 0, index);
            return r2;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class UnmodifiableData
    extends Data {
        private static final long MAX = 0x3FFFFFFFFFFFFFFFL;
        private static final UnmodifiableData EMPTY = new UnmodifiableData(0L);
        private final long bits;
        private final long[] bitsArr;
        private final boolean isSimple;

        private UnmodifiableData(long bits) {
            this.bits = bits;
            this.bitsArr = new long[]{bits};
            this.isSimple = true;
        }

        private UnmodifiableData(long[] bitsArr) {
            this.bits = 0L;
            this.bitsArr = bitsArr;
            this.isSimple = false;
        }

        boolean isEmpty() {
            return this == EMPTY;
        }

        long longValue() {
            return this.bits;
        }

        long[] longValues() {
            return this.bitsArr;
        }

        boolean isSimple() {
            return this.isSimple;
        }

        Data next() {
            long[] bts;
            if (this == EMPTY) {
                return EMPTY;
            }
            if (this.isSimple) {
                if (this.bits < 0x3FFFFFFFFFFFFFFFL) {
                    long b = this.bits << 1;
                    return new UnmodifiableData(b);
                }
                return new UnmodifiableData(new long[]{this.bits}).next();
            }
            long last = this.bitsArr[this.bitsArr.length - 1];
            if (last < 0x3FFFFFFFFFFFFFFFL) {
                bts = new long[this.bitsArr.length];
                System.arraycopy(this.bitsArr, 0, bts, 0, this.bitsArr.length);
                bts[bts.length - 1] = last << 1;
            } else {
                bts = new long[this.bitsArr.length + 1];
                bts[bts.length - 1] = 1L;
            }
            return new UnmodifiableData(bts);
        }

        boolean includes(Data other) {
            if (this.isSimple) {
                return other.isSimple() ? UnmodifiableData.includes(this.bits, other.longValue()) : false;
            }
            return UnmodifiableData.includes(this.bitsArr, other.longValues());
        }

        public int hashCode() {
            return this.isSimple ? new Long(this.bits).hashCode() : this.bitsArr.hashCode();
        }

        static /* synthetic */ UnmodifiableData access$000() {
            return EMPTY;
        }
    }

    private static abstract class Data {
        private Data() {
        }

        abstract boolean isEmpty();

        abstract long longValue();

        abstract long[] longValues();

        abstract boolean isSimple();

        abstract Data next();

        abstract boolean includes(Data var1);

        static boolean includes(long bits, long otherBits) {
            return (bits | otherBits ^ 0xFFFFFFFFFFFFFFFFL) == -1L;
        }

        static boolean includes(long[] bits, long[] otherBits) {
            if (otherBits.length <= bits.length) {
                for (int i = 0; i < otherBits.length; ++i) {
                    if ((bits[i] | otherBits[i] ^ 0xFFFFFFFFFFFFFFFFL) == -1L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data d = (Data)o;
                if (this.isSimple() != d.isSimple()) {
                    return false;
                }
                if (this.isSimple()) {
                    return this.longValue() == d.longValue();
                }
                return Arrays.equals(this.longValues(), d.longValues());
            }
            return false;
        }
    }
}

