/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrivilegeManagerImpl
implements PrivilegeManager,
PrivilegeRegistry.Listener {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeManagerImpl.class);
    private static final Privilege[] EMPTY_ARRAY = new Privilege[0];
    private final PrivilegeRegistry registry;
    private final NameResolver resolver;
    private final Map<Name, Privilege> cache;

    public PrivilegeManagerImpl(PrivilegeRegistry registry, NameResolver nameResolver) {
        this.registry = registry;
        this.resolver = nameResolver;
        this.cache = new HashMap<Name, Privilege>();
        registry.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Privilege[] getRegisteredPrivileges() throws RepositoryException {
        PrivilegeDefinition[] allDefs = this.registry.getAll();
        if (allDefs.length != this.cache.size()) {
            Map<Name, Privilege> map = this.cache;
            synchronized (map) {
                for (PrivilegeDefinition def : allDefs) {
                    if (this.cache.containsKey(def.getName())) continue;
                    this.cache.put(def.getName(), new PrivilegeImpl(def));
                }
            }
        }
        return this.cache.values().toArray(new Privilege[allDefs.length]);
    }

    public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
        Name name = this.resolver.getQName(privilegeName);
        return this.getPrivilege(name);
    }

    public Privilege registerPrivilege(String privilegeName, boolean isAbstract, String[] declaredAggregateNames) throws AccessDeniedException, RepositoryException {
        Set<Name> daNames;
        if (!(this.resolver instanceof SessionImpl)) {
            throw new AccessDeniedException("Registering privileges is not allowed for the editing session.");
        }
        SessionImpl sImpl = (SessionImpl)this.resolver;
        sImpl.getAccessManager().checkRepositoryPermission(65536);
        Name name = this.resolver.getQName(privilegeName);
        if (declaredAggregateNames == null || declaredAggregateNames.length == 0) {
            daNames = Collections.emptySet();
        } else {
            daNames = new HashSet(declaredAggregateNames.length);
            for (String declaredAggregateName : declaredAggregateNames) {
                daNames.add(this.resolver.getQName(declaredAggregateName));
            }
        }
        this.registry.registerDefinition(name, isAbstract, daNames);
        return this.getPrivilege(privilegeName);
    }

    public PrivilegeBits getBits(Privilege ... privileges) throws AccessControlException {
        if (privileges == null || privileges.length == 0) {
            throw new AccessControlException("Privilege array is empty or null.");
        }
        PrivilegeDefinition[] defs = new PrivilegeDefinition[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            Privilege p = privileges[i];
            if (!(p instanceof PrivilegeImpl)) {
                String name = p == null ? "null" : p.getName();
                throw new AccessControlException("Unknown privilege '" + name + "'.");
            }
            defs[i] = ((PrivilegeImpl)p).definition;
        }
        return this.registry.getBits(defs);
    }

    public Set<Privilege> getPrivileges(PrivilegeBits bits) {
        Name[] names = this.registry.getNames(bits);
        if (names.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Privilege> privs = new HashSet<Privilege>(names.length);
        for (Name n : names) {
            try {
                privs.add(this.getPrivilege(n));
            }
            catch (RepositoryException e) {
                log.error("Internal error: invalid privilege name " + n.toString());
            }
        }
        return privs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Privilege getPrivilege(Name name) throws AccessControlException, RepositoryException {
        Privilege privilege;
        Map<Name, Privilege> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(name)) {
                privilege = this.cache.get(name);
            } else {
                PrivilegeDefinition def = this.registry.get(name);
                if (def != null) {
                    privilege = new PrivilegeImpl(def);
                    this.cache.put(name, privilege);
                } else {
                    throw new AccessControlException("Unknown privilege " + this.resolver.getJCRName(name));
                }
            }
        }
        return privilege;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void privilegesRegistered(Set<Name> privilegeNames) {
        Map<Name, Privilege> map = this.cache;
        synchronized (map) {
            this.cache.remove(NameConstants.JCR_ALL);
        }
    }

    private class PrivilegeImpl
    implements Privilege {
        private final PrivilegeDefinition definition;
        private final Privilege[] declaredAggregates;
        private final Privilege[] aggregates;

        private PrivilegeImpl(PrivilegeDefinition definition) throws RepositoryException {
            this.definition = definition;
            Set set = definition.getDeclaredAggregateNames();
            Name[] declAggrNames = set.toArray(new Name[set.size()]);
            if (declAggrNames.length == 0) {
                this.declaredAggregates = EMPTY_ARRAY;
                this.aggregates = EMPTY_ARRAY;
            } else {
                this.declaredAggregates = new Privilege[declAggrNames.length];
                for (int i = 0; i < declAggrNames.length; ++i) {
                    this.declaredAggregates[i] = PrivilegeManagerImpl.this.getPrivilege(declAggrNames[i]);
                }
                HashSet<Privilege> aggr = new HashSet<Privilege>();
                for (Privilege decl : this.declaredAggregates) {
                    aggr.add(decl);
                    if (!decl.isAggregate()) continue;
                    aggr.addAll(Arrays.asList(decl.getAggregatePrivileges()));
                }
                this.aggregates = aggr.toArray(new Privilege[aggr.size()]);
            }
        }

        public String getName() {
            try {
                return PrivilegeManagerImpl.this.resolver.getJCRName(this.definition.getName());
            }
            catch (NamespaceException e) {
                return this.definition.getName().toString();
            }
        }

        public boolean isAbstract() {
            return this.definition.isAbstract();
        }

        public boolean isAggregate() {
            return this.declaredAggregates.length > 0;
        }

        public Privilege[] getDeclaredAggregatePrivileges() {
            return this.declaredAggregates;
        }

        public Privilege[] getAggregatePrivileges() {
            return this.aggregates;
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return this.definition.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PrivilegeImpl) {
                PrivilegeImpl other = (PrivilegeImpl)obj;
                return this.definition.equals(other.definition);
            }
            return false;
        }
    }
}

