/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.session;

import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionItemOperation<T>
implements SessionOperation<T> {
    private final String method;
    private final String path;

    public static SessionItemOperation<Boolean> itemExists(String path) {
        return new SessionItemOperation<Boolean>("itemExists", path){

            @Override
            protected Boolean perform(ItemManager manager, Path path) {
                return manager.itemExists(path);
            }
        };
    }

    public static SessionItemOperation<Boolean> propertyExists(String path) {
        return new SessionItemOperation<Boolean>("propertyExists", path){

            @Override
            protected Boolean perform(ItemManager manager, Path path) {
                return manager.propertyExists(path);
            }
        };
    }

    public static SessionItemOperation<Boolean> nodeExists(String path) {
        return new SessionItemOperation<Boolean>("nodeExists", path){

            @Override
            protected Boolean perform(ItemManager manager, Path path) {
                return manager.nodeExists(path);
            }
        };
    }

    public static SessionItemOperation<ItemImpl> getItem(String path) {
        return new SessionItemOperation<ItemImpl>("getItem", path){

            @Override
            protected ItemImpl perform(ItemManager manager, Path path) throws RepositoryException {
                return manager.getItem(path);
            }
        };
    }

    public static SessionItemOperation<PropertyImpl> getProperty(String path) {
        return new SessionItemOperation<PropertyImpl>("getProperty", path){

            @Override
            protected PropertyImpl perform(ItemManager manager, Path path) throws RepositoryException {
                return manager.getProperty(path);
            }
        };
    }

    public static SessionItemOperation<NodeImpl> getNode(String path) {
        return new SessionItemOperation<NodeImpl>("getNode", path){

            @Override
            protected NodeImpl perform(ItemManager manager, Path path) throws RepositoryException {
                return manager.getNode(path);
            }
        };
    }

    public static SessionItemOperation<Object> remove(String path) {
        return new SessionItemOperation<Object>("remove", path){

            @Override
            protected Object perform(ItemManager manager, Path path) throws RepositoryException {
                manager.getItem(path).remove();
                return this;
            }
        };
    }

    private SessionItemOperation(String method, String path) {
        this.method = method;
        this.path = path;
    }

    @Override
    public T perform(SessionContext context) throws RepositoryException {
        try {
            Path normalized = context.getQPath(this.path).getNormalizedPath();
            if (normalized.isAbsolute()) {
                return this.perform(context.getItemManager(), normalized);
            }
            throw new RepositoryException("Not an absolute path: " + this.path);
        }
        catch (AccessDeniedException e) {
            throw new PathNotFoundException(this.path);
        }
        catch (NameException e) {
            throw new RepositoryException("Invalid path:" + this.path, (Throwable)e);
        }
    }

    protected abstract T perform(ItemManager var1, Path var2) throws RepositoryException;

    public String toString() {
        return this.method + "(" + this.path + ")";
    }
}

