/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLog {
    private final Map<ItemId, ItemState> addedStates = new LinkedMap();
    private final Map<ItemId, ItemState> modifiedStates = new LinkedMap();
    private final Map<ItemId, ItemState> deletedStates = new LinkedMap();
    private final Map<NodeId, NodeReferences> modifiedRefs = new LinkedMap();

    public boolean hasUpdates() {
        return !this.addedStates.isEmpty() || !this.modifiedStates.isEmpty() || !this.deletedStates.isEmpty() || !this.modifiedRefs.isEmpty();
    }

    public void added(ItemState state) {
        this.addedStates.put(state.getId(), state);
    }

    public void modified(ItemState state) {
        if (!this.addedStates.containsKey(state.getId())) {
            state.disconnect();
            this.modifiedStates.put(state.getId(), state);
        }
    }

    public void deleted(ItemState state) {
        if (this.addedStates.remove(state.getId()) == null) {
            state.disconnect();
            this.modifiedStates.remove(state.getId());
            this.deletedStates.put(state.getId(), state);
        }
    }

    public void modified(NodeReferences refs) {
        this.modifiedRefs.put(refs.id, refs);
    }

    public void removeReferencesEntry(NodeId targetId) {
        this.modifiedRefs.remove(targetId);
    }

    public ItemState get(ItemId id) throws NoSuchItemStateException {
        ItemState state = this.addedStates.get(id);
        if (state == null && (state = this.modifiedStates.get(id)) == null && this.deletedStates.containsKey(id)) {
            throw new NoSuchItemStateException("State has been marked destroyed: " + id);
        }
        return state;
    }

    public boolean has(ItemId id) {
        return this.addedStates.containsKey(id) || this.modifiedStates.containsKey(id);
    }

    public boolean deleted(ItemId id) {
        return this.deletedStates.containsKey(id);
    }

    public boolean isModified(ItemId id) {
        return this.modifiedStates.containsKey(id);
    }

    public NodeReferences getReferencesTo(NodeId id) {
        return this.modifiedRefs.get(id);
    }

    public Iterable<ItemState> addedStates() {
        return this.addedStates.values();
    }

    public Iterable<ItemState> modifiedStates() {
        return this.modifiedStates.values();
    }

    public Iterable<ItemState> deletedStates() {
        return this.deletedStates.values();
    }

    public Iterable<NodeReferences> modifiedRefs() {
        return this.modifiedRefs.values();
    }

    public void merge(ChangeLog other) {
        for (ItemState state : other.deletedStates()) {
            if (this.addedStates.remove(state.getId()) == null) {
                this.deletedStates.put(state.getId(), state);
            }
            this.modifiedStates.remove(state.getId());
        }
        for (ItemState state : other.modifiedStates()) {
            if (!this.addedStates.containsKey(state.getId())) {
                this.modifiedStates.put(state.getId(), state);
                continue;
            }
            state.setStatus(4);
            this.addedStates.put(state.getId(), state);
        }
        for (ItemState state : other.addedStates()) {
            this.addedStates.put(state.getId(), state);
        }
        this.modifiedRefs.putAll(other.modifiedRefs);
    }

    public void push() {
        for (ItemState state : this.modifiedStates()) {
            state.push();
        }
        for (ItemState state : this.deletedStates()) {
            state.push();
        }
        for (ItemState state : this.addedStates()) {
            state.push();
        }
    }

    public void persisted() {
        for (ItemState state : this.modifiedStates()) {
            state.setStatus(1);
            state.notifyStateUpdated();
        }
        for (ItemState state : this.deletedStates()) {
            state.setStatus(3);
            state.notifyStateDestroyed();
            state.discard();
        }
        for (ItemState state : this.addedStates()) {
            state.setStatus(1);
            state.notifyStateCreated();
        }
    }

    public void reset() {
        this.addedStates.clear();
        this.modifiedStates.clear();
        this.deletedStates.clear();
        this.modifiedRefs.clear();
    }

    public void disconnect() {
        for (ItemState state : this.modifiedStates()) {
            state.disconnect();
        }
        for (ItemState state : this.deletedStates()) {
            state.disconnect();
        }
        for (ItemState state : this.addedStates()) {
            state.disconnect();
        }
    }

    public void undo(ItemStateManager parent) {
        for (ItemState state : this.modifiedStates()) {
            try {
                state.connect(parent.getItemState(state.getId()));
                state.pull();
            }
            catch (ItemStateException e) {
                state.discard();
            }
        }
        for (ItemState state : this.deletedStates()) {
            try {
                state.connect(parent.getItemState(state.getId()));
                state.pull();
            }
            catch (ItemStateException e) {
                state.discard();
            }
        }
        for (ItemState state : this.addedStates()) {
            state.discard();
        }
        this.reset();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("#addedStates=").append(this.addedStates.size());
        buf.append(", #modifiedStates=").append(this.modifiedStates.size());
        buf.append(", #deletedStates=").append(this.deletedStates.size());
        buf.append(", #modifiedRefs=").append(this.modifiedRefs.size());
        buf.append("}");
        return buf.toString();
    }
}

