/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeReferences
implements Serializable {
    static final long serialVersionUID = 7007727035982680717L;
    protected NodeId id;
    protected ArrayList<PropertyId> references = new ArrayList();

    public NodeReferences(NodeId id) {
        this.id = id;
    }

    public NodeId getTargetId() {
        return this.id;
    }

    public boolean hasReferences() {
        return !this.references.isEmpty();
    }

    public List<PropertyId> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public void addReference(PropertyId refId) {
        this.references.add(refId);
    }

    public void addAllReferences(List<PropertyId> references) {
        this.references.addAll(references);
    }

    public boolean removeReference(PropertyId refId) {
        return this.references.remove(refId);
    }

    public void clearAllReferences() {
        this.references.clear();
    }

    public String toString() {
        return "references to " + this.id;
    }
}

