/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.MergeException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalActivity;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionManagerImplBase;
import org.apache.jackrabbit.core.version.VersionManagerImplRestore;
import org.apache.jackrabbit.core.version.VersionSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VersionManagerImplMerge
extends VersionManagerImplRestore {
    private static final Logger log = LoggerFactory.getLogger(VersionManagerImplMerge.class);

    protected VersionManagerImplMerge(SessionContext context, UpdatableItemStateManager stateMgr, HierarchyManager hierMgr) {
        super(context, stateMgr, hierMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void merge(NodeStateEx state, NodeStateEx srcRoot, List<ItemId> failedIds, boolean bestEffort, boolean shallow) throws RepositoryException, ItemStateException {
        if (shallow && !state.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE)) {
            return;
        }
        NodeStateEx srcNode = this.getCorrespondingNode(state, srcRoot);
        if (srcNode == null) {
            return;
        }
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            this.internalMerge(state, srcRoot, failedIds, bestEffort, shallow);
            state.store();
            ops.save();
        }
        finally {
            ops.close();
        }
    }

    private void internalMerge(NodeStateEx state, NodeStateEx srcRoot, List<ItemId> failedIds, boolean bestEffort, boolean shallow) throws RepositoryException, ItemStateException {
        NodeStateEx srcNode = this.doMergeTest(state, srcRoot, failedIds, bestEffort);
        if (srcNode == null) {
            if (!shallow) {
                for (NodeStateEx n : state.getChildNodes()) {
                    if (!n.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE)) continue;
                    this.internalMerge(n, srcRoot, failedIds, bestEffort, shallow);
                }
            }
            return;
        }
        this.checkModify(state, 130, 0);
        for (PropertyState prop : state.getProperties()) {
            if (srcNode.hasProperty(prop.getName())) continue;
            state.removeProperty(prop.getName());
        }
        for (PropertyState prop : srcNode.getProperties()) {
            Name propName = prop.getName();
            if (propName.equals(NameConstants.JCR_PRIMARYTYPE) || propName.equals(NameConstants.JCR_MIXINTYPES) || propName.equals(NameConstants.JCR_UUID)) continue;
            state.copyFrom(prop);
        }
        state.setMixins(srcNode.getState().getMixinTypeNames());
        LinkedList<ChildNodeEntry> toDelete = new LinkedList<ChildNodeEntry>();
        for (ChildNodeEntry entry : state.getState().getChildNodeEntries()) {
            if (srcNode.getState().hasChildNodeEntry(entry.getName(), entry.getIndex())) continue;
            toDelete.add(entry);
        }
        for (ChildNodeEntry entry : toDelete) {
            state.removeNode(entry.getName(), entry.getIndex());
        }
        state.store();
        for (ChildNodeEntry entry : srcNode.getState().getChildNodeEntries()) {
            NodeStateEx child = state.getNode(entry.getName(), entry.getIndex());
            if (child == null) {
                if (state.hasNode(entry.getId())) {
                    child = state.getNode(entry.getId());
                    NodeStateEx parent = child.getParent();
                    parent.removeNode(child);
                    parent.store();
                }
                NodeStateEx srcChild = srcNode.getNode(entry.getId());
                child = state.addNode(entry.getName(), srcChild.getState().getNodeTypeName(), srcChild.getNodeId());
                child.setMixins(srcChild.getState().getMixinTypeNames());
                state.store();
                this.internalMerge(child, srcRoot, null, bestEffort, false);
                continue;
            }
            if (shallow) continue;
            this.internalMerge(child, srcRoot, failedIds, bestEffort, false);
        }
    }

    private NodeStateEx getCorrespondingNode(NodeStateEx state, NodeStateEx srcRoot) throws RepositoryException {
        NodeStateEx m1 = state;
        LinkedList<ChildNodeEntry> elements = new LinkedList<ChildNodeEntry>();
        while (m1.getParentId() != null && !m1.getEffectiveNodeType().includesNodeType(NameConstants.MIX_REFERENCEABLE)) {
            NodeStateEx parent = m1.getParent();
            elements.addFirst(parent.getState().getChildNodeEntry(m1.getNodeId()));
            m1 = parent;
        }
        if (srcRoot.hasNode(m1.getNodeId())) {
            ChildNodeEntry e;
            NodeStateEx m2;
            Iterator iter = elements.iterator();
            for (m2 = srcRoot.getNode(m1.getNodeId()); iter.hasNext() && m2 != null; m2 = m2.getNode(e.getName(), e.getIndex())) {
                e = (ChildNodeEntry)iter.next();
            }
            return m2;
        }
        return null;
    }

    private NodeStateEx doMergeTest(NodeStateEx state, NodeStateEx srcRoot, List<ItemId> failedIds, boolean bestEffort) throws RepositoryException, AccessDeniedException {
        NodeStateEx srcNode = this.getCorrespondingNode(state, srcRoot);
        if (srcNode == null) {
            return null;
        }
        if (!state.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE) || failedIds == null) {
            return srcNode;
        }
        if (!srcNode.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE)) {
            return null;
        }
        InternalVersion v = this.getBaseVersion(state);
        InternalVersion vp = this.getBaseVersion(srcNode);
        if (!this.isCheckedOut(state)) {
            if (vp.isMoreRecent(v)) {
                return srcNode;
            }
            if (v.equals(vp) || v.isMoreRecent(vp)) {
                return null;
            }
        } else if (v.equals(vp) || v.isMoreRecent(vp)) {
            return null;
        }
        if (vp.isMoreRecent(v) && !this.isCheckedOut(state)) {
            return srcNode;
        }
        if (v.equals(vp) || v.isMoreRecent(vp)) {
            return null;
        }
        if (bestEffort) {
            Set<NodeId> set = this.getMergeFailed(state);
            set.add(vp.getId());
            this.setMergeFailed(state, set);
            failedIds.add(state.getNodeId());
            state.store();
            return null;
        }
        String msg = "Unable to merge nodes. Violating versions. " + this.safeGetJCRPath(state);
        log.debug(msg);
        throw new MergeException(msg);
    }

    protected void finishMerge(NodeStateEx state, Version version, boolean cancel) throws RepositoryException {
        NodeId versionId;
        if (!this.checkVersionable(state)) {
            throw new UnsupportedRepositoryOperationException("Node not full versionable: " + this.safeGetJCRPath(state));
        }
        Set<NodeId> failed = this.getMergeFailed(state);
        if (!failed.remove(versionId = ((VersionImpl)version).getNodeId())) {
            String msg = "Unable to finish merge. Specified version is not in jcr:mergeFailed property: " + this.safeGetJCRPath(state);
            log.error(msg);
            throw new VersionException(msg);
        }
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            this.setMergeFailed(state, failed);
            if (!cancel) {
                InternalValue[] vals = state.getPropertyValues(NameConstants.JCR_PREDECESSORS);
                InternalValue[] v = new InternalValue[vals.length + 1];
                for (int i = 0; i < vals.length; ++i) {
                    v[i] = InternalValue.create(vals[i].getNodeId());
                }
                v[vals.length] = InternalValue.create(versionId);
                state.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, v, true);
            }
            state.store();
            ops.save();
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            ops.close();
        }
    }

    private Set<NodeId> getMergeFailed(NodeStateEx state) throws RepositoryException {
        HashSet<NodeId> set = new HashSet<NodeId>();
        if (state.hasProperty(NameConstants.JCR_MERGEFAILED)) {
            InternalValue[] vals;
            for (InternalValue val : vals = state.getPropertyValues(NameConstants.JCR_MERGEFAILED)) {
                set.add(val.getNodeId());
            }
        }
        return set;
    }

    private void setMergeFailed(NodeStateEx state, Set<NodeId> set) throws RepositoryException {
        if (set.isEmpty()) {
            state.removeProperty(NameConstants.JCR_MERGEFAILED);
        } else {
            InternalValue[] vals = new InternalValue[set.size()];
            Iterator<NodeId> iter = set.iterator();
            int i = 0;
            while (iter.hasNext()) {
                NodeId id = iter.next();
                vals[i++] = InternalValue.create(id);
            }
            state.setPropertyValues(NameConstants.JCR_MERGEFAILED, 9, vals, true);
        }
    }

    protected void merge(InternalActivity activity, List<ItemId> failedIds) throws RepositoryException {
        VersionSet changeSet = activity.getChangeSet();
        VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();
        try {
            Iterator<NodeId> iter = changeSet.versions().keySet().iterator();
            while (iter.hasNext()) {
                InternalVersion v = changeSet.versions().remove(iter.next());
                NodeStateEx state = this.getNodeStateEx(v.getFrozenNode().getFrozenId());
                if (state != null) {
                    InternalVersion base = this.getBaseVersion(state);
                    if (base.isMoreRecent(v)) {
                        failedIds.add(state.getNodeId());
                        Set<NodeId> set = this.getMergeFailed(state);
                        set.add(base.getId());
                        this.setMergeFailed(state, set);
                        state.store();
                    } else {
                        for (InternalVersion restored : this.internalRestore(state, v, changeSet, true)) {
                            changeSet.versions().remove(restored.getVersionHistory().getId());
                        }
                    }
                }
                iter = changeSet.versions().keySet().iterator();
            }
            ops.save();
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            ops.close();
        }
    }
}

