/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.apache.jackrabbit.core.query.QueryFactory;

public class CompoundQueryFactory
implements QueryFactory {
    private List<QueryFactory> factories = new ArrayList<QueryFactory>();

    public CompoundQueryFactory(List<QueryFactory> factories) {
        this.factories.addAll(factories);
    }

    @Override
    public List<String> getSupportedLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        for (QueryFactory factory : this.factories) {
            for (String lang : factory.getSupportedLanguages()) {
                languages.add(lang);
            }
        }
        return languages;
    }

    @Override
    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        for (QueryFactory factory : this.factories) {
            if (!factory.getSupportedLanguages().contains(language)) continue;
            return factory.createQuery(statement, language);
        }
        throw new InvalidQueryException("Unsupported language: " + language);
    }
}

