/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.virtual.VirtualNodeTypeStateProvider;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualNodeTypeStateManager
implements NodeTypeRegistryListener {
    private static Logger log = LoggerFactory.getLogger(VirtualNodeTypeStateManager.class);
    private static final Path NODE_TYPES_PATH;
    private VirtualNodeTypeStateProvider virtProvider;
    private final NodeTypeRegistry ntReg;
    private final NodeId rootNodeId;
    private final NodeId parentId;
    private SessionImpl systemSession;
    private DelegatingObservationDispatcher obsDispatcher;

    public VirtualNodeTypeStateManager(NodeTypeRegistry ntReg, DelegatingObservationDispatcher obs, NodeId rootNodeId, NodeId parentId) {
        this.ntReg = ntReg;
        this.obsDispatcher = obs;
        this.rootNodeId = rootNodeId;
        this.parentId = parentId;
        ntReg.addListener(this);
    }

    public synchronized VirtualItemStateProvider getVirtualItemStateProvider() {
        if (this.virtProvider == null) {
            this.virtProvider = new VirtualNodeTypeStateProvider(this.ntReg, this.rootNodeId, this.parentId);
        }
        return this.virtProvider;
    }

    public void setSession(SessionImpl systemSession) {
        this.systemSession = systemSession;
    }

    @Override
    public void nodeTypeRegistered(Name ntName) {
        try {
            if (this.virtProvider != null) {
                this.virtProvider.onNodeTypeAdded(ntName);
            }
            if (this.systemSession != null) {
                NodeImpl root = (NodeImpl)this.systemSession.getItemManager().getItem(this.rootNodeId);
                NodeImpl child = root.getNode(ntName);
                ArrayList<EventState> events = new ArrayList<EventState>();
                this.recursiveAdd(events, root, child);
                this.obsDispatcher.dispatch(events, this.systemSession, NODE_TYPES_PATH, null);
            }
        }
        catch (RepositoryException e) {
            log.error("Unable to index new nodetype: " + e.toString());
        }
    }

    @Override
    public void nodeTypeReRegistered(Name ntName) {
        this.nodeTypesUnregistered(Collections.singleton(ntName));
        this.nodeTypeRegistered(ntName);
    }

    @Override
    public void nodeTypesUnregistered(Collection<Name> names) {
        try {
            if (this.systemSession != null) {
                ArrayList<EventState> events = new ArrayList<EventState>();
                NodeImpl root = (NodeImpl)this.systemSession.getItemManager().getItem(this.rootNodeId);
                for (Name name : names) {
                    NodeImpl child = root.getNode(name);
                    this.recursiveRemove(events, root, child);
                }
                this.obsDispatcher.dispatch(events, this.systemSession, NODE_TYPES_PATH, null);
            }
            if (this.virtProvider != null) {
                this.virtProvider.onNodeTypesRemoved(names);
            }
        }
        catch (RepositoryException e) {
            log.error("Unable to index removed nodetypes: " + names, (Throwable)e);
        }
    }

    private void recursiveAdd(List<EventState> events, NodeImpl parent, NodeImpl node) throws RepositoryException {
        events.add(EventState.childNodeAdded(parent.getNodeId(), parent.getPrimaryPath(), node.getNodeId(), node.getPrimaryPath().getLastElement(), ((NodeTypeImpl)parent.getPrimaryNodeType()).getQName(), parent.getMixinTypeNames(), node.getSession()));
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            PropertyImpl prop = (PropertyImpl)iter.nextProperty();
            events.add(EventState.propertyAdded((NodeId)node.getId(), node.getPrimaryPath(), prop.getPrimaryPath().getLastElement(), ((NodeTypeImpl)node.getPrimaryNodeType()).getQName(), node.getMixinTypeNames(), node.getSession()));
        }
        NodeIterator niter = node.getNodes();
        while (niter.hasNext()) {
            NodeImpl n = (NodeImpl)niter.nextNode();
            this.recursiveAdd(events, node, n);
        }
    }

    private void recursiveRemove(List<EventState> events, NodeImpl parent, NodeImpl node) throws RepositoryException {
        events.add(EventState.childNodeRemoved(parent.getNodeId(), parent.getPrimaryPath(), node.getNodeId(), node.getPrimaryPath().getLastElement(), ((NodeTypeImpl)parent.getPrimaryNodeType()).getQName(), parent.getMixinTypeNames(), node.getSession()));
        NodeIterator niter = node.getNodes();
        while (niter.hasNext()) {
            NodeImpl n = (NodeImpl)niter.nextNode();
            this.recursiveRemove(events, node, n);
        }
    }

    static {
        try {
            PathBuilder builder = new PathBuilder();
            builder.addRoot();
            builder.addLast(NameConstants.JCR_SYSTEM);
            builder.addLast(NameConstants.JCR_NODETYPES);
            NODE_TYPES_PATH = builder.getPath();
        }
        catch (MalformedPathException e) {
            throw new InternalError("Cannot initialize path");
        }
    }
}

