/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.jackrabbit.core.data.AsyncUploadCache;
import org.apache.jackrabbit.core.data.AsyncUploadCacheResult;
import org.apache.jackrabbit.core.data.LocalCache;
import org.apache.jackrabbit.core.fs.local.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocalCache
extends TestCase {
    private static final String CACHE_DIR = "target/cache";
    private static final String TEMP_DIR = "target/temp";
    private static final String TARGET_DIR = "target";
    private static final Logger LOG = LoggerFactory.getLogger(TestLocalCache.class);

    protected void setUp() {
        try {
            File cachedir = new File(CACHE_DIR);
            if (cachedir.exists()) {
                FileUtil.delete((File)cachedir);
            }
            cachedir.mkdirs();
            File tempdir = new File(TEMP_DIR);
            if (tempdir.exists()) {
                FileUtil.delete((File)tempdir);
            }
            tempdir.mkdirs();
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestLocalCache.fail();
        }
    }

    protected void tearDown() throws IOException {
        File tempdir;
        File cachedir = new File(CACHE_DIR);
        if (cachedir.exists()) {
            FileUtil.delete((File)cachedir);
        }
        if ((tempdir = new File(TEMP_DIR)).exists()) {
            FileUtil.delete((File)tempdir);
        }
    }

    public void testStoreRetrieve() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(TARGET_DIR, CACHE_DIR, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(CACHE_DIR, TEMP_DIR, 400L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            byte[] data = new byte[100];
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>();
            random.nextBytes(data);
            byteMap.put("a1", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a2", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a3", data);
            cache.store("a1", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a1")));
            cache.store("a2", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a2")));
            cache.store("a3", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a3")));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), cache.getIfStored("a1"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), cache.getIfStored("a2"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), cache.getIfStored("a3"));
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestLocalCache.fail();
        }
    }

    public void testAutoPurge() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(TARGET_DIR, CACHE_DIR, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(CACHE_DIR, TEMP_DIR, 400L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            byte[] data = new byte[100];
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>();
            random.nextBytes(data);
            byteMap.put("a1", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a2", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a3", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a4", data);
            cache.store("a1", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a1")));
            cache.store("a2", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a2")));
            cache.store("a3", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a3")));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), cache.getIfStored("a1"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), cache.getIfStored("a2"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), cache.getIfStored("a3"));
            data = new byte[90];
            random.nextBytes(data);
            byteMap.put("a4", data);
            cache.store("a4", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a4")));
            Thread.sleep(1000L);
            TestLocalCache.assertNull((String)"a1 should be null", (Object)cache.getIfStored("a1"));
            TestLocalCache.assertNull((String)"a2 should be null", (Object)cache.getIfStored("a2"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), cache.getIfStored("a3"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a4")), cache.getIfStored("a4"));
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a5", data);
            cache.store("a5", (InputStream)new ByteArrayInputStream((byte[])byteMap.get("a5")));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), cache.getIfStored("a3"));
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestLocalCache.fail();
        }
    }

    public void testAutoPurgeWithPendingUpload() {
        try {
            AsyncUploadCache pendingFiles = new AsyncUploadCache();
            pendingFiles.init(TARGET_DIR, CACHE_DIR, 100);
            pendingFiles.reset();
            LocalCache cache = new LocalCache(CACHE_DIR, TEMP_DIR, 400L, 0.95, 0.7, pendingFiles);
            Random random = new Random(12345L);
            byte[] data = new byte[125];
            HashMap<String, byte[]> byteMap = new HashMap<String, byte[]>();
            random.nextBytes(data);
            byteMap.put("a1", data);
            data = new byte[125];
            random.nextBytes(data);
            byteMap.put("a2", data);
            data = new byte[125];
            random.nextBytes(data);
            byteMap.put("a3", data);
            data = new byte[100];
            random.nextBytes(data);
            byteMap.put("a4", data);
            File tempDir = new File(TEMP_DIR);
            File f = File.createTempFile("test", "tmp", tempDir);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a1"));
            fos.close();
            AsyncUploadCacheResult result = cache.store("a1", f, true);
            TestLocalCache.assertTrue((String)"should be able to add to pending upload", (boolean)result.canAsyncUpload());
            f = File.createTempFile("test", "tmp", tempDir);
            fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a2"));
            fos.close();
            result = cache.store("a2", f, true);
            TestLocalCache.assertTrue((String)"should be able to add to pending upload", (boolean)result.canAsyncUpload());
            f = File.createTempFile("test", "tmp", tempDir);
            fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a3"));
            fos.close();
            result = cache.store("a3", f, true);
            TestLocalCache.assertTrue((String)"should be able to add to pending upload", (boolean)result.canAsyncUpload());
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), cache.getIfStored("a1"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), cache.getIfStored("a2"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), cache.getIfStored("a3"));
            data = new byte[90];
            random.nextBytes(data);
            byteMap.put("a4", data);
            f = File.createTempFile("test", "tmp", tempDir);
            fos = new FileOutputStream(f);
            fos.write((byte[])byteMap.get("a4"));
            fos.close();
            result = cache.store("a4", f, true);
            TestLocalCache.assertFalse((String)"should not be able to add to pending upload", (boolean)result.canAsyncUpload());
            Thread.sleep(1000L);
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a1")), cache.getIfStored("a1"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a2")), cache.getIfStored("a2"));
            this.assertEquals(new ByteArrayInputStream((byte[])byteMap.get("a3")), cache.getIfStored("a3"));
            TestLocalCache.assertNull((String)"a4 should be null", (Object)cache.getIfStored("a4"));
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestLocalCache.fail();
        }
    }

    protected void assertEquals(InputStream a, InputStream b) throws IOException {
        int ai;
        do {
            ai = a.read();
            int bi = b.read();
            TestLocalCache.assertEquals((int)ai, (int)bi);
        } while (ai >= 0);
    }
}

