/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.XASession;
import org.apache.jackrabbit.jca.AnonymousConnection;
import org.apache.jackrabbit.jca.JCAConnectionManager;
import org.apache.jackrabbit.jca.JCAConnectionRequestInfo;
import org.apache.jackrabbit.jca.JCAManagedConnection;
import org.apache.jackrabbit.jca.JCARepositoryHandle;
import org.apache.jackrabbit.jca.JCARepositoryManager;

public final class JCAManagedConnectionFactory
implements ManagedConnectionFactory {
    private final Map<String, String> parameters = new HashMap<String, String>();
    private Boolean bindSessionToTransaction = Boolean.TRUE;
    private transient Repository repository;
    private transient PrintWriter logWriter;

    public String getRepositoryURI() {
        return this.parameters.get("org.apache.jackrabbit.repository.uri");
    }

    public void setRepositoryURI(String uri) {
        this.parameters.put("org.apache.jackrabbit.repository.uri", uri);
    }

    public String getHomeDir() {
        return this.parameters.get("org.apache.jackrabbit.repository.home");
    }

    public void setHomeDir(String home) {
        this.parameters.put("org.apache.jackrabbit.repository.home", home);
    }

    public String getConfigFile() {
        return this.parameters.get("org.apache.jackrabbit.repository.conf");
    }

    public void setConfigFile(String conf) {
        this.parameters.put("org.apache.jackrabbit.repository.conf", conf);
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(new JCAConnectionManager());
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        this.createRepository();
        JCARepositoryHandle handle = new JCARepositoryHandle(this, cm);
        this.log("Created repository handle (" + handle + ")");
        return handle;
    }

    private XASession openSession(JCAConnectionRequestInfo cri) throws ResourceException {
        this.createRepository();
        Credentials creds = cri.getCredentials();
        String workspace = cri.getWorkspace();
        try {
            Session session = this.getRepository().login(creds, workspace);
            this.log("Created session (" + session + ")");
            return (XASession)session;
        }
        catch (RepositoryException e) {
            this.log("Failed to create session", e);
            ResourceException exception = new ResourceException("Failed to create session: " + e.getMessage());
            exception.setLinkedException((Exception)((Object)e));
            throw exception;
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri == null) {
            return new AnonymousConnection();
        }
        return this.createManagedConnection((JCAConnectionRequestInfo)cri);
    }

    private ManagedConnection createManagedConnection(JCAConnectionRequestInfo cri) throws ResourceException {
        return new JCAManagedConnection(this, cri, this.openSession(cri));
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        for (Object connection : set) {
            JCAConnectionRequestInfo otherCri;
            JCAManagedConnection mc;
            if (!(connection instanceof JCAManagedConnection) || !this.equals((mc = (JCAManagedConnection)connection).getManagedConnectionFactory()) || cri != (otherCri = mc.getConnectionRequestInfo()) && (cri == null || !cri.equals(otherCri))) continue;
            return mc;
        }
        return null;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void log(String message) {
        this.log(message, null);
    }

    public void log(String message, Throwable exception) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
            if (exception != null) {
                exception.printStackTrace(this.logWriter);
            }
        }
    }

    public int hashCode() {
        return ((Object)this.parameters).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JCAManagedConnectionFactory) {
            return this.equals((JCAManagedConnectionFactory)o);
        }
        return false;
    }

    private boolean equals(JCAManagedConnectionFactory o) {
        return ((Object)this.parameters).equals(o.parameters);
    }

    private void createRepository() throws ResourceException {
        if (this.repository == null) {
            try {
                JCARepositoryManager mgr = JCARepositoryManager.getInstance();
                this.repository = mgr.createRepository(this.parameters);
                this.log("Created repository (" + this.repository + ")");
            }
            catch (RepositoryException e) {
                this.log("Failed to create repository", e);
                ResourceException exception = new ResourceException("Failed to create session: " + e.getMessage());
                exception.setLinkedException((Exception)((Object)e));
                throw exception;
            }
        }
    }

    protected void finalize() {
        JCARepositoryManager mgr = JCARepositoryManager.getInstance();
        mgr.autoShutdownRepository(this.parameters);
    }

    public Boolean getBindSessionToTransaction() {
        return this.bindSessionToTransaction;
    }

    public void setBindSessionToTransaction(Boolean bindSessionToTransaction) {
        this.bindSessionToTransaction = bindSessionToTransaction;
    }
}

