/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.jackrabbit.commons.repository.ProxyRepository;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;
import org.apache.jackrabbit.jca.JCAConnectionRequestInfo;
import org.apache.jackrabbit.jca.JCAManagedConnectionFactory;

public final class JCARepositoryHandle
extends ProxyRepository
implements Referenceable,
Serializable {
    private final JCAManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private Reference reference;

    public JCARepositoryHandle(JCAManagedConnectionFactory mcf, ConnectionManager cm) {
        super((RepositoryFactory)new JCARepositoryFactory(mcf));
        this.mcf = mcf;
        this.cm = cm;
    }

    public Session login(Credentials creds, String workspace) throws RepositoryException {
        try {
            return (Session)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)new JCAConnectionRequestInfo(creds, workspace));
        }
        catch (ResourceException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e.getLinkedException();
            }
            if (cause instanceof LoginException) {
                throw (LoginException)cause;
            }
            if (cause instanceof NoSuchWorkspaceException) {
                throw (NoSuchWorkspaceException)cause;
            }
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            if (cause != null) {
                throw new RepositoryException(cause);
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    private static class JCARepositoryFactory
    implements RepositoryFactory,
    Serializable {
        private final JCAManagedConnectionFactory mcf;

        public JCARepositoryFactory(JCAManagedConnectionFactory mcf) {
            this.mcf = mcf;
        }

        public Repository getRepository() {
            return this.mcf.getRepository();
        }
    }
}

