/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons.query.sql2;

import java.util.Arrays;
import java.util.BitSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelConstants;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;

public class QOMFormatter
implements QueryObjectModelConstants {
    private static final BitSet IDENTIFIER_START;
    private static final BitSet IDENTIFIER_PART_OR_UNDERSCORE;
    private final QueryObjectModel qom;
    private final StringBuilder sb = new StringBuilder();

    private QOMFormatter(QueryObjectModel qom) {
        this.qom = qom;
    }

    public static String format(QueryObjectModel qom) throws RepositoryException {
        return new QOMFormatter(qom).format();
    }

    private String format() throws RepositoryException {
        Ordering[] orderings;
        this.sb.append("SELECT");
        this.ws();
        this.format(this.qom.getColumns());
        this.ws();
        this.sb.append("FROM");
        this.ws();
        this.format(this.qom.getSource());
        Constraint c = this.qom.getConstraint();
        if (c != null) {
            this.ws();
            this.sb.append("WHERE");
            this.ws();
            this.format(c);
        }
        if ((orderings = this.qom.getOrderings()).length > 0) {
            this.ws();
            this.sb.append("ORDER BY");
            this.ws();
            this.format(orderings);
        }
        return this.sb.toString();
    }

    private void format(Ordering[] orderings) {
        String comma = "";
        for (Ordering ordering : orderings) {
            this.sb.append(comma);
            comma = ", ";
            this.format(ordering.getOperand());
            if (!"jcr.order.descending".equals(ordering.getOrder())) continue;
            this.ws();
            this.sb.append("DESC");
        }
    }

    private void format(Constraint c) throws RepositoryException {
        if (c instanceof And) {
            this.format((And)c);
        } else if (c instanceof ChildNode) {
            this.format((ChildNode)c);
        } else if (c instanceof Comparison) {
            this.format((Comparison)c);
        } else if (c instanceof DescendantNode) {
            this.format((DescendantNode)c);
        } else if (c instanceof FullTextSearch) {
            this.format((FullTextSearch)c);
        } else if (c instanceof Not) {
            this.format((Not)c);
        } else if (c instanceof Or) {
            this.format((Or)c);
        } else if (c instanceof PropertyExistence) {
            this.format((PropertyExistence)c);
        } else {
            this.format((SameNode)c);
        }
    }

    private void format(And constraint) throws RepositoryException {
        String and = "";
        for (Constraint c : Arrays.asList(constraint.getConstraint1(), constraint.getConstraint2())) {
            this.sb.append(and);
            and = " AND ";
            boolean paren = c instanceof Or;
            if (paren) {
                this.sb.append("(");
            }
            this.format(c);
            if (!paren) continue;
            this.sb.append(")");
        }
    }

    private void format(ChildNode constraint) {
        this.sb.append("ISCHILDNODE(");
        this.formatName(constraint.getSelectorName());
        this.sb.append(",");
        this.ws();
        this.formatPath(constraint.getParentPath());
        this.sb.append(")");
    }

    private void format(Comparison constraint) throws RepositoryException {
        this.format(constraint.getOperand1());
        this.ws();
        this.formatOperator(constraint.getOperator());
        this.ws();
        this.format(constraint.getOperand2());
    }

    private void format(StaticOperand operand) throws RepositoryException {
        if (operand instanceof BindVariableValue) {
            this.format((BindVariableValue)operand);
        } else {
            this.format((Literal)operand);
        }
    }

    private void format(BindVariableValue value) {
        this.sb.append("$");
        this.sb.append(value.getBindVariableName());
    }

    private void format(Literal value) throws RepositoryException {
        Value v = value.getLiteralValue();
        switch (v.getType()) {
            case 2: {
                this.formatCastLiteral(v.getString(), "BINARY");
                break;
            }
            case 6: {
                this.sb.append(v.getString());
                break;
            }
            case 5: {
                this.formatCastLiteral(v.getString(), "DATE");
                break;
            }
            case 12: {
                this.sb.append(v.getString());
                break;
            }
            case 4: {
                this.sb.append(v.getString());
                break;
            }
            case 3: {
                this.sb.append(v.getString());
                break;
            }
            case 7: {
                this.formatCastLiteral(v.getString(), "NAME");
                break;
            }
            case 8: {
                this.formatCastLiteral(v.getString(), "PATH");
                break;
            }
            case 9: {
                this.formatCastLiteral(v.getString(), "REFERENCE");
                break;
            }
            case 1: {
                this.formatStringLiteral(v.getString());
                break;
            }
            case 11: {
                this.formatCastLiteral(v.getString(), "URI");
                break;
            }
            case 10: {
                this.formatCastLiteral(v.getString(), "WEAKREFERENCE");
            }
        }
    }

    private void formatCastLiteral(String value, String propertyType) {
        this.sb.append("CAST(");
        this.formatStringLiteral(value);
        this.ws();
        this.sb.append("AS");
        this.ws();
        this.sb.append(propertyType);
        this.sb.append(")");
    }

    private void formatStringLiteral(String value) {
        this.sb.append("'");
        this.sb.append(value.replaceAll("'", "''"));
        this.sb.append("'");
    }

    private void formatOperator(String operator) {
        if ("jcr.operator.equal.to".equals(operator)) {
            this.sb.append("=");
        } else if ("jcr.operator.greater.than".equals(operator)) {
            this.sb.append(">");
        } else if ("jcr.operator.greater.than.or.equal.to".equals(operator)) {
            this.sb.append(">=");
        } else if ("jcr.operator.less.than".equals(operator)) {
            this.sb.append("<");
        } else if ("jcr.operator.less.than.or.equal.to".equals(operator)) {
            this.sb.append("<=");
        } else if ("jcr.operator.like".equals(operator)) {
            this.sb.append("LIKE");
        } else {
            this.sb.append("<>");
        }
    }

    private void format(DynamicOperand operand) {
        if (operand instanceof FullTextSearchScore) {
            this.format((FullTextSearchScore)operand);
        } else if (operand instanceof Length) {
            this.format((Length)operand);
        } else if (operand instanceof LowerCase) {
            this.format((LowerCase)operand);
        } else if (operand instanceof NodeLocalName) {
            this.format((NodeLocalName)operand);
        } else if (operand instanceof NodeName) {
            this.format((NodeName)operand);
        } else if (operand instanceof PropertyValue) {
            this.format((PropertyValue)operand);
        } else {
            this.format((UpperCase)operand);
        }
    }

    private void format(FullTextSearchScore operand) {
        this.sb.append("SCORE(");
        this.formatName(operand.getSelectorName());
        this.sb.append(")");
    }

    private void format(Length operand) {
        this.sb.append("LENGTH(");
        this.format(operand.getPropertyValue());
        this.sb.append(")");
    }

    private void format(LowerCase operand) {
        this.sb.append("LOWER(");
        this.format(operand.getOperand());
        this.sb.append(")");
    }

    private void format(NodeLocalName operand) {
        this.sb.append("LOCALNAME(");
        this.formatName(operand.getSelectorName());
        this.sb.append(")");
    }

    private void format(NodeName operand) {
        this.sb.append("NAME(");
        this.formatName(operand.getSelectorName());
        this.sb.append(")");
    }

    private void format(PropertyValue operand) {
        this.formatName(operand.getSelectorName());
        this.sb.append(".");
        this.formatName(operand.getPropertyName());
    }

    private void format(UpperCase operand) {
        this.sb.append("UPPER(");
        this.format(operand.getOperand());
        this.sb.append(")");
    }

    private void format(DescendantNode constraint) {
        this.sb.append("ISDESCENDANTNODE(");
        this.formatName(constraint.getSelectorName());
        this.sb.append(",");
        this.ws();
        this.formatPath(constraint.getAncestorPath());
        this.sb.append(")");
    }

    private void format(FullTextSearch constraint) throws RepositoryException {
        this.sb.append("CONTAINS(");
        this.formatName(constraint.getSelectorName());
        this.sb.append(".");
        String propName = constraint.getPropertyName();
        if (propName == null) {
            this.sb.append("*");
        } else {
            this.formatName(propName);
        }
        this.sb.append(",");
        this.ws();
        this.format(constraint.getFullTextSearchExpression());
        this.sb.append(")");
    }

    private void format(Not constraint) throws RepositoryException {
        boolean paren;
        this.sb.append("NOT");
        this.ws();
        Constraint c = constraint.getConstraint();
        boolean bl = paren = c instanceof And || c instanceof Or;
        if (paren) {
            this.sb.append("(");
        }
        this.format(c);
        if (paren) {
            this.sb.append(")");
        }
    }

    private void format(Or constraint) throws RepositoryException {
        this.format(constraint.getConstraint1());
        this.ws();
        this.sb.append("OR");
        this.ws();
        this.format(constraint.getConstraint2());
    }

    private void format(PropertyExistence constraint) {
        this.formatName(constraint.getSelectorName());
        this.sb.append(".");
        this.formatName(constraint.getPropertyName());
        this.ws();
        this.sb.append("IS NOT NULL");
    }

    private void format(SameNode constraint) {
        this.sb.append("ISSAMENODE(");
        this.formatName(constraint.getSelectorName());
        this.sb.append(",");
        this.ws();
        this.formatPath(constraint.getPath());
        this.sb.append(")");
    }

    private void format(Column[] columns) {
        if (columns.length == 0) {
            this.sb.append("*");
        } else {
            String comma = "";
            for (Column c : columns) {
                this.sb.append(comma);
                comma = ", ";
                this.formatName(c.getSelectorName());
                this.sb.append(".");
                String propName = c.getPropertyName();
                if (propName != null) {
                    this.formatName(propName);
                    this.ws();
                    this.sb.append("AS");
                    this.ws();
                    this.formatName(c.getColumnName());
                    continue;
                }
                this.sb.append("*");
            }
        }
    }

    private void format(Source source) {
        if (source instanceof Join) {
            this.format((Join)source);
        } else {
            this.format((Selector)source);
        }
    }

    private void format(Join join) {
        this.format(join.getLeft());
        this.ws();
        this.formatJoinType(join.getJoinType());
        this.ws();
        this.sb.append("JOIN");
        this.ws();
        this.format(join.getRight());
        this.ws();
        this.sb.append("ON");
        this.ws();
        this.format(join.getJoinCondition());
    }

    private void format(JoinCondition joinCondition) {
        if (joinCondition instanceof EquiJoinCondition) {
            this.format((EquiJoinCondition)joinCondition);
        } else if (joinCondition instanceof ChildNodeJoinCondition) {
            this.format((ChildNodeJoinCondition)joinCondition);
        } else if (joinCondition instanceof DescendantNodeJoinCondition) {
            this.format((DescendantNodeJoinCondition)joinCondition);
        } else {
            this.format((SameNodeJoinCondition)joinCondition);
        }
    }

    private void format(EquiJoinCondition condition) {
        this.formatName(condition.getSelector1Name());
        this.sb.append(".");
        this.formatName(condition.getProperty1Name());
        this.ws();
        this.sb.append("=");
        this.ws();
        this.formatName(condition.getSelector2Name());
        this.sb.append(".");
        this.formatName(condition.getProperty2Name());
    }

    private void format(ChildNodeJoinCondition condition) {
        this.sb.append("ISCHILDNODE(");
        this.formatName(condition.getChildSelectorName());
        this.sb.append(",");
        this.ws();
        this.formatName(condition.getParentSelectorName());
        this.sb.append(")");
    }

    private void format(DescendantNodeJoinCondition condition) {
        this.sb.append("ISDESCENDANTNODE(");
        this.formatName(condition.getDescendantSelectorName());
        this.sb.append(",");
        this.ws();
        this.formatName(condition.getAncestorSelectorName());
        this.sb.append(")");
    }

    private void format(SameNodeJoinCondition condition) {
        this.sb.append("ISSAMENODE(");
        this.formatName(condition.getSelector1Name());
        this.sb.append(",");
        this.ws();
        this.formatName(condition.getSelector2Name());
        if (condition.getSelector2Path() != null) {
            this.sb.append(",");
            this.ws();
            this.formatPath(condition.getSelector2Path());
        }
        this.sb.append(")");
    }

    private void formatPath(String path) {
        if (QOMFormatter.isSimpleName(path)) {
            this.sb.append(path);
        } else {
            this.sb.append("[");
            this.sb.append(path);
            this.sb.append("]");
        }
    }

    private void formatJoinType(String joinType) {
        if (joinType.equals("jcr.join.type.inner")) {
            this.sb.append("INNER");
        } else if (joinType.equals("jcr.join.type.left.outer")) {
            this.sb.append("LEFT OUTER");
        } else {
            this.sb.append("RIGHT OUTER");
        }
    }

    private void format(Selector selector) {
        this.formatName(selector.getNodeTypeName());
        this.ws();
        this.sb.append("AS");
        this.ws();
        this.formatName(selector.getSelectorName());
    }

    private void formatName(String name) {
        if (QOMFormatter.isSimpleName(name)) {
            this.sb.append(name);
        } else {
            this.sb.append("[");
            this.sb.append(name);
            this.sb.append("]");
        }
    }

    private static boolean isSimpleName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!(i == 0 ? !IDENTIFIER_START.get(c) : !IDENTIFIER_PART_OR_UNDERSCORE.get(c))) continue;
            return false;
        }
        return true;
    }

    private void ws() {
        this.sb.append(" ");
    }

    static {
        int c;
        IDENTIFIER_START = new BitSet();
        IDENTIFIER_PART_OR_UNDERSCORE = new BitSet();
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            IDENTIFIER_START.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            IDENTIFIER_START.set(c);
        }
        IDENTIFIER_PART_OR_UNDERSCORE.or(IDENTIFIER_START);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            IDENTIFIER_PART_OR_UNDERSCORE.set(c);
        }
        IDENTIFIER_PART_OR_UNDERSCORE.set(95);
    }
}

