/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;

public class TimeSeriesRecorder
implements TimeSeries {
    private final AtomicLong counter = new AtomicLong();
    private final boolean resetValueEachSecond;
    private final long[] valuePerSecond = new long[60];
    private final long[] valuePerMinute = new long[60];
    private final long[] valuePerHour = new long[168];
    private final long[] valuePerWeek = new long[156];
    private int seconds = 0;
    private int minutes = 0;
    private int hours = 0;
    private int weeks = 0;

    public TimeSeriesRecorder(RepositoryStatistics.Type type) {
        this(type.isResetValueEachSecond());
    }

    public TimeSeriesRecorder(boolean resetValueEachSecond) {
        this.resetValueEachSecond = resetValueEachSecond;
    }

    public AtomicLong getCounter() {
        return this.counter;
    }

    public synchronized void recordOneSecond() {
        this.valuePerSecond[this.seconds++] = this.resetValueEachSecond ? this.counter.getAndSet(0L) : this.counter.get();
        if (this.seconds == this.valuePerSecond.length) {
            this.seconds = 0;
            this.valuePerMinute[this.minutes++] = this.aggregate(this.valuePerSecond);
        }
        if (this.minutes == this.valuePerMinute.length) {
            this.minutes = 0;
            this.valuePerHour[this.hours++] = this.aggregate(this.valuePerMinute);
        }
        if (this.hours == this.valuePerHour.length) {
            this.hours = 0;
            this.valuePerWeek[this.weeks++] = this.aggregate(this.valuePerHour);
        }
        if (this.weeks == this.valuePerWeek.length) {
            this.weeks = 0;
        }
    }

    public synchronized long[] getValuePerSecond() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.valuePerSecond, this.seconds);
    }

    public synchronized long[] getValuePerMinute() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.valuePerMinute, this.minutes);
    }

    public synchronized long[] getValuePerHour() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.valuePerHour, this.hours);
    }

    public synchronized long[] getValuePerWeek() {
        return TimeSeriesRecorder.cyclicCopyFrom(this.valuePerWeek, this.weeks);
    }

    private long aggregate(long[] array) {
        long sum = 0L;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        if (this.resetValueEachSecond) {
            return sum;
        }
        return sum / (long)array.length;
    }

    private static long[] cyclicCopyFrom(long[] array, int pos) {
        long[] reverse = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            reverse[i] = array[(pos + i) % array.length];
        }
        return reverse;
    }
}

