/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.rmi.xml.DefaultContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParsingContentHandler
extends DefaultContentHandler {
    public ParsingContentHandler(ContentHandler handler) {
        super(handler);
    }

    public void parse(InputStream in) throws IOException, SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("SAX parser configuration error", e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }
}

