/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.transaction.xa.XAResource;
import org.apache.jackrabbit.rmi.remote.ArrayIterator;
import org.apache.jackrabbit.rmi.remote.BufferIterator;
import org.apache.jackrabbit.rmi.remote.RemoteEventCollection;
import org.apache.jackrabbit.rmi.remote.RemoteItem;
import org.apache.jackrabbit.rmi.remote.RemoteItemDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.RemoteLock;
import org.apache.jackrabbit.rmi.remote.RemoteNamespaceRegistry;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteNodeDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.remote.RemoteNodeTypeManager;
import org.apache.jackrabbit.rmi.remote.RemoteObservationManager;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.remote.RemotePropertyDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteQuery;
import org.apache.jackrabbit.rmi.remote.RemoteQueryManager;
import org.apache.jackrabbit.rmi.remote.RemoteQueryResult;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.remote.RemoteRow;
import org.apache.jackrabbit.rmi.remote.RemoteSession;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;
import org.apache.jackrabbit.rmi.remote.RemoteWorkspace;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerEventCollection;
import org.apache.jackrabbit.rmi.server.ServerItem;
import org.apache.jackrabbit.rmi.server.ServerItemDefinition;
import org.apache.jackrabbit.rmi.server.ServerLock;
import org.apache.jackrabbit.rmi.server.ServerNamespaceRegistry;
import org.apache.jackrabbit.rmi.server.ServerNode;
import org.apache.jackrabbit.rmi.server.ServerNodeDefinition;
import org.apache.jackrabbit.rmi.server.ServerNodeType;
import org.apache.jackrabbit.rmi.server.ServerNodeTypeManager;
import org.apache.jackrabbit.rmi.server.ServerObservationManager;
import org.apache.jackrabbit.rmi.server.ServerProperty;
import org.apache.jackrabbit.rmi.server.ServerPropertyDefinition;
import org.apache.jackrabbit.rmi.server.ServerQuery;
import org.apache.jackrabbit.rmi.server.ServerQueryManager;
import org.apache.jackrabbit.rmi.server.ServerQueryResult;
import org.apache.jackrabbit.rmi.server.ServerRepository;
import org.apache.jackrabbit.rmi.server.ServerRow;
import org.apache.jackrabbit.rmi.server.ServerSession;
import org.apache.jackrabbit.rmi.server.ServerVersion;
import org.apache.jackrabbit.rmi.server.ServerVersionHistory;
import org.apache.jackrabbit.rmi.server.ServerWorkspace;
import org.apache.jackrabbit.rmi.server.ServerXASession;
import org.apache.jackrabbit.rmi.server.iterator.ServerNodeIterator;
import org.apache.jackrabbit.rmi.server.iterator.ServerNodeTypeIterator;
import org.apache.jackrabbit.rmi.server.iterator.ServerPropertyIterator;
import org.apache.jackrabbit.rmi.server.iterator.ServerRowIterator;
import org.apache.jackrabbit.rmi.server.iterator.ServerVersionIterator;

public class ServerAdapterFactory
implements RemoteAdapterFactory {
    private static final int DEFAULT_BUFFER_SIZE = 100;
    private int bufferSize = 100;
    private int portNumber = Integer.getInteger("org.apache.jackrabbit.rmi.port", 0);

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public RemoteRepository getRemoteRepository(Repository repository) throws RemoteException {
        return new ServerRepository(repository, this);
    }

    public RemoteSession getRemoteSession(Session session) throws RemoteException {
        if (session instanceof XAResource) {
            return new ServerXASession(session, (XAResource)session, this);
        }
        return new ServerSession(session, this);
    }

    public RemoteWorkspace getRemoteWorkspace(Workspace workspace) throws RemoteException {
        return new ServerWorkspace(workspace, this);
    }

    public RemoteObservationManager getRemoteObservationManager(ObservationManager observationManager) throws RemoteException {
        return new ServerObservationManager(observationManager, this);
    }

    public RemoteNamespaceRegistry getRemoteNamespaceRegistry(NamespaceRegistry registry) throws RemoteException {
        return new ServerNamespaceRegistry(registry, this);
    }

    public RemoteNodeTypeManager getRemoteNodeTypeManager(NodeTypeManager manager) throws RemoteException {
        return new ServerNodeTypeManager(manager, this);
    }

    public RemoteItem getRemoteItem(Item item) throws RemoteException {
        return new ServerItem(item, this);
    }

    public RemoteProperty getRemoteProperty(Property property) throws RemoteException {
        return new ServerProperty(property, (RemoteAdapterFactory)this);
    }

    public RemoteNode getRemoteNode(Node node) throws RemoteException {
        return new ServerNode(node, (RemoteAdapterFactory)this);
    }

    public RemoteVersion getRemoteVersion(Version version) throws RemoteException {
        return new ServerVersion(version, (RemoteAdapterFactory)this);
    }

    public RemoteVersionHistory getRemoteVersionHistory(VersionHistory versionHistory) throws RemoteException {
        return new ServerVersionHistory(versionHistory, (RemoteAdapterFactory)this);
    }

    public RemoteNodeType getRemoteNodeType(NodeType type) throws RemoteException {
        return new ServerNodeType(type, this);
    }

    public RemoteItemDefinition getRemoteItemDefinition(ItemDefinition def) throws RemoteException {
        return new ServerItemDefinition(def, this);
    }

    public RemoteNodeDefinition getRemoteNodeDefinition(NodeDefinition def) throws RemoteException {
        return new ServerNodeDefinition(def, (RemoteAdapterFactory)this);
    }

    public RemotePropertyDefinition getRemotePropertyDefinition(PropertyDefinition def) throws RemoteException {
        return new ServerPropertyDefinition(def, (RemoteAdapterFactory)this);
    }

    public RemoteLock getRemoteLock(Lock lock) throws RemoteException {
        return new ServerLock(lock, this);
    }

    public RemoteQueryManager getRemoteQueryManager(Session session, QueryManager manager) throws RemoteException {
        return new ServerQueryManager(session, manager, this);
    }

    public RemoteQuery getRemoteQuery(Query query) throws RemoteException {
        return new ServerQuery(query, this);
    }

    public RemoteQueryResult getRemoteQueryResult(QueryResult result) throws RemoteException {
        return new ServerQueryResult(result, this);
    }

    public RemoteRow getRemoteRow(Row row) throws RemoteException {
        return new ServerRow(row, this);
    }

    public RemoteEventCollection getRemoteEvent(long listenerId, EventIterator events) throws RemoteException {
        RemoteEventCollection.RemoteEvent[] remoteEvents;
        if (events != null) {
            ArrayList<ServerEventCollection.ServerEvent> eventList = new ArrayList<ServerEventCollection.ServerEvent>();
            while (events.hasNext()) {
                try {
                    Event event = events.nextEvent();
                    eventList.add(new ServerEventCollection.ServerEvent(event.getType(), event.getPath(), event.getUserID(), this));
                }
                catch (RepositoryException re) {
                    throw new RemoteException(re.getMessage(), re);
                }
            }
            remoteEvents = eventList.toArray(new RemoteEventCollection.RemoteEvent[eventList.size()]);
        } else {
            remoteEvents = new RemoteEventCollection.RemoteEvent[]{};
        }
        return new ServerEventCollection(listenerId, remoteEvents, this);
    }

    protected RemoteIterator optimizeIterator(RemoteIterator remote) throws RemoteException {
        Object[] elements = remote.nextObjects();
        long size = remote.getSize();
        if (size == -1L || elements != null && size > (long)elements.length) {
            return new BufferIterator(elements, size, remote);
        }
        return new ArrayIterator(elements);
    }

    public RemoteIterator getRemoteNodeIterator(NodeIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerNodeIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemotePropertyIterator(PropertyIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerPropertyIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemoteVersionIterator(VersionIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerVersionIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemoteNodeTypeIterator(NodeTypeIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerNodeTypeIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemoteRowIterator(RowIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerRowIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }
}

